/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.DistributedSystemTestCase;
import com.gemstone.gemfire.admin.internal.InetAddressUtil;
import com.gemstone.gemfire.admin.jmx.internal.AgentConfigImpl;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.util.Properties;
import junit.framework.AssertionFailedError;

public class DistributedSystemTest
extends DistributedSystemTestCase {
    public DistributedSystemTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnect() throws Exception {
        DistributedSystemTest.assertEquals((boolean)true, (boolean)this.system.isConnected());
        DistributionConfig distConfig = ((InternalDistributedSystem)this.system).getConfig();
        String locators = distConfig.getLocators();
        String mcastAddress = InetAddressUtil.toString((Object)distConfig.getMcastAddress());
        int mcastPort = distConfig.getMcastPort();
        this.system.disconnect();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
        config.setLocators(locators);
        config.setMcastAddress(mcastAddress);
        config.setMcastPort(mcastPort);
        config.setRemoteCommand("rsh -n {HOST} {CMD}");
        DistributedSystemTest.assertNotNull((Object)config);
        AdminDistributedSystem distSys = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        DistributedSystemTest.assertNotNull((Object)distSys);
        distSys.connect();
        try {
            boolean passed = false;
            int tries = 3;
            for (int i = 0; i < tries && !passed; ++i) {
                try {
                    DistributedSystemTest.assertTrue((boolean)distSys.isConnected());
                    passed = true;
                    continue;
                }
                catch (AssertionFailedError e) {
                    if (i >= tries - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            distSys.disconnect();
            DistributedSystemTest.assertTrue((!distSys.isConnected() ? 1 : 0) != 0);
            DistributedSystemTest.assertTrue((!distSys.isRunning() ? 1 : 0) != 0);
            throw throwable;
        }
        distSys.disconnect();
        DistributedSystemTest.assertTrue((!distSys.isConnected() ? 1 : 0) != 0);
        DistributedSystemTest.assertTrue((!distSys.isRunning() ? 1 : 0) != 0);
    }

    public void testAgentProperties() {
        Properties props = new AgentConfigImpl().toProperties();
        for (String string : props.keySet()) {
            AgentConfigImpl.getPropertyDescription((String)string);
        }
    }

    public void testAdministerDS() throws Exception {
        DistributedSystem system = this.system;
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        InternalDistributedSystem system2 = ((AdminDistributedSystemImpl)admin).getAdminAgent().getDSConnection();
        DistributedSystemTest.assertSame((Object)system, (Object)system2);
        admin.disconnect();
    }
}

