/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Set;

public class SystemMemberRegionDUnitTest
extends AdminDUnitTestCase {
    public SystemMemberRegionDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() {
        SystemMemberRegionDUnitTest.disconnectAllFromDS();
    }

    public void testRegionAttributes() throws Exception {
        SystemMemberRegionDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        VM vm = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName() + "_root";
        int concurrencyLevel = 25;
        int initialCapacity = 200;
        float loadFactor = 0.86f;
        boolean statisticsEnabled = true;
        final File diskDir = new File(this.getUniqueName()).getCanonicalFile();
        diskDir.mkdirs();
        DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
        dwaf.setBytesThreshold(456L);
        dwaf.setTimeInterval(123L);
        final DiskWriteAttributes dwa = dwaf.create();
        final ExpirationAttributes entryIdle = new ExpirationAttributes(76, ExpirationAction.INVALIDATE);
        final ExpirationAttributes entryTtl = new ExpirationAttributes(82, ExpirationAction.DESTROY);
        final DataPolicy dataPolicy = DataPolicy.REPLICATE;
        final ExpirationAttributes regionIdle = new ExpirationAttributes(77, ExpirationAction.DESTROY);
        final ExpirationAttributes regionTtl = new ExpirationAttributes(92, ExpirationAction.INVALIDATE);
        final Scope scope = Scope.DISTRIBUTED_ACK;
        final Long userAttribute = new Long(241234L);
        final AdminDistributedSystem tc = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberRegionDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setCacheListener((CacheListener)new CacheListener2());
                factory.setCacheLoader((CacheLoader)new CacheLoader2());
                factory.setCacheWriter((CacheWriter)new CacheWriter2());
                factory.setConcurrencyLevel(25);
                factory.setDiskDirs(new File[]{diskDir});
                factory.setDiskWriteAttributes(dwa);
                factory.setStatisticsEnabled(true);
                factory.setEntryIdleTimeout(entryIdle);
                factory.setEntryTimeToLive(entryTtl);
                factory.setInitialCapacity(200);
                factory.setKeyConstraint(String.class);
                factory.setLoadFactor(0.86f);
                factory.setDataPolicy(dataPolicy);
                factory.setRegionIdleTimeout(regionIdle);
                factory.setRegionTimeToLive(regionTtl);
                factory.setScope(scope);
                factory.setEarlyAck(false);
                MembershipAttributes membershipAttributes = new MembershipAttributes(new String[]{"A"}, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
                factory.setMembershipAttributes(membershipAttributes);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion(name, attrs);
                region.setUserAttribute(userAttribute);
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return tc.getSystemMemberApplications().length == 1;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications length never became exactly 1";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
        SystemMember[] apps = tc.getSystemMemberApplications();
        if (apps.length != 1) {
            StringBuffer sb = new StringBuffer("Applications are ");
            for (int i = 0; i < apps.length; ++i) {
                sb.append(apps[i]);
                sb.append(" ");
            }
            SystemMemberRegionDUnitTest.assertEquals((String)sb.toString(), (int)1, (int)apps.length);
        }
        SystemMemberCache cache = this.waitForCache(vm);
        cache.refresh();
        Set names = cache.getRootRegionNames();
        SystemMemberRegionDUnitTest.assertEquals((int)1, (int)names.size());
        SystemMemberRegionDUnitTest.assertEquals((String)name, (String)((String)names.iterator().next()));
        SystemMemberRegion root = cache.getRegion(name);
        SystemMemberRegionDUnitTest.assertNotNull((Object)root);
        String expected = CacheListener2.class.getName();
        String actual = root.getCacheListener();
        if (!expected.equals(actual)) {
            String s = "Expected <" + expected + "> got <" + actual + ">";
            SystemMemberRegionDUnitTest.fail((String)s);
        }
        SystemMemberRegionDUnitTest.assertEquals((String)CacheLoader2.class.getName(), (String)root.getCacheLoader());
        SystemMemberRegionDUnitTest.assertEquals((String)CacheWriter2.class.getName(), (String)root.getCacheWriter());
        SystemMemberRegionDUnitTest.assertNotNull((Object)root.getEvictionAttributes());
        SystemMemberRegionDUnitTest.assertNotNull((Object)root.getEvictionAttributes().getAction());
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getEvictionAttributes().getAction().isNone());
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getEvictionAttributes().getAlgorithm().isNone());
        SystemMemberRegionDUnitTest.assertEquals((int)25, (int)root.getConcurrencyLevel());
        File[] diskDirs = root.getDiskDirs();
        SystemMemberRegionDUnitTest.assertEquals((int)1, (int)diskDirs.length);
        SystemMemberRegionDUnitTest.assertEquals((Object)diskDir, (Object)diskDirs[0]);
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getStatisticsEnabled());
        SystemMemberRegionDUnitTest.assertEquals((Object)entryIdle.getAction(), (Object)root.getEntryIdleTimeoutAction());
        SystemMemberRegionDUnitTest.assertEquals((int)entryIdle.getTimeout(), (int)root.getEntryIdleTimeoutTimeLimit());
        SystemMemberRegionDUnitTest.assertEquals((Object)entryTtl.getAction(), (Object)root.getEntryTimeToLiveAction());
        SystemMemberRegionDUnitTest.assertEquals((int)entryTtl.getTimeout(), (int)root.getEntryTimeToLiveTimeLimit());
        SystemMemberRegionDUnitTest.assertEquals((int)200, (int)root.getInitialCapacity());
        SystemMemberRegionDUnitTest.assertEquals((String)String.class.getName(), (String)root.getKeyConstraint());
        SystemMemberRegionDUnitTest.assertEquals((float)0.86f, (float)root.getLoadFactor(), (float)0.0f);
        SystemMemberRegionDUnitTest.assertEquals((Object)dataPolicy, (Object)root.getDataPolicy());
        SystemMemberRegionDUnitTest.assertEquals((Object)regionIdle.getAction(), (Object)root.getRegionIdleTimeoutAction());
        SystemMemberRegionDUnitTest.assertEquals((int)regionIdle.getTimeout(), (int)root.getRegionIdleTimeoutTimeLimit());
        SystemMemberRegionDUnitTest.assertEquals((Object)regionTtl.getAction(), (Object)root.getRegionTimeToLiveAction());
        SystemMemberRegionDUnitTest.assertEquals((int)regionTtl.getTimeout(), (int)root.getRegionTimeToLiveTimeLimit());
        SystemMemberRegionDUnitTest.assertEquals((Object)scope, (Object)root.getScope());
        SystemMemberRegionDUnitTest.assertTrue((!root.getEarlyAck() ? 1 : 0) != 0);
        String attrDesc = root.getUserAttribute();
        SystemMemberRegionDUnitTest.assertTrue((attrDesc.indexOf(((Object)userAttribute).toString()) != -1 ? 1 : 0) != 0);
        SystemMemberRegionDUnitTest.assertNotNull((Object)root.getMembershipAttributes());
        SystemMemberRegionDUnitTest.assertTrue((root.getMembershipAttributes().getRequiredRoles().size() == 1 ? 1 : 0) != 0);
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getMembershipAttributes().getRequiredRoles().contains(InternalRole.getRole((String)"A")));
        SystemMemberRegionDUnitTest.assertNotNull((Object)root.getMembershipAttributes().getLossAction());
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getMembershipAttributes().getLossAction().isLimitedAccess());
        SystemMemberRegionDUnitTest.assertNotNull((Object)root.getMembershipAttributes().getResumptionAction());
        SystemMemberRegionDUnitTest.assertTrue((boolean)root.getMembershipAttributes().getResumptionAction().isNone());
    }

    public static DistributedMember getMyName() {
        Cache cache2;
        try {
            cache2 = CacheFactory.getAnyInstance();
        }
        catch (CancelException e) {
            return null;
        }
        DistributedMember result = cache2.getDistributedSystem().getDistributedMember();
        return result;
    }

    private SystemMemberCache waitForCache(VM vm) throws Exception {
        long deadLine = System.currentTimeMillis() + 60000L;
        while (true) {
            DistributedMember vmdm;
            if ((vmdm = (DistributedMember)vm.invoke(SystemMemberRegionDUnitTest.class, "getMyName")) != null) {
                SystemMember[] allMembers = this.tcSystem.getSystemMemberApplications();
                for (int i = 0; i < allMembers.length; ++i) {
                    SystemMember s = allMembers[i];
                    DistributedMember sdm = s.getDistributedMember();
                    SystemMemberRegionDUnitTest.assertTrue((sdm != null ? 1 : 0) != 0);
                    if (!sdm.equals(vmdm)) continue;
                    SystemMemberCache cache = s.getCache();
                    SystemMemberRegionDUnitTest.assertNotNull((Object)cache);
                    return cache;
                }
            }
            if (System.currentTimeMillis() >= deadLine) break;
            SystemMemberRegionDUnitTest.pause(2000);
        }
        return null;
    }

    public void testRegionAPIStatistics() throws Exception {
        VM vm = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName() + "_root";
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberRegionDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setStatisticsEnabled(true);
                RegionAttributes attrs = factory.create();
                cache.createRegion(name, attrs);
            }
        });
        SystemMemberCache cache = this.waitForCache(vm);
        cache.refresh();
        Set names = cache.getRootRegionNames();
        SystemMemberRegionDUnitTest.assertEquals((int)1, (int)names.size());
        SystemMemberRegionDUnitTest.assertEquals((String)name, (String)((String)names.iterator().next()));
        SystemMemberRegion root = cache.getRegion(name);
        SystemMemberRegionDUnitTest.assertNotNull((Object)root);
        SystemMemberRegionDUnitTest.assertEquals((long)0L, (long)root.getHitCount());
        SystemMemberRegionDUnitTest.assertEquals((long)0L, (long)root.getMissCount());
        int entryCount = 5;
        vm.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Cache cache2 = CacheFactory.getAnyInstance();
                Region region = cache2.getRegion(name);
                for (int i = 0; i < 5; ++i) {
                    Integer key = new Integer(i);
                    String value = String.valueOf(i);
                    region.get((Object)key);
                    region.put((Object)key, (Object)value);
                    region.get((Object)key);
                    region.get((Object)key);
                }
            }
        });
        root.refresh();
        SystemMemberRegionDUnitTest.assertEquals((int)5, (int)root.getEntryCount());
        SystemMemberRegionDUnitTest.assertEquals((long)10L, (long)root.getHitCount());
        SystemMemberRegionDUnitTest.assertEquals((long)5L, (long)root.getMissCount());
        SystemMemberRegionDUnitTest.assertEquals((float)0.6666667f, (float)root.getHitRatio(), (float)0.0f);
        long lastAccessed = root.getLastAccessedTime();
        long lastModified = root.getLastModifiedTime();
        vm.invoke(new CacheSerializableRunnable("Access region"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    DistributedTestCase.fail("Why was I interrupted?", ex);
                }
                Cache cache2 = CacheFactory.getAnyInstance();
                Region region = cache2.getRegion(name);
                for (int i = 0; i < 5; ++i) {
                    Integer key = new Integer(i);
                    region.get((Object)key);
                }
            }
        });
        root.refresh();
        SystemMemberRegionDUnitTest.assertEquals((long)lastModified, (long)root.getLastModifiedTime());
        SystemMemberRegionDUnitTest.assertTrue((lastAccessed < root.getLastAccessedTime() ? 1 : 0) != 0);
    }

    public void testSubregions() throws Exception {
        Host host = Host.getHost(0);
        int rootRegionCount = 2;
        int subregionCount = 4;
        int entryCount = 10;
        for (int i = 0; i < host.getVMCount(); ++i) {
            VM vm = host.getVM(i);
            vm.invoke(new CacheSerializableRunnable("Create regions"){

                @Override
                public void run2() throws CacheException {
                    Cache cache = SystemMemberRegionDUnitTest.this.getCache();
                    AttributesFactory factory = new AttributesFactory();
                    RegionAttributes attrs = factory.create();
                    for (int i2 = 0; i2 < 2; ++i2) {
                        int j;
                        Region root = cache.createRegion("Root" + i2, attrs);
                        for (j = 0; j < 10; ++j) {
                            String key = String.valueOf(j);
                            Integer value = new Integer(j);
                            root.put((Object)key, (Object)value);
                        }
                        for (j = 0; j < 4; ++j) {
                            String name = "Subregion-" + i2 + "-" + j;
                            Region subregion = root.createSubregion(name, attrs);
                            for (int k = 0; k < 10; ++k) {
                                String key = String.valueOf(k);
                                Integer value = new Integer(k);
                                subregion.put((Object)key, (Object)value);
                            }
                        }
                    }
                }
            });
        }
        AdminDistributedSystem tc = this.tcSystem;
        SystemMember[] members = tc.getSystemMemberApplications();
        SystemMemberRegionDUnitTest.assertEquals((int)host.getVMCount(), (int)members.length);
        for (int i = 0; i < host.getVMCount(); ++i) {
            SystemMemberCache cache = this.waitForCache(host.getVM(i));
            SystemMemberRegionDUnitTest.assertNotNull((Object)cache);
            cache.refresh();
            Set roots = cache.getRootRegionNames();
            SystemMemberRegionDUnitTest.assertEquals((int)2, (int)roots.size());
            for (String rootName : roots) {
                SystemMemberRegion root = cache.getRegion(rootName);
                SystemMemberRegionDUnitTest.assertNotNull((Object)root);
                SystemMemberRegionDUnitTest.assertEquals((int)10, (int)root.getEntryCount());
                SystemMemberRegionDUnitTest.assertTrue((boolean)root.getName().startsWith("Root"));
                SystemMemberRegionDUnitTest.assertTrue((String)(root.getFullPath() + " doesn't start with \"Root\""), (boolean)root.getFullPath().startsWith("/Root"));
                Set subregions = root.getSubregionNames();
                SystemMemberRegionDUnitTest.assertEquals((int)4, (int)subregions.size());
                subregions = root.getSubregionFullPaths();
                for (String subPath : subregions) {
                    SystemMemberRegion subregion = cache.getRegion(subPath);
                    SystemMemberRegionDUnitTest.assertNotNull((String)("Could not get subregion \"" + subPath + "\""), (Object)subregion);
                    SystemMemberRegionDUnitTest.assertEquals((int)10, (int)subregion.getEntryCount());
                    SystemMemberRegionDUnitTest.assertTrue((boolean)subregion.getName().startsWith("Subregion"));
                    SystemMemberRegionDUnitTest.assertTrue((boolean)subregion.getFullPath().startsWith("/Root"));
                }
            }
        }
    }

    public void testRegionAttributeCacheListener() throws Exception {
        SystemMemberRegionDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        VM vm = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName() + "_root";
        final Scope scope = Scope.DISTRIBUTED_ACK;
        final AdminDistributedSystem tc = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberRegionDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.addCacheListener((CacheListener)new CacheListener2());
                factory.setScope(scope);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion(name, attrs);
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return tc.getSystemMemberApplications().length == 1;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications length never became exactly 1";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
        SystemMember[] apps = tc.getSystemMemberApplications();
        if (apps.length != 1) {
            StringBuffer sb = new StringBuffer("Applications are ");
            for (int i = 0; i < apps.length; ++i) {
                sb.append(apps[i]);
                sb.append(" ");
            }
            SystemMemberRegionDUnitTest.assertEquals((String)sb.toString(), (int)1, (int)apps.length);
        }
        SystemMemberCache cache = this.waitForCache(vm);
        cache.refresh();
        Set names = cache.getRootRegionNames();
        SystemMemberRegionDUnitTest.assertEquals((int)1, (int)names.size());
        SystemMemberRegionDUnitTest.assertEquals((String)name, (String)((String)names.iterator().next()));
        SystemMemberRegion root = cache.getRegion(name);
        SystemMemberRegionDUnitTest.assertNotNull((Object)root);
        String expected = CacheListener2.class.getName();
        String actual = root.getCacheListener();
        if (!expected.equals(actual)) {
            String s = "Expected <" + expected + "> got <" + actual + ">";
            SystemMemberRegionDUnitTest.fail((String)s);
        }
    }

    public void testRegionMethodGetCacheListeners() throws Exception {
        String s;
        SystemMemberRegionDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        VM vm = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName() + "_root";
        final Scope scope = Scope.DISTRIBUTED_ACK;
        final AdminDistributedSystem tc = this.tcSystem;
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = SystemMemberRegionDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.addCacheListener((CacheListener)new CacheListener2());
                factory.addCacheListener((CacheListener)new CacheListener1());
                factory.setScope(scope);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion(name, attrs);
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return tc.getSystemMemberApplications().length == 1;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications length never became exactly 1";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
        SystemMember[] apps = tc.getSystemMemberApplications();
        if (apps.length != 1) {
            StringBuffer sb = new StringBuffer("Applications are ");
            for (int i = 0; i < apps.length; ++i) {
                sb.append(apps[i]);
                sb.append(" ");
            }
            SystemMemberRegionDUnitTest.assertEquals((String)sb.toString(), (int)1, (int)apps.length);
        }
        SystemMemberCache cache = this.waitForCache(vm);
        cache.refresh();
        Set names = cache.getRootRegionNames();
        SystemMemberRegionDUnitTest.assertEquals((int)1, (int)names.size());
        SystemMemberRegionDUnitTest.assertEquals((String)name, (String)((String)names.iterator().next()));
        SystemMemberRegion root = cache.getRegion(name);
        SystemMemberRegionDUnitTest.assertNotNull((Object)root);
        String[] expected = new String[]{CacheListener2.class.getName(), CacheListener1.class.getName()};
        int expectedSize = 2;
        String[] actuals = root.getCacheListeners();
        if (expectedSize != actuals.length) {
            s = "Expected <" + expectedSize + "> got <" + actuals.length + ">";
            SystemMemberRegionDUnitTest.fail((String)s);
        }
        if (!expected[0].equals(actuals[0]) && !expected[0].equals(actuals[1])) {
            s = "Expected <" + expected[0] + "> got <" + actuals[0] + ", " + actuals[1] + ">";
            SystemMemberRegionDUnitTest.fail((String)s);
        }
        if (!expected[1].equals(actuals[0]) && !expected[1].equals(actuals[1])) {
            s = "Expected <" + expected[1] + "> got <" + actuals[0] + ", " + actuals[1] + ">";
            SystemMemberRegionDUnitTest.fail((String)s);
        }
        String actual = root.getCacheListener();
        String expectedOne = CacheListener2.class.getName();
        if (!expectedOne.equals(actual)) {
            String s2 = "Expected <" + expectedOne + "> got <" + actual + ">";
            SystemMemberRegionDUnitTest.fail((String)s2);
        }
    }

    static class CacheListener1
    extends CacheListenerAdapter {
        CacheListener1() {
        }
    }

    static class CacheWriter2
    extends CacheWriterAdapter {
        CacheWriter2() {
        }
    }

    static class CacheListener2
    extends CacheListenerAdapter {
        CacheListener2() {
        }
    }

    static class CacheLoader2
    implements CacheLoader {
        CacheLoader2() {
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return null;
        }

        public void close() {
        }
    }
}

