/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.SystemMemberCacheEvent;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import junit.framework.TestCase;

public class SystemMemberCacheListenerDUnitTest
extends AdminDUnitTestCase {
    protected volatile int listenerInvoked = 0;
    protected volatile boolean createInvoked = false;
    protected volatile boolean lossInvoked = false;
    protected volatile transient SystemMemberRegionEvent lastEvent = null;
    protected volatile transient SystemMemberCacheEvent lastCacheEvent = null;
    private transient DistributedMember otherId;
    private static final String WAIT_PROPERTY = "SystemMemberCacheListenerDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 40000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEventState() {
        SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            this.listenerInvoked = 0;
            this.createInvoked = false;
            this.lossInvoked = false;
            this.lastEvent = null;
            this.lastCacheEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNoEventState() {
        SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals((int)0, (int)this.listenerInvoked);
            SystemMemberCacheListenerDUnitTest.assertEquals(null, (Object)this.lastEvent);
            SystemMemberCacheListenerDUnitTest.assertEquals(null, (Object)this.lastCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getListenerInvoked() {
        SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            return this.listenerInvoked;
        }
    }

    private void waitForListenerInvoke(final int expected) throws Exception {
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 40000);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return SystemMemberCacheListenerDUnitTest.this.getListenerInvoked() >= expected;
            }

            @Override
            public String description() {
                return "listener invocations never reached " + expected;
            }
        };
        DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
        SystemMemberCacheListenerDUnitTest.assertEquals((String)"waitForListenerInvoke listener invoked not equal to expected", (int)expected, (int)this.getListenerInvoked());
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheListenerDUnitTest.this.getCache();
            }
        });
        this.otherId = (DistributedMember)vm.invoke(SystemMemberCacheListenerDUnitTest.class, "getVMDistributedMember");
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    public SystemMemberCacheListenerDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegionInVM(final String name, VM vm) throws Exception {
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                SystemMemberCacheListenerDUnitTest.this.createRootRegion(name, af.create());
            }
        });
        this.waitForListenerInvoke(1);
        SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals(null, (Object)this.lastCacheEvent);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.REGION_CREATE, (Object)this.lastEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((String)("/" + name), (String)this.lastEvent.getRegionPath());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastEvent.getDistributedMember());
            SystemMemberCacheListenerDUnitTest.assertEquals((boolean)true, (boolean)this.createInvoked);
        }
        this.clearEventState();
    }

    public static DistributedMember getMemberId() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheListener() throws Exception {
        this.clearEventState();
        this.initOtherId();
        VM cacheVM = this.getOtherVm();
        ArrayList<Object> ids = new ArrayList<Object>();
        ids.add(cacheVM.invoke(SystemMemberCacheListenerDUnitTest.class, "getMemberId"));
        TestSystemMemberCacheListener cacheListener = new TestSystemMemberCacheListener(ids);
        this.tcSystem.addCacheListener((SystemMemberCacheListener)cacheListener);
        long endTime = System.currentTimeMillis() + 5000L;
        while (this.getListenerInvoked() == 0 && System.currentTimeMillis() > endTime) {
            SystemMemberCacheListenerDUnitTest.pause(100);
        }
        if (this.getListenerInvoked() != 0) {
            this.clearEventState();
        }
        this.assertNoEventState();
        this.createRegionInVM("r1", cacheVM);
        cacheVM.invoke(new CacheSerializableRunnable("destroy region"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheListenerDUnitTest.this.getRootRegion("r1").destroyRegion();
            }
        });
        this.waitForListenerInvoke(1);
        SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals((boolean)true, (boolean)this.lossInvoked);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.REGION_DESTROY, (Object)this.lastEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((String)"/r1", (String)this.lastEvent.getRegionPath());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastEvent.getDistributedMember());
        }
        this.clearEventState();
        this.createRegionInVM("r2", cacheVM);
        cacheVM.invoke(new CacheSerializableRunnable("local destroy region"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheListenerDUnitTest.this.getRootRegion("r2").localDestroyRegion();
            }
        });
        this.waitForListenerInvoke(1);
        systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals((boolean)true, (boolean)this.lossInvoked);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.REGION_LOCAL_DESTROY, (Object)this.lastEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((String)"/r2", (String)this.lastEvent.getRegionPath());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastEvent.getDistributedMember());
        }
        this.clearEventState();
        this.createRegionInVM("r3", cacheVM);
        cacheVM.invoke(new CacheSerializableRunnable("close region"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheListenerDUnitTest.this.getRootRegion("r3").close();
            }
        });
        this.waitForListenerInvoke(1);
        systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals((boolean)true, (boolean)this.lossInvoked);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.REGION_CLOSE, (Object)this.lastEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((String)"/r3", (String)this.lastEvent.getRegionPath());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastEvent.getDistributedMember());
        }
        this.clearEventState();
        this.createRegionInVM("r4", cacheVM);
        cacheVM.invoke(new CacheSerializableRunnable("close cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheTestCase.basicGetCache();
                TestCase.assertTrue((cache != null && !cache.isClosed() ? 1 : 0) != 0);
                CacheTestCase.closeCache();
            }
        });
        this.waitForListenerInvoke(2);
        systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals((boolean)true, (boolean)this.lossInvoked);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.CACHE_CLOSE, (Object)this.lastEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((String)"/r4", (String)this.lastEvent.getRegionPath());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastEvent.getDistributedMember());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.CACHE_CLOSE, (Object)this.lastCacheEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastCacheEvent.getDistributedMember());
        }
        this.clearEventState();
        cacheVM.invoke(new CacheSerializableRunnable("create cache"){

            @Override
            public void run2() throws CacheException {
                SystemMemberCacheListenerDUnitTest.this.getCache();
            }
        });
        this.waitForListenerInvoke(1);
        systemMemberCacheListenerDUnitTest = this;
        synchronized (systemMemberCacheListenerDUnitTest) {
            SystemMemberCacheListenerDUnitTest.assertEquals(null, (Object)this.lastEvent);
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)Operation.CACHE_CREATE, (Object)this.lastCacheEvent.getOperation());
            SystemMemberCacheListenerDUnitTest.assertEquals((Object)this.otherId, (Object)this.lastCacheEvent.getDistributedMember());
        }
        this.clearEventState();
    }

    class TestSystemMemberCacheListener
    implements SystemMemberCacheListener {
        final ArrayList ids;

        public TestSystemMemberCacheListener(ArrayList ids) {
            this.ids = ids;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionCreate(SystemMemberRegionEvent event) {
            if (!this.ids.contains(event.getDistributedMember())) {
                return;
            }
            SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = SystemMemberCacheListenerDUnitTest.this;
            synchronized (systemMemberCacheListenerDUnitTest) {
                ++SystemMemberCacheListenerDUnitTest.this.listenerInvoked;
                SystemMemberCacheListenerDUnitTest.this.createInvoked = true;
                SystemMemberCacheListenerDUnitTest.this.lastEvent = event;
            }
            DistributedTestCase.getLogWriter().info("DEBUG afterRegionCreate=" + event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionLoss(SystemMemberRegionEvent event) {
            if (!this.ids.contains(event.getDistributedMember())) {
                return;
            }
            SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = SystemMemberCacheListenerDUnitTest.this;
            synchronized (systemMemberCacheListenerDUnitTest) {
                ++SystemMemberCacheListenerDUnitTest.this.listenerInvoked;
                SystemMemberCacheListenerDUnitTest.this.lossInvoked = true;
                SystemMemberCacheListenerDUnitTest.this.lastEvent = event;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCacheCreate(SystemMemberCacheEvent event) {
            if (!this.ids.contains(event.getDistributedMember())) {
                return;
            }
            SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = SystemMemberCacheListenerDUnitTest.this;
            synchronized (systemMemberCacheListenerDUnitTest) {
                ++SystemMemberCacheListenerDUnitTest.this.listenerInvoked;
                SystemMemberCacheListenerDUnitTest.this.lastCacheEvent = event;
            }
            DistributedTestCase.getLogWriter().info("DEBUG afterCacheCreate=" + event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCacheClose(SystemMemberCacheEvent event) {
            if (!this.ids.contains(event.getDistributedMember())) {
                return;
            }
            SystemMemberCacheListenerDUnitTest systemMemberCacheListenerDUnitTest = SystemMemberCacheListenerDUnitTest.this;
            synchronized (systemMemberCacheListenerDUnitTest) {
                ++SystemMemberCacheListenerDUnitTest.this.listenerInvoked;
                SystemMemberCacheListenerDUnitTest.this.lastCacheEvent = event;
            }
        }
    }
}

