/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.DistributionLocatorImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class AdminAndCacheDUnitTest
extends CacheTestCase {
    public AdminAndCacheDUnitTest(String name) {
        super(name);
    }

    public void testCacheAndRegions() throws Exception {
        AdminAndCacheDUnitTest.disconnectAllFromDS();
        InternalDistributedSystem system = this.getSystem();
        AdminAndCacheDUnitTest.assertTrue((!system.getConfig().getLocators().equals("") ? 1 : 0) != 0);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminAndCacheDUnitTest.assertEquals((String)system.getConfig().getLocators(), (String)config.getLocators());
        AdminAndCacheDUnitTest.assertEquals((int)system.getConfig().getMcastPort(), (int)config.getMcastPort());
        AdminAndCacheDUnitTest.getLogWriter().info("Locators are: " + config.getLocators() + ", mcast port is: " + config.getMcastPort());
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        AdminAndCacheDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
        AdminAndCacheDUnitTest.assertEquals((int)1, (int)admin.getSystemMemberApplications().length);
        SystemMember me = admin.getSystemMemberApplications()[0];
        AdminAndCacheDUnitTest.assertNotNull((Object)me);
        AdminAndCacheDUnitTest.assertFalse((boolean)me.hasCache());
        this.getCache();
        AdminAndCacheDUnitTest.assertTrue((boolean)me.hasCache());
        SystemMemberCache adminCache = me.getCache();
        AdminAndCacheDUnitTest.assertNotNull((Object)adminCache);
        AdminAndCacheDUnitTest.assertEquals((int)0, (int)adminCache.getRootRegionNames().size());
        RegionAttributes attrs = new AttributesFactory().create();
        String rootName = "root";
        this.createRootRegion(rootName, attrs);
        adminCache.refresh();
        AdminAndCacheDUnitTest.assertEquals((int)1, (int)adminCache.getRootRegionNames().size());
        AdminAndCacheDUnitTest.assertEquals((Object)rootName, adminCache.getRootRegionNames().iterator().next());
    }

    public void testOtherCacheAndRegions() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        AdminAndCacheDUnitTest.disconnectAllFromDS();
        AdminAndCacheDUnitTest.assertNull((Object)AdminDistributedSystemImpl.getConnectedInstance());
        ExpirationAttributes ttl = new ExpirationAttributes(300, ExpirationAction.DESTROY);
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setEntryIdleTimeout(ttl);
        final RegionAttributes attrs = factory.create();
        final String rootName = this.getUniqueName();
        CacheSerializableRunnable connect = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AdminAndCacheDUnitTest.this.createRootRegion(rootName, attrs);
            }
        };
        vm0.invoke(connect);
        vm1.invoke(connect);
        connect.run();
        InternalDistributedSystem system = this.getSystem();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        AdminAndCacheDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
        SystemMember[] members = admin.getSystemMemberApplications();
        if (members.length != 3) {
            StringBuffer sb = new StringBuffer();
            sb.append(members.length);
            sb.append(" members: ");
            for (int i = 0; i < members.length; ++i) {
                sb.append(members[i]);
                sb.append(" ");
            }
            AdminAndCacheDUnitTest.assertEquals((String)sb.toString(), (int)3, (int)members.length);
        }
        for (int i = 0; i < members.length; ++i) {
            SystemMember member = members[i];
            AdminAndCacheDUnitTest.assertTrue((boolean)member.hasCache());
            SystemMemberCache cache = member.getCache();
            Set roots = cache.getRootRegionNames();
            AdminAndCacheDUnitTest.assertEquals((int)1, (int)roots.size());
            AdminAndCacheDUnitTest.assertEquals((Object)rootName, roots.iterator().next());
            SystemMemberRegion root = cache.getRegion(rootName);
            AdminAndCacheDUnitTest.assertNotNull((Object)root);
            AdminAndCacheDUnitTest.assertEquals((int)0, (int)root.getEntryCount());
            AdminAndCacheDUnitTest.assertEquals((int)ttl.getTimeout(), (int)root.getEntryIdleTimeoutTimeLimit());
            AdminAndCacheDUnitTest.assertEquals((Object)ttl.getAction(), (Object)root.getEntryIdleTimeoutAction());
        }
    }

    public void testBug39747() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AdminAndCacheDUnitTest.disconnectAllFromDS();
        AdminAndCacheDUnitTest.assertNull((Object)AdminDistributedSystemImpl.getConnectedInstance());
        ExpirationAttributes ttl = new ExpirationAttributes(300, ExpirationAction.DESTROY);
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setEntryIdleTimeout(ttl);
        final RegionAttributes attrs = factory.create();
        final String rootName = this.getUniqueName();
        CacheSerializableRunnable connect = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AdminAndCacheDUnitTest.this.createRootRegion(rootName, attrs);
            }
        };
        vm0.invoke(connect);
        connect.run();
        InternalDistributedSystem system = this.getSystem();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        AdminAndCacheDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
        SerializableRunnable verify0 = new SerializableRunnable("verify0"){

            @Override
            public void run() {
                InternalDistributedSystem ds = AdminAndCacheDUnitTest.this.getSystem();
                int retry = 100;
                while (retry-- > 0 && ds.getDistributionManager().getAdminMemberSet().size() != 1) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals((int)1, (int)ds.getDistributionManager().getAdminMemberSet().size());
                TestCase.assertEquals((int)1, (int)ds.getDistributionManager().getOtherNormalDistributionManagerIds().size());
            }
        };
        vm0.invoke(verify0);
        admin.disconnect();
        SerializableRunnable verify1 = new SerializableRunnable("verify1"){

            @Override
            public void run() {
                InternalDistributedSystem ds = AdminAndCacheDUnitTest.this.getSystem();
                int retry = 100;
                while (retry-- > 0 && ds.getDistributionManager().getAdminMemberSet().size() > 0) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals(new HashSet(), (Object)ds.getDistributionManager().getAdminMemberSet());
                TestCase.assertEquals((int)1, (int)ds.getDistributionManager().getOtherNormalDistributionManagerIds().size());
            }
        };
        vm0.invoke(verify1);
        system.disconnect();
        SerializableRunnable verify2 = new SerializableRunnable("verify2"){

            @Override
            public void run() {
                InternalDistributedSystem ds = AdminAndCacheDUnitTest.this.getSystem();
                int retry = 100;
                while (retry-- > 0 && ds.getDistributionManager().getOtherNormalDistributionManagerIds().size() > 0) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals(new HashSet(), (Object)ds.getDistributionManager().getOtherNormalDistributionManagerIds());
            }
        };
        vm0.invoke(verify2);
    }

    public void testNoAdminDisconnect() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AdminAndCacheDUnitTest.disconnectAllFromDS();
        AdminAndCacheDUnitTest.assertNull((Object)AdminDistributedSystemImpl.getConnectedInstance());
        ExpirationAttributes ttl = new ExpirationAttributes(300, ExpirationAction.DESTROY);
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setEntryIdleTimeout(ttl);
        final RegionAttributes attrs = factory.create();
        final String rootName = this.getUniqueName();
        CacheSerializableRunnable connect = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AdminAndCacheDUnitTest.this.createRootRegion(rootName, attrs);
            }
        };
        vm0.invoke(connect);
        connect.run();
        InternalDistributedSystem system = this.getSystem();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        AdminAndCacheDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
        SerializableRunnable verify0 = new SerializableRunnable("verify0"){

            @Override
            public void run() {
                InternalDistributedSystem ds = AdminAndCacheDUnitTest.this.getSystem();
                int retry = 100;
                while (retry-- > 0 && ds.getDistributionManager().getAdminMemberSet().size() != 1) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals((int)1, (int)ds.getDistributionManager().getAdminMemberSet().size());
                TestCase.assertEquals((int)1, (int)ds.getDistributionManager().getOtherNormalDistributionManagerIds().size());
            }
        };
        vm0.invoke(verify0);
        system.disconnect();
        SerializableRunnable verify2 = new SerializableRunnable("verify2"){

            @Override
            public void run() {
                InternalDistributedSystem ds = AdminAndCacheDUnitTest.this.getSystem();
                int retry = 100;
                while (retry-- > 0 && ds.getDistributionManager().getAdminMemberSet().size() > 0) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals(new HashSet(), (Object)ds.getDistributionManager().getOtherNormalDistributionManagerIds());
                TestCase.assertEquals((int)0, (int)ds.getDistributionManager().getAdminMemberSet().size());
            }
        };
        vm0.invoke(verify2);
    }

    public void testDistributionLocatorIsRunning() throws Exception {
        AdminAndCacheDUnitTest.disconnectAllFromDS();
        Properties props = new Properties();
        props.setProperty("locators", SocketCreator.getLocalHost().getHostAddress() + '[' + AdminAndCacheDUnitTest.getDUnitLocatorPort() + ']');
        InternalDistributedSystem system = this.getSystem(props);
        AdminAndCacheDUnitTest.assertTrue((!system.getConfig().getLocators().equals("") ? 1 : 0) != 0);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        AdminAndCacheDUnitTest.assertEquals((String)system.getConfig().getLocators(), (String)config.getLocators());
        AdminAndCacheDUnitTest.assertEquals((int)system.getConfig().getMcastPort(), (int)config.getMcastPort());
        config.setRemoteCommand("");
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        AdminAndCacheDUnitTest.assertTrue((boolean)admin.waitToBeConnected(5000L));
        AdminAndCacheDUnitTest.assertEquals((int)1, (int)admin.getDistributionLocators().length);
        DistributionLocator[] locators = admin.getDistributionLocators();
        final DistributionLocatorImpl locator = (DistributionLocatorImpl)locators[0];
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return locator.isRunning();
            }

            @Override
            public String description() {
                return "locator.isRunning()";
            }
        };
        AdminAndCacheDUnitTest.waitForCriterion(wc, 5000L, 10L, true);
    }
}

