/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConTest;
import capCon.LRUListener;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import hydra.GsRandom;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class LRUTest
extends CapConTest {
    protected int maximumEntries = 0;
    protected int lowestAllowableEntries = -1;
    protected int highestAllowableEntries = -1;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new LRUTest();
            testInstance.initialize();
            ((LRUTest)LRUTest.testInstance).maximumEntries = CacheUtil.getRegion("capConRegion").getAttributes().getEvictionAttributes().getMaximum();
            ((LRUTest)testInstance).initFields();
            Log.getLogWriter().info(testInstance.toString());
        }
    }

    protected void initFields() {
        Region workRegion = this.getWorkRegion();
        if (TestConfig.tab().booleanAt(Prms.serialExecution)) {
            this.lowestAllowableEntries = this.maximumEntries;
            this.highestAllowableEntries = this.maximumEntries;
            Log.getLogWriter().info("Setting limits: This test is serial execution " + TestHelper.regionToString(workRegion, false) + " maximumEntries = " + this.maximumEntries + ", lowestAllowableEntries = " + this.lowestAllowableEntries + ", highestAllowableEntries = " + this.highestAllowableEntries);
        } else {
            this.lowestAllowableEntries = this.maximumEntries - this.numThreads - 1;
            this.highestAllowableEntries = this.maximumEntries + this.numThreads + 1;
            Log.getLogWriter().info("Setting limits: This VM is using a VM region " + TestHelper.regionToString(workRegion, false) + ", numThreads = " + this.numThreads + " maximumEntries = " + this.maximumEntries + ", lowestAllowableEntries = " + this.lowestAllowableEntries + ", highestAllowableEntries = " + this.highestAllowableEntries);
        }
    }

    @Override
    public Object getNewKey() {
        return NameFactory.getNextPositiveObjectName();
    }

    @Override
    public Object getNewValue() {
        return this.randomValues.getRandomObjectGraph();
    }

    @Override
    public CacheListener getEventListener() {
        return new LRUListener();
    }

    @Override
    public Object getPreviousKey() {
        long RANGE = 20L;
        long currentNameCounter = NameFactory.getPositiveNameCounter();
        long lowEnd = currentNameCounter - RANGE;
        if (lowEnd < 0L) {
            lowEnd = 0L;
        }
        long previousNameCounter = TestConfig.tab().getRandGen().nextLong(lowEnd, currentNameCounter);
        return NameFactory.getObjectNameForCounter(previousNameCounter);
    }

    public static void HydraTask_addEntries() {
        testInstance.addEntries();
    }

    public static void HydraTask_serialTest() {
        ((LRUTest)testInstance).doSerialTest();
    }

    public static void HydraTask_monitorCapacity() {
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_monitorCapacity, monitoring capacity for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            ((LRUTest)testInstance).verifyNumKeys();
            LRUTest.checkForEventError();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In HydraTask_monitorCapacity, done running for " + timeToRunSec + " seconds");
    }

    public static void HydraTask_endTask() {
        NameBB.getBB().printSharedCounters();
        CapConBB.getBB().printSharedCounters();
        LRUTest.checkForEventError();
        double numEvictions = TestHelper.getNumLRUEvictions();
        Log.getLogWriter().info("Number of lru evictions during test: " + numEvictions);
    }

    protected void verifyNumKeys() {
        Region workRegion = this.getWorkRegion();
        int numKeys = workRegion.keys().size();
        Log.getLogWriter().info("In verifyNumKeys, numKeys is " + numKeys);
        CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, numKeys);
        if (numKeys > this.highestAllowableEntries) {
            throw new TestException("Expected num keys to be <= " + this.highestAllowableEntries + ", but num keys for " + TestHelper.regionToString(workRegion, false) + " is " + numKeys + ", " + this.toString());
        }
    }

    protected void verifyEviction(LRUListener listener, EntryEvent event) {
        Region workRegion = this.getWorkRegion();
        int numKeys = workRegion.keys().size();
        CapConBB.getBB().getSharedCounters().setIfSmaller(CapConBB.MIN_NUM_KEYS_AT_LRU_EVICTION, numKeys);
        int limit = this.lowestAllowableEntries - 1;
        if (numKeys < limit) {
            String errStr = "Early eviction detected: Expected num keys to be >= " + limit + ", but num keys for " + workRegion.getFullPath() + " is " + numKeys + ", " + this.toString() + " " + TestHelper.getStackTrace() + listener.toString("", (CacheEvent)event);
            Log.getLogWriter().info(errStr);
            CapConBB.getBB().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, errStr);
        }
    }

    private int getNumEntriesForTxBoundary(int currentNumEntries) {
        GsRandom rand = TestConfig.tab().getRandGen();
        if (currentNumEntries < this.lowestAllowableEntries) {
            return rand.nextInt(currentNumEntries + 1, this.lowestAllowableEntries);
        }
        if (rand.nextBoolean()) {
            return rand.nextInt(this.lowestAllowableEntries, this.highestAllowableEntries);
        }
        return rand.nextInt(this.highestAllowableEntries + 1, this.highestAllowableEntries + 100);
    }

    private void doSerialTest() {
        Region workRegion = this.getWorkRegion();
        long exeNum = CapConBB.getBB().getSharedCounters().incrementAndRead(CapConBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        Log.getLogWriter().info(TestHelper.regionToString(workRegion, false) + " has " + TestHelper.getTotalNumKeys(workRegion) + " entries");
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In doSerialTest, adding for " + timeToRunSec + " seconds");
        int count = 0;
        long startTime = System.currentTimeMillis();
        boolean inTrans = false;
        int txBoundary = -1;
        boolean done = false;
        int numKeysWhenTxBegan = -1;
        do {
            LRUTest.checkForEventError();
            int beforeNumKeys = workRegion.keys().size();
            if (this.useTransactions && !inTrans) {
                TxHelper.begin();
                inTrans = true;
                txBoundary = this.getNumEntriesForTxBoundary(beforeNumKeys);
                Log.getLogWriter().info("Targeting a transaction boundary when numEntries is " + txBoundary + ", current num entries is " + beforeNumKeys);
                numKeysWhenTxBegan = beforeNumKeys;
            }
            testInstance.addEntry();
            ++count;
            int afterNumKeys = workRegion.keys().size();
            boolean timeToEndTrans = afterNumKeys >= txBoundary;
            done = System.currentTimeMillis() - startTime > timeToRunMS;
            boolean rolledBack = false;
            if (inTrans && (timeToEndTrans || done)) {
                Log.getLogWriter().info("Before ending transaction, current num entries is " + afterNumKeys + ", num entries when tx began: " + numKeysWhenTxBegan);
                if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 75) {
                    TxHelper.commitExpectSuccess();
                } else {
                    TxHelper.rollback();
                    rolledBack = true;
                    int numKeysAfterRollback = workRegion.keys().size();
                    if (numKeysAfterRollback != numKeysWhenTxBegan) {
                        throw new TestException("When transaction began num entries was " + numKeysWhenTxBegan + ", before rollback num entries was " + afterNumKeys + ", after rollback num entries was " + numKeysAfterRollback);
                    }
                }
                inTrans = false;
                afterNumKeys = workRegion.keys().size();
                Log.getLogWriter().info("After ending transaction, current num entries is " + afterNumKeys);
            }
            CapConBB.getBB().getSharedCounters().setIfLarger(CapConBB.MAX_NUM_KEYS, afterNumKeys);
            if (rolledBack) continue;
            if (inTrans || beforeNumKeys < this.lowestAllowableEntries) {
                if (beforeNumKeys + 1 == afterNumKeys) continue;
                throw new TestException("Before adding to " + TestHelper.regionToString(workRegion, false) + ", num keys was " + beforeNumKeys + ", but after adding  num keys was " + afterNumKeys + "; expected num keys to be " + (beforeNumKeys + 1) + ", " + this.toString());
            }
            if (afterNumKeys <= this.highestAllowableEntries) continue;
            throw new TestException("Before adding to " + TestHelper.regionToString(workRegion, false) + ", num keys was " + beforeNumKeys + ", but after adding  num keys was " + afterNumKeys + "; expected num keys to <= highestAllowableEntries " + this.highestAllowableEntries + ", " + this.toString());
        } while (!done);
        Log.getLogWriter().info("In doSerialTest, done running for " + timeToRunSec + " seconds, added " + count + " objects to " + TestHelper.regionToString(workRegion, false) + "; " + TestHelper.regionToString(workRegion, false) + " has " + TestHelper.getTotalNumKeys(workRegion) + " entries");
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toString() + "\n");
        aStr.append("   entry evictor settings:\n");
        aStr.append("      maximumEntries (in test instance): " + this.maximumEntries + "\n");
        aStr.append("      maximumEntries (in evictor attr) : " + CacheUtil.getRegion("capConRegion").getAttributes().getEvictionAttributes().getMaximum() + "\n");
        aStr.append("   Region limits:\n");
        aStr.append("      lowestAllowableEntries: " + this.lowestAllowableEntries + "\n");
        aStr.append("      highestAllowableEntries: " + this.highestAllowableEntries + "\n");
        return aStr.toString();
    }
}

