/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase14.rdb;

import cacheperf.CachePerfClient;
import cacheperf.poc.useCase14.rdb.RdbPrms;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.HydraRuntimeException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import objects.ObjectHelper;

public class RdbClient
extends CachePerfClient {
    private String tableName;
    private String driverName;
    private String dbUrl;
    private String userName;
    private String password;

    public static void deleteRelationalDataTask() {
        RdbClient c = new RdbClient();
        c.initialize();
        c.initRdbConfiguration();
        c.deleteTable();
    }

    private void deleteTable() {
        this.loadDriver(this.driverName);
        Connection conn = this.getConnection(this.dbUrl, this.userName, this.password);
        Statement stmt = this.createStatement(conn);
        try {
            stmt.executeUpdate("DROP TABLE " + this.tableName);
            RdbClient.log().info("Deleted table " + this.tableName);
        }
        catch (SQLException e) {
            RdbClient.log().info("Table " + this.tableName + " already deleted");
        }
    }

    public static void createRelationalDataTask() {
        RdbClient c = new RdbClient();
        c.initialize(1);
        c.initRdbConfiguration();
        c.deleteTable();
        c.createAndPopulateTable();
    }

    private void createAndPopulateTable() {
        this.loadDriver(this.driverName);
        Connection conn = this.getConnection(this.dbUrl, this.userName, this.password);
        Statement stmt = this.createStatement(conn);
        try {
            stmt.executeUpdate("CREATE TABLE " + this.tableName + " (SYMBOL VARCHAR2(50) NOT NULL , ORGANIZATION VARCHAR2(50) NOT NULL )");
            RdbClient.log().info("Created table " + this.tableName);
        }
        catch (SQLException e) {
            throw new HydraRuntimeException("Table " + this.tableName + " already created");
        }
        RdbClient.log().info("Populating table " + this.tableName + " with " + this.maxKeys + " entries...");
        for (int i = 0; i < this.maxKeys; ++i) {
            long start = this.statistics.startCreate();
            try {
                stmt.executeUpdate("Insert into " + this.tableName + " values ('SYM" + i + "', 'ORGANIZATION" + i + "')");
            }
            catch (SQLException e) {
                throw new HydraRuntimeException("Problem executing update " + i, e);
            }
            this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
        }
        RdbClient.log().info("Populated table " + this.tableName);
    }

    public static void loadRelationalDataTask() {
        RdbClient c = new RdbClient();
        c.initialize(3);
        c.initRdbConfiguration();
        c.loadRelationalData();
    }

    private void loadRelationalData() {
        this.loadDriver(this.driverName);
        Connection conn = this.getConnection(this.dbUrl, this.userName, this.password);
        Statement stmt = this.createStatement(conn);
        try {
            RdbClient.log().info("Populating region from database...");
            int entries = 0;
            ResultSet resultSet = stmt.executeQuery("select * from " + this.tableName);
            while (resultSet.next()) {
                String key = resultSet.getString(1);
                String value = resultSet.getString(2);
                long start = this.statistics.startPut();
                this.cache.put(key, value);
                this.statistics.endPut(start, this.isMainWorkload, this.histogram);
                ++entries;
            }
            RdbClient.log().info("Populated region with " + entries + " entries from database");
        }
        catch (SQLException e) {
            throw new HydraRuntimeException("Problem reading data", e);
        }
    }

    private void initRdbConfiguration() {
        this.tableName = RdbPrms.getTableName();
        this.driverName = RdbPrms.getDriverName();
        this.dbUrl = RdbPrms.getDbUrl();
        this.userName = RdbPrms.getUserName();
        this.password = RdbPrms.getPassword();
        RdbClient.log().info("Configured RDB with driverName=" + this.driverName + " dbUrl=" + this.dbUrl + " userName=" + this.userName + " password=" + this.password);
    }

    private void loadDriver(String driverName) {
        try {
            Driver driver = (Driver)Class.forName(driverName).newInstance();
            RdbClient.log().info("Loaded driver: " + driver);
        }
        catch (ClassNotFoundException e) {
            throw new HydraRuntimeException("Problem instantiating driver", e);
        }
        catch (IllegalAccessException e) {
            throw new HydraRuntimeException("Problem instantiating driver", e);
        }
        catch (InstantiationException e) {
            throw new HydraRuntimeException("Problem instantiating driver", e);
        }
    }

    private Connection getConnection(String dbUrl, String userName, String password) {
        try {
            Connection conn = DriverManager.getConnection(dbUrl, userName, password);
            RdbClient.log().info("Got connection: " + conn);
            return conn;
        }
        catch (SQLException e) {
            throw new HydraRuntimeException("Problem obtaining connection", e);
        }
    }

    private Statement createStatement(Connection conn) {
        try {
            return conn.createStatement();
        }
        catch (SQLException e) {
            throw new HydraRuntimeException("Problem creating statement", e);
        }
    }

    public static void registerInterestTask() {
        RdbClient c = new RdbClient();
        c.initialize();
        c.registerInterest();
    }

    private void registerInterest() {
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            int n = this.rng.nextInt(1, 100);
            this.register(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    protected void register(int i) {
        if (this.cache instanceof GemFireCacheTestImpl) {
            Object key = ObjectHelper.createName(this.keyType, i);
            GemFireCacheTestImpl impl = (GemFireCacheTestImpl)this.cache;
            impl.registerInterest("SYM" + key, this.registerDurableInterest);
        }
    }

    public static void registerInterestInAllKeysTask() {
        RdbClient c = new RdbClient();
        c.initialize();
        c.registerInterestInAllKeys();
    }

    private void registerInterestInAllKeys() {
        if (this.cache instanceof GemFireCacheTestImpl) {
            GemFireCacheTestImpl impl = (GemFireCacheTestImpl)this.cache;
            impl.registerInterest("ALL_KEYS", this.registerDurableInterest);
        }
    }
}

