/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.gemfire.morgan;

import hydra.HydraConfigException;

public class ScalingFcns {
    public static final int MINIMUM_VM_SIZE = 256;
    public static final int MAXIMUM_VM_SIZE = 1500;
    public static final int VM_PADDING_SIZE = 128;

    public static String scaleVmSize(int maxKeys, int dataSize, int numHosts) {
        long sz = (long)maxKeys * (long)dataSize;
        sz /= (long)numHosts;
        sz /= 1000000L;
        sz += 128L;
        if ((sz = Math.max(sz, 256L)) > 1500L) {
            String s = "Trying to scale VM size past 1500m. Reduce maxKeys=" + maxKeys + " or dataSize=" + dataSize + " or increase numHosts=" + numHosts;
            throw new HydraConfigException(s);
        }
        return "-Xms" + sz + "m -Xmx" + sz + "m";
    }
}

