/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.query;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class QueryPerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String QUERIES = "queries";
    protected static final String QUERY_TIME = "queryTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{QueryPerfStats.factory().createIntCounter(QUERIES, "Number of queries completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(QUERY_TIME, "Total time spent performing queries.", "nanoseconds", !largerIsBetter)};
    }

    public static QueryPerfStats getInstance() {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0);
    }

    public static QueryPerfStats getInstance(String name) {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0, name);
    }

    public static QueryPerfStats getInstance(String name, String trimspecName) {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, 0, name, trimspecName);
    }

    public QueryPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getQueries() {
        return this.statistics().getInt(QUERIES);
    }

    public long getQUERYTime() {
        return this.statistics().getLong(QUERY_TIME);
    }

    public void incQueries() {
        this.incQueries(1);
    }

    public void incQueries(int amount) {
        this.statistics().incInt(QUERIES, amount);
    }

    public void incQueryTime(long amount) {
        this.statistics().incLong(QUERY_TIME, amount);
    }

    public long startQuery() {
        return NanoTimer.getTime();
    }

    public void endQuery(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(QUERIES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(QUERY_TIME, elapsed);
    }
}

