/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.query;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import cacheperf.comparisons.query.QueryPerfPrms;
import cacheperf.comparisons.query.QueryPerfStats;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.CacheHelper;
import hydra.HydraInternalException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import java.util.Collection;
import objects.ObjectHelper;
import parReg.query.index.IndexTest;

public class QueryPerfClient
extends CachePerfClient {
    protected static final int QUERIES = 100;
    protected static final String QUERY_NAME = "queries";
    public boolean createIndex;
    protected static boolean exeQuery1 = false;
    protected static boolean exeQuery2 = false;
    protected static boolean exeQuery3 = false;
    protected static boolean createIndex1 = false;
    protected static boolean createIndex2 = false;
    protected static boolean createIndex3 = false;
    public QueryPerfStats querystats;
    private static HydraThreadLocal localquerystats = new HydraThreadLocal();

    public static void createIndexTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        int createIndexNum = QueryPerfPrms.exeQuerNum();
        switch (createIndexNum) {
            case 1: {
                createIndex1 = true;
                break;
            }
            case 2: {
                createIndex2 = true;
                break;
            }
            case 3: {
                createIndex3 = true;
                break;
            }
            default: {
                throw new HydraInternalException("Can't create such index.");
            }
        }
        c.createIndex();
    }

    private void createIndex() {
        this.createIndex = QueryPerfPrms.createIndex();
        if (this.createIndex) {
            Region r = null;
            r = ((GemFireCacheTestImpl)this.cache).getRegion();
            IndexTest indexTest = new IndexTest();
            Log.getLogWriter().info("try to create index");
            if (createIndex1) {
                indexTest.createIndex1(r.getName());
            }
            if (createIndex2) {
                indexTest.createIndex2(r.getName());
            }
            if (createIndex3) {
                indexTest.createIndex3(r.getName());
            }
        }
    }

    public static void initQueryTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        int exeQueryNum = QueryPerfPrms.exeQuerNum();
        switch (exeQueryNum) {
            case 1: {
                exeQuery1 = true;
                break;
            }
            case 2: {
                exeQuery2 = true;
                break;
            }
            case 3: {
                exeQuery3 = true;
                break;
            }
            default: {
                throw new HydraInternalException("Can't execute this query.");
            }
        }
    }

    public static void queryTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(100);
        c.executeQuery();
    }

    private void executeQuery() {
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("executing query");
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (exeQuery1) {
                this.query1(key);
            } else if (exeQuery2) {
                this.query2(key);
            } else if (exeQuery3) {
                this.query3(key);
            }
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("finishing executing query");
        }
    }

    private void query1(int i) {
        long start;
        Object key = ObjectHelper.createName(this.keyType, i);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("query key = " + key);
        }
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        try {
            start = this.querystats.startQuery();
            String queryString = "select distinct * from " + theRegion.getFullPath() + " where name = $1 ";
            Query query = CacheHelper.getCache().getQueryService().newQuery(queryString);
            Object[] params = new Object[]{new Integer(i).toString()};
            Object result = query.execute(params);
            if (!(result instanceof Collection)) {
                Log.getLogWriter().info("Result is not a collection.");
            }
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
        this.querystats.endQuery(start);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("finished query for key = " + key);
        }
    }

    private void query2(int i) {
        long start;
        Object key = ObjectHelper.createName(this.keyType, i);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("query key = " + key);
        }
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        try {
            start = this.querystats.startQuery();
            String queryString = "select distinct * from " + theRegion.getFullPath() + " where id < $1 ";
            Query query = CacheHelper.getCache().getQueryService().newQuery(queryString);
            Object[] params = new Object[]{new Integer(i % 10 + 1)};
            Object result = query.execute(params);
            if (!(result instanceof Collection)) {
                Log.getLogWriter().info("Result is not a collection.");
            }
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
        this.querystats.endQuery(start);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("finished query for key = " + key);
        }
    }

    private void query3(int i) {
        long start;
        Object key = ObjectHelper.createName(this.keyType, i);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("query key = " + key);
        }
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        try {
            start = this.querystats.startQuery();
            String queryString = "import parReg.\"query\".Position; select distinct r from " + theRegion.getFullPath() + " r,  r.positions.values pVal TYPE Position where pVal.mktValue  < $1";
            Query query = CacheHelper.getCache().getQueryService().newQuery(queryString);
            Object[] params = new Object[]{new Double((double)(i % 25) + 1.0)};
            Object result = query.execute(params);
            if (!(result instanceof Collection)) {
                Log.getLogWriter().info("Result is not a collection.");
            }
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
        this.querystats.endQuery(start);
        if (QueryPerfClient.log().finerEnabled()) {
            QueryPerfClient.log().finer("finished query for key = " + key);
        }
    }

    public static void openStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.querystats == null) {
            QueryPerfClient.log().info("Opening per-thread query performance statistics");
            this.querystats = QueryPerfStats.getInstance();
            QueryPerfClient.log().info("Opened per-thread query performance statistics");
        }
    }

    public static void closeStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.querystats != null) {
            QueryPerfClient.log().info("Closing per-thread Query performance statistics");
            this.querystats.close();
            QueryPerfClient.log().info("Closed per-thread Query performance statistics");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.querystats = this.getQueryStats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setQueryStats(this.querystats);
    }

    protected QueryPerfStats getQueryStats() {
        QueryPerfStats querystats = (QueryPerfStats)localquerystats.get();
        return querystats;
    }

    protected void setQueryStats(QueryPerfStats querystats) {
        localquerystats.set(querystats);
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 100: {
                return QUERY_NAME;
            }
        }
        return super.nameFor(name);
    }
}

