/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.putAll;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class PutAllPerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String PUTALL_ENTRIES = "putAllEntries";
    protected static final String PUTALL_TIME = "putAllTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{PutAllPerfStats.factory().createLongCounter(PUTALL_ENTRIES, "Number of putAll entries completed.", "entries", largerIsBetter), PutAllPerfStats.factory().createLongCounter(PUTALL_TIME, "Total time spent performing putAll operation.", "nanoseconds", !largerIsBetter)};
    }

    public static PutAllPerfStats getInstance() {
        return (PutAllPerfStats)PutAllPerfStats.getInstance(PutAllPerfStats.class, 0);
    }

    public static PutAllPerfStats getInstance(String name) {
        return (PutAllPerfStats)PutAllPerfStats.getInstance(PutAllPerfStats.class, 0, name);
    }

    public static PutAllPerfStats getInstance(String name, String trimspecName) {
        return (PutAllPerfStats)PutAllPerfStats.getInstance(PutAllPerfStats.class, 0, name, trimspecName);
    }

    public PutAllPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public long getPutAllEntries() {
        return this.statistics().getLong(PUTALL_ENTRIES);
    }

    public long getPutAllTime() {
        return this.statistics().getLong(PUTALL_TIME);
    }

    public void incPutAllEntries() {
        this.incPutAllEntries(1);
    }

    public void incPutAllEntries(int amount) {
        this.statistics().incLong(PUTALL_ENTRIES, (long)amount);
    }

    public void incPutAllTime(long amount) {
        this.statistics().incLong(PUTALL_TIME, amount);
    }

    public long startPutAll() {
        return NanoTimer.getTime();
    }

    public void endPutAll(long start, int mapSize) {
        long ts = NanoTimer.getTime();
        this.statistics().incLong(PUTALL_ENTRIES, (long)mapSize);
        long elapsed = ts - start;
        this.statistics().incLong(PUTALL_TIME, elapsed);
    }
}

