/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.cq;

import cacheperf.CachePerfException;
import cacheperf.CachePerfPrms;
import cacheperf.comparisons.cq.CQPrms;
import cacheperf.comparisons.dataFeed.DataFeedClient;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.CacheHelper;
import hydra.HydraConfigException;
import hydra.HydraThreadLocal;
import hydra.MasterController;
import java.util.Random;
import objects.BatchStringPrms;

public class CQClient
extends DataFeedClient {
    private static HydraThreadLocal localcqs = new HydraThreadLocal();

    public static void registerCQsTask() {
        CQClient c = new CQClient();
        c.initialize();
        c.registerCQs();
    }

    private void registerCQs() {
        int numCQs = CQPrms.getNumCQs();
        CqQuery[] cqs = new CqQuery[numCQs];
        for (int i = 0; i < numCQs; ++i) {
            cqs[i] = this.registerCQ(i);
        }
        localcqs.set(cqs);
    }

    private CqQuery registerCQ(int i) {
        String cqName = "cq" + i;
        String query = this.getQuery(i);
        CqAttributesFactory factory = new CqAttributesFactory();
        factory.addCqListener(CQPrms.getCQListener());
        CqAttributes cqAttrs = factory.create();
        CQClient.log().info("Registering CQ named \"" + cqName + "\" with query: " + query + " and cqAttrs: " + cqAttrs);
        QueryService cqService = CacheHelper.getCache().getQueryService();
        CqQuery cq = null;
        try {
            cq = cqService.newCq(cqName, query, cqAttrs);
        }
        catch (Exception e) {
            String s = "Failed to register CQ " + cqName;
            throw new CachePerfException(s, e);
        }
        CQClient.log().info("Successfully registered CQ named " + cqName);
        CQClient.log().info("Executing CQ " + cq);
        try {
            if (CQPrms.executeWithInitialResults()) {
                CqResults e = cq.executeWithInitialResults();
            } else {
                cq.execute();
            }
        }
        catch (Exception e) {
            String s = "Failed to execute CQ " + cqName;
            throw new CachePerfException(s, e);
        }
        CQClient.log().info("Successfully executed CQ named " + cqName);
        return cq;
    }

    private String getQuery(int i) {
        int strBatchSize = BatchStringPrms.getBatchSize();
        if (this.maxKeys % strBatchSize != 0) {
            String s = BatchStringPrms.nameForKey(BatchStringPrms.batchSize) + " does not evenly divide " + CachePerfPrms.nameForKey(CachePerfPrms.maxKeys);
            throw new HydraConfigException(s);
        }
        int batches = this.maxKeys / strBatchSize;
        int batchNum = (this.tid + i) % batches;
        String query = "SELECT * FROM " + this.getRegionPath() + " obj WHERE obj.batch";
        if (!CQPrms.useMultipleWhereConditionsInCQs()) {
            query = query + " = " + batchNum;
        } else {
            String[] comparators = new String[]{"=", ">", "<", "<=", ">=", "<>"};
            String comparator = comparators[new Random().nextInt(comparators.length)];
            query = query + " " + comparator + " " + batchNum;
        }
        return query;
    }

    private String getRegionPath() {
        if (this.cache instanceof GemFireCacheTestImpl) {
            Region region = ((GemFireCacheTestImpl)this.cache).getRegion();
            return region.getFullPath();
        }
        throw new UnsupportedOperationException(this.cache.getClass().getName());
    }

    public static void cycleCQsTask() {
        CQClient c = new CQClient();
        c.initialize(12);
        c.cycleCQs();
    }

    private void cycleCQs() {
        boolean batchDone = false;
        int throttledOpsPerSec = CQPrms.getThrottledOpsPerSec();
        CqQuery[] cqs = (CqQuery[])localcqs.get();
        if (throttledOpsPerSec > 0) {
            do {
                this.timer.reset();
                for (int i = 0; i < throttledOpsPerSec; ++i) {
                    batchDone = this.cycleCQ(cqs[i % cqs.length]);
                }
                long remaining = 1000000000L - this.timer.reset();
                if (remaining <= 0L) continue;
                MasterController.sleepForMs((int)((double)remaining / 1000000.0));
            } while (!batchDone);
        } else {
            int i = 0;
            do {
                batchDone = this.cycleCQ(cqs[i % cqs.length]);
                ++i;
            } while (!batchDone);
        }
    }

    private boolean cycleCQ(CqQuery cq) {
        int key = this.getNextKey();
        this.executeTaskTerminator();
        this.executeWarmupTerminator();
        this.deregisterCQ(cq);
        this.reregisterCQ(cq);
        ++this.batchCount;
        ++this.count;
        ++this.keyCount;
        return this.executeBatchTerminator();
    }

    private void deregisterCQ(CqQuery cq) {
        try {
            cq.stop();
        }
        catch (CqException e) {
            String s = "Failed to execute CQ " + cq.getName();
            throw new CachePerfException(s, (Exception)((Object)e));
        }
    }

    private void reregisterCQ(CqQuery cq) {
        try {
            cq.execute();
        }
        catch (Exception e) {
            String s = "Failed to execute CQ " + cq.getName();
            throw new CachePerfException(s, e);
        }
    }
}

