/*
 * Decompiled with CFR 0.152.
 */
package cacheServer.hct;

import durableClients.DurableClientsPrms;
import hct.BBoard;
import hydra.CacheHelper;
import hydra.CacheServerHelper;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;

public class InterestPolicyTest
extends hct.InterestPolicyTest {
    static long killInterval = 60000L;
    private static final String cacheServerStr = "cacheserver";

    public static void InitTask_startCacheServer() {
        if (testInstance == null) {
            testInstance = new InterestPolicyTest();
            ((InterestPolicyTest)testInstance).startCacheServer();
        }
    }

    protected void startCacheServer() {
        String xmlFileName;
        String serverName;
        String clientName;
        block2: {
            int myVmid = RemoteTestModule.getMyVmid();
            clientName = RemoteTestModule.getMyClientName();
            serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
            xmlFileName = serverName + ".xml";
            try {
                CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), null, ConfigPrms.getBridgeConfig(), null, ConfigPrms.getDiskStoreConfig(), null, xmlFileName);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
        Log.getLogWriter().info("Starting up cacheServer " + serverName + " with cache.xml file " + xmlFileName);
        GemFireDescription gfd = TestConfig.getInstance().getClientDescription(clientName).getGemFireDescription();
        String offHeapMemorySize = gfd.getOffHeapMemorySize();
        String[] extraArgs = null;
        extraArgs = offHeapMemorySize != null ? new String[]{" off-heap-memory-size=" + offHeapMemorySize} : new String[]{};
        CacheServerHelper.startCacheServer(serverName, xmlFileName, extraArgs);
    }

    protected void restartCacheServer() {
        int myVmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
        String xmlFileName = serverName + ".xml";
        Log.getLogWriter().info("Starting up cacheServer " + serverName + " with cache.xml file " + xmlFileName);
        CacheServerHelper.startCacheServer(serverName, xmlFileName);
    }

    public static void HydraTask_stopCacheServer() {
        ((InterestPolicyTest)testInstance).stopCacheServer();
    }

    public void stopCacheServer() {
        int myVmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
        CacheServerHelper.stopCacheServer(serverName);
    }

    public static void killCacheServer() throws ClientVmNotFoundException {
        Long lastKill;
        long now = System.currentTimeMillis();
        long diff = now - (lastKill = (Long)BBoard.getInstance().getSharedMap().get("lastKillTime"));
        if (diff < killInterval) {
            Log.getLogWriter().info("No kill executed");
            return;
        }
        BBoard.getInstance().getSharedMap().put("lastKillTime", new Long(now));
        ((InterestPolicyTest)testInstance).stopCacheServer();
        int sleepSec = TestConfig.tab().intAt(DurableClientsPrms.restartWaitSec, 1);
        Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        ((InterestPolicyTest)testInstance).restartCacheServer();
        MasterController.sleepForMs(sleepSec * 1000);
    }
}

