/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.smoke;

import cacheLoader.smoke.BB;
import cacheLoader.smoke.Util;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import hydra.Log;
import hydra.blackboard.SharedCounters;

public class ObjectListener
extends CacheListenerAdapter
implements CacheWriter {
    public void beforeCreate(EntryEvent objEvent) throws CacheWriterException {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("About to create " + Util.log(region, objName, objEvent.getOldValue()));
    }

    public void afterCreate(EntryEvent objEvent) {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("Creating " + Util.log(region, objName, objEvent.getNewValue()));
    }

    public void beforeDestroy(EntryEvent objEvent) throws CacheWriterException {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("About to destroy " + Util.log(region, objName, objEvent.getOldValue()));
    }

    public void afterDestroy(EntryEvent objEvent) {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("Destroying " + Util.log(region, objName, objEvent.getOldValue()));
        SharedCounters counters = BB.getInstance().getSharedCounters();
        counters.increment(BB.NUM_DESTROY_CALLBACKS);
    }

    public void afterInvalidate(EntryEvent objEvent) {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("Invalidating " + Util.log(region, objName, objEvent.getOldValue()));
        SharedCounters counters = BB.getInstance().getSharedCounters();
        if (!objEvent.isDistributed()) {
            counters.increment(BB.NUM_UNLOAD_CALLBACKS);
        } else {
            counters.increment(BB.NUM_INVALIDATE_CALLBACKS);
        }
    }

    public void beforeUpdate(EntryEvent objEvent) throws CacheWriterException {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("About to update " + Util.log(region, objName, objEvent.getOldValue()));
    }

    public void afterUpdate(EntryEvent objEvent) {
        Region region = objEvent.getRegion();
        Object objName = objEvent.getKey();
        Log.getLogWriter().info("Updating - original object = " + Util.log(region, objName, objEvent.getOldValue()) + " current object = " + Util.log(region, objName, objEvent.getNewValue()));
    }

    public void afterRegionInvalidate(RegionEvent objEvent) {
    }

    public void beforeRegionDestroy(RegionEvent objEvent) throws CacheWriterException {
    }

    public void beforeRegionClear(RegionEvent objEvent) throws CacheWriterException {
    }

    public void afterRegionDestroy(RegionEvent objEvent) {
    }

    public void close() {
    }
}

