/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.hc;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class PerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    private static final String OPERATIONS_COMPLETED = "operationsCompleted";
    private static final String OPERATION_TIME = "operationTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{PerfStats.factory().createIntCounter(OPERATIONS_COMPLETED, "Number of operations completed.", "operations", largerIsBetter), PerfStats.factory().createLongCounter(OPERATION_TIME, "Total time spent doing operations.", "nanoseconds", !largerIsBetter)};
    }

    public static PerfStats getInstance() {
        return (PerfStats)PerfStats.getInstance(PerfStats.class, 0);
    }

    public static PerfStats getInstance(String name) {
        return (PerfStats)PerfStats.getInstance(PerfStats.class, 0, name);
    }

    public static PerfStats getInstance(String name, String trimspecName) {
        return (PerfStats)PerfStats.getInstance(PerfStats.class, 0, name, trimspecName);
    }

    public PerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getOperationsCompleted() {
        return this.statistics().getInt(OPERATIONS_COMPLETED);
    }

    public long getOperationTime() {
        return this.statistics().getLong(OPERATION_TIME);
    }

    public void incOperationsCompleted() {
        this.incOperationsCompleted(1);
    }

    public void incOperationsCompleted(int amount) {
        this.statistics().incInt(OPERATIONS_COMPLETED, amount);
    }

    public void incOperationTime(long amount) {
        this.statistics().incLong(OPERATION_TIME, amount);
    }

    public long startOperation() {
        return NanoTimer.getTime();
    }

    public void endOperation(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(OPERATIONS_COMPLETED, 1);
        this.statistics().incLong(OPERATION_TIME, ts - start);
    }
}

