/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.hc;

import cacheLoader.hc.BridgeParms;
import cacheLoader.hc.DBParms;
import cacheLoader.hc.PerfStats;
import cacheLoader.hc.Util;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.lang.reflect.Method;
import java.util.Random;
import util.TestException;
import util.TestHelper;

public class BridgeClient {
    protected static final String REGION_NAME = "Bloomberg";
    protected int trimIterations;
    protected int workIterations;
    public PerfStats perfstats;
    private static HydraThreadLocal localperfstats = new HydraThreadLocal();

    public static synchronized void initBridgeCacheTask() {
        Util.registerDriver();
        BridgeClient.initBridgeCache();
    }

    public static synchronized void initEdgeCacheTask() {
        BridgeClient clientInstance = new BridgeClient();
        clientInstance.initEdgeCache();
    }

    public static synchronized void closeCacheTask() {
        CacheHelper.closeCache();
    }

    public static boolean readTask() {
        BridgeClient clientInstance = new BridgeClient();
        clientInstance.initTestParameters();
        clientInstance.read(clientInstance.trimIterations);
        long nanoTime = clientInstance.read(clientInstance.workIterations);
        clientInstance.read(clientInstance.trimIterations);
        long msTime = BridgeClient.timeInMillis(nanoTime);
        Log.getLogWriter().info("Completed " + clientInstance.workIterations + " timed get calls in " + msTime + " ms ==> average " + (double)msTime / ((double)clientInstance.workIterations * 1.0) + " ms per get");
        return true;
    }

    private static synchronized void initBridgeCache() {
        Cache cache = CacheHelper.createCache("bridge");
        AttributesFactory factory = RegionHelper.getAttributesFactory("bridge");
        String serverLoaderClassname = BridgeParms.getServerLoaderClassname();
        CacheLoader loader = (CacheLoader)RegionDescription.getInstance(BridgeParms.serverLoaderClassname, serverLoaderClassname);
        try {
            Method meth = loader.getClass().getMethod("init", new Class[0]);
            meth.invoke((Object)loader, new Object[0]);
        }
        catch (Exception e) {
            String s = "Failed invoking " + loader.getClass().getName() + ".init";
            throw new HydraConfigException(s, e);
        }
        factory.setCacheLoader(loader);
        Region region = RegionHelper.createRegion(REGION_NAME, factory);
        BridgeHelper.startBridgeServer("bridge");
    }

    private void initEdgeCache() {
        Cache cache = CacheHelper.createCache("edge");
        Region region = RegionHelper.createRegion(REGION_NAME, "edge");
    }

    private long read(int numIterations) {
        boolean logDetails = BridgeParms.getLogDetails();
        boolean validate = BridgeParms.getValidate();
        int numElements = TestConfig.tab().intAt(DBParms.numPreload);
        Random rand = new Random();
        Region region = RegionHelper.getRegion(REGION_NAME);
        String key = null;
        long startTime = -1L;
        NanoTimer timer = new NanoTimer();
        for (int i = 0; i < numIterations; ++i) {
            try {
                int keyValue = rand.nextInt(numElements - 1) + 1;
                key = Integer.toString(keyValue);
                if (logDetails) {
                    Log.getLogWriter().info("Retrieving value for " + key);
                }
                startTime = this.perfstats.startOperation();
                Object value = region.get((Object)key);
                this.perfstats.endOperation(startTime);
                if (!logDetails && !validate) continue;
                byte[] byteArrayValue = null;
                try {
                    byteArrayValue = (byte[])value;
                }
                catch (ClassCastException cce) {
                    ClassCastException cce2 = new ClassCastException("Expected byte[] but found:" + value.getClass().getName());
                    cce2.initCause(cce);
                    throw cce2;
                }
                byte[] keyBytes = new byte[4];
                StringBuffer aStr = new StringBuffer();
                for (int j = 0; j < 4; ++j) {
                    keyBytes[j] = byteArrayValue[j];
                    aStr.append("   keyBytes[" + j + "] = " + keyBytes[j] + "\n");
                }
                int retrievedKey = Util.bytesTOint(keyBytes);
                if (logDetails) {
                    Log.getLogWriter().info("Retrieved value " + retrievedKey + ":" + value + " for " + keyValue + "\n" + aStr.toString());
                }
                if (!validate || retrievedKey == keyValue) continue;
                throw new TestException("Validation Error: Requested value for key " + key + "; received " + retrievedKey + "\n" + aStr.toString());
            }
            catch (Exception ex) {
                this.perfstats.endOperation(startTime);
                String errStr = ex.toString();
                if (BridgeClient.isSocketTimeout(errStr)) {
                    Log.getLogWriter().info("Unable to read " + key + ": " + ex + "; continuing test");
                    continue;
                }
                Throwable cause = ex.getCause();
                if (cause != null && BridgeClient.isSocketTimeout(cause.toString())) {
                    Log.getLogWriter().info("Unable to read " + key + ": " + cause + "; continuing test");
                    continue;
                }
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        }
        ClientHelper.release(region);
        return timer.reset();
    }

    private static boolean isSocketTimeout(String errStr) {
        if (errStr.indexOf("SocketTimeoutException") >= 0) {
            return true;
        }
        if (errStr.indexOf("socket timed out") >= 0) {
            return true;
        }
        return errStr.indexOf("socket closed on server") >= 0;
    }

    private static long timeInMillis(double nanos) {
        Double d = new Double(nanos / 1000000.0);
        return d.longValue();
    }

    public static void openStatisticsTask() {
        BridgeClient c = new BridgeClient();
        c.initTestParameters();
        c.openStatistics();
    }

    protected void openStatistics() {
        if (this.perfstats == null) {
            Log.getLogWriter().info("Initializing local performance statistics");
            this.perfstats = PerfStats.getInstance();
            localperfstats.set(this.perfstats);
            Log.getLogWriter().info("Initialized local performance statistics");
        }
    }

    public static void closeStatisticsTask() {
        BridgeClient c = new BridgeClient();
        c.initTestParameters();
        MasterController.sleepForMs(2000);
        c.closeStatistics();
    }

    protected void closeStatistics() {
        if (this.perfstats == null) {
            throw new HydraRuntimeException("Statistics are already closed");
        }
        Log.getLogWriter().info("Closing local performance statistics");
        this.perfstats.close();
        Log.getLogWriter().info("Closed local performance statistics");
    }

    protected void initTestParameters() {
        this.trimIterations = BridgeParms.getTrimIterations();
        this.workIterations = BridgeParms.getWorkIterations();
        this.perfstats = (PerfStats)localperfstats.get();
    }
}

