/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import batterytest.BatteryTestConfig;
import batterytest.ConfigParser;
import batterytest.XMLReport;
import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.ProductVersionHelper;
import hydra.VmPrms;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import resultsUtil.BugReportTemplate;
import resultsUtil.RegressionSummary;
import util.TestHelper;

public class BatteryTest {
    private static final int PLATFORM_ID = 1;
    public static final String MOVE_HADOOP_DATA = "moveHadoopData";
    public static final String JACOCO_FN = "jacoco.exec";
    public static final String FORMAT = "MM/dd/yyyy hh:mm a";
    private static DateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
    private static final int EXIT_WAIT_SEC = 60;
    private static final String sep = File.separator;
    private static LogWriter log;

    public static void main(String[] args) {
        try {
            boolean result = BatteryTest.runbattery(args);
            if (!result) {
                BatteryTest.logError("runbattery() returned false");
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            BatteryTest.logError(TestHelper.getStackTrace(t));
        }
        System.exit(0);
    }

    private static int countAlreadyRun(String resultDirName) {
        File oneliner;
        int alreadyRun = 0;
        File resultDir = new File(resultDirName);
        if (resultDir.exists() && (oneliner = new File(resultDir, "oneliner.txt")).exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(oneliner));
                while (br.ready()) {
                    br.readLine();
                    ++alreadyRun;
                }
            }
            catch (IOException ex) {
                System.err.println("While reading oneliner.txt:");
                ex.printStackTrace(System.err);
            }
        }
        return alreadyRun;
    }

    public static boolean runbattery(String[] args) {
        String localConf;
        HostHelper.OSType osType = HostHelper.getLocalHostOS();
        String jtests = System.getProperty("JTESTS");
        String gemfire = System.getProperty("GEMFIRE");
        String testFileName = System.getProperty("testFileName");
        if (jtests == null) {
            BatteryTest.usage("Missing JTESTS");
            return false;
        }
        if (gemfire == null) {
            BatteryTest.usage("Missing GEMFIRE");
            return false;
        }
        if (testFileName == null) {
            BatteryTest.usage("Missing testFileName");
            return false;
        }
        String extraJtests = System.getProperty("EXTRA_JTESTS");
        String hadoopDist = System.getProperty("HADOOP_DIST");
        String gfmon = System.getProperty("GFMON");
        String regressionDir = System.getProperty("REGRESSION_EXTRA_PATH");
        String releaseDir = System.getProperty("RELEASE_DIR");
        String jprobe = System.getProperty("JPROBE");
        String codeCoverage = System.getProperty("codeCoverage", null);
        if (codeCoverage != null && codeCoverage.length() == 0) {
            codeCoverage = null;
        }
        if ((localConf = System.getProperty("localConf")) == null) {
            if (FileUtil.exists("local.conf")) {
                localConf = FileUtil.absoluteFilenameFor("local.conf");
            }
        } else if (FileUtil.exists(localConf)) {
            localConf = FileUtil.absoluteFilenameFor(localConf);
        } else {
            BatteryTest.usage("File not found: " + localConf);
            return false;
        }
        String resultDir = System.getProperty("resultDir", System.getProperty("user.dir"));
        int masterHeapMB = Integer.getInteger("masterHeapMB", 256);
        int numTimesToRun = Integer.getInteger("numTimesToRun", new Integer(1));
        String logLevel = System.getProperty("logLevel", "info");
        boolean provideRegressionSummary = Boolean.valueOf(System.getProperty("provideRegressionSummary", "true"));
        boolean removePassedTest = Boolean.getBoolean("removePassedTest");
        boolean grepLogs = Boolean.getBoolean("grepLogs");
        Integer grepLogsHeapMB = Integer.getInteger("grepLogsHeapMB");
        int grepLogsWaitSec = Integer.getInteger("grepLogsWaitSec", 3600);
        boolean nukeHungTest = Boolean.valueOf(System.getProperty("nukeHungTest", "true"));
        boolean moveRemoteDirs = Boolean.getBoolean("moveRemoteDirs");
        boolean moveHadoopData = Boolean.getBoolean(MOVE_HADOOP_DATA);
        boolean parseOnly = Boolean.getBoolean("parseOnly");
        boolean provideBugReportTemplate = Boolean.valueOf(System.getProperty("provideBugReportTemplate", "false"));
        boolean providePropertiesForJenkins = Boolean.valueOf(System.getProperty("providePropertiesForJenkins", "false"));
        boolean provideXMLReport = Boolean.valueOf(System.getProperty("provideXMLReport", "false"));
        Date until = new Date(Long.MAX_VALUE);
        int alreadyRun = 0;
        boolean interruptTest = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-until")) {
                if (i + 3 >= args.length) {
                    BatteryTest.usage("Missing date arguments");
                    return false;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(args[++i]);
                sb.append(" ");
                sb.append(args[++i]);
                sb.append(" ");
                sb.append(args[++i]);
                String date = sb.toString();
                try {
                    until = df.parse(date);
                    continue;
                }
                catch (ParseException ex) {
                    BatteryTest.usage("Malformed date/time: " + date);
                    return false;
                }
            }
            if (args[i].equals("-for")) {
                int duration;
                if (i + 2 >= args.length) {
                    BatteryTest.usage("Missing duration and/or time-units");
                }
                ++i;
                try {
                    duration = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    BatteryTest.usage("Malformed duration: " + args[i]);
                    return false;
                }
                String unit = args[++i].toLowerCase();
                Calendar now = Calendar.getInstance();
                if (unit.startsWith("minute")) {
                    now.roll(12, duration);
                } else if (unit.startsWith("hour")) {
                    now.roll(10, duration);
                } else if (unit.startsWith("day")) {
                    now.roll(5, duration);
                } else {
                    BatteryTest.usage("Unknown time unit: " + unit);
                    return false;
                }
                until = now.getTime();
                continue;
            }
            if (args[i].equals("-continue")) {
                alreadyRun = BatteryTest.countAlreadyRun(resultDir);
                continue;
            }
            if (args[i].equals("-interrupt")) {
                interruptTest = true;
                nukeHungTest = true;
                continue;
            }
            BatteryTest.usage("Unknown command line option: " + args[i]);
            return false;
        }
        log = Log.createLogWriter("batterytest", "batterytest", logLevel, true);
        log.info(ProcessMgr.processAndBuildInfoString());
        log.info("Batterytest PID is " + ProcessMgr.getProcessId());
        log.info("\nJTESTS = " + jtests + "\nEXTRA_JTESTS = " + extraJtests + "\nGEMFIRE = " + gemfire + "\nHADOOP_DIST = " + hadoopDist + "\nGFMON = " + gfmon + "\nREGRESSION_EXTRA_PATH = " + regressionDir + "\nRELEASE_DIR = " + releaseDir + "\nJPROBE = " + jprobe + "\ntestFileName = " + testFileName + "\nlocalConf = " + localConf + "\nresultDir = " + resultDir + "\nmasterHeapMB = " + masterHeapMB + "\nnumTimesToRun = " + numTimesToRun + "\nlogLevel = " + logLevel + "\nprovideRegressionSummary = " + provideRegressionSummary + "\nremovePassedTest = " + removePassedTest + "\ncodeCoverage = " + codeCoverage + "\ngrepLogs = " + grepLogs + "\ngrepLogsHeapMB = " + grepLogsHeapMB + "\ngrepLogsWaitSec = " + grepLogsWaitSec + "\nnukeHungTest = " + nukeHungTest + "\nmoveRemoteDirs = " + moveRemoteDirs + "\nmoveHadoopData = " + moveHadoopData + "\nparseOnly = " + parseOnly + "\nprovideBugReportTemplate = " + provideBugReportTemplate + "\nprovideXMLReport = " + provideXMLReport);
        log.info("Parsing batterytest input file: " + testFileName + "...");
        Vector tests = null;
        try {
            tests = ConfigParser.parseFile(testFileName);
            if (log.fineEnabled()) {
                for (int i = 0; i < tests.size(); ++i) {
                    log.fine("Test " + i + " = " + tests.get(i));
                }
            }
        }
        catch (FileNotFoundException e) {
            log.severe("Batterytest input file not found: " + testFileName, (Throwable)e);
            return false;
        }
        int maxsize = 0;
        for (int i = 0; i < tests.size(); ++i) {
            BatteryTestConfig test = (BatteryTestConfig)tests.elementAt(i);
            maxsize = Math.max(maxsize, test.getName().length());
        }
        log.info("Number of tests in " + testFileName + " is " + tests.size() + "...");
        log.info("Running test file " + numTimesToRun + " times...");
        int totalTests = tests.size() * numTimesToRun;
        log.info("Running a total of " + totalTests + " (" + numTimesToRun + "*" + tests.size() + ") tests");
        log.info("Will execute tests until " + df.format(until));
        log.info("Have previously executed " + alreadyRun + " tests");
        try {
            File dir = new File(resultDir);
            dir.mkdirs();
            new File(dir, "oneliner.txt").createNewFile();
        }
        catch (IOException ex) {
            log.severe("Couldn't touch oneliner.txt", (Throwable)ex);
        }
        if (providePropertiesForJenkins) {
            BatteryTest.providePropertiesForJenkins();
        }
        int passed = 0;
        int failed = 0;
        int hung = 0;
        int testnum = 0;
        block40: for (int i = 0; i < numTimesToRun; ++i) {
            for (int j = 0; j < tests.size(); ++j) {
                String jacocofn;
                boolean terminateEarly;
                boolean success;
                String workdir;
                String host;
                BatteryTestConfig btc;
                block139: {
                    String msg;
                    btc = (BatteryTestConfig)tests.elementAt(j);
                    String relativetest = btc.getName();
                    if (++testnum <= alreadyRun) {
                        log.info("Skipping test " + testnum + " of " + totalTests + ": " + btc + " because it has already been run");
                        continue;
                    }
                    if (new Date().after(until)) {
                        log.info("Stopping battery test because it is after " + df.format(until));
                        break block40;
                    }
                    String test = null;
                    if (FileUtil.exists(relativetest)) {
                        test = FileUtil.absoluteFilenameFor(relativetest);
                    } else if (extraJtests != null) {
                        test = extraJtests + sep + relativetest;
                        if (!FileUtil.exists(test)) {
                            String oldTest = test;
                            test = jtests + sep + relativetest;
                            log.info("test file not found in " + oldTest + " trying in " + test);
                        }
                    } else {
                        test = jtests + sep + relativetest;
                    }
                    int index = test.indexOf(".conf");
                    if (index != -1) {
                        String propFileName = test.substring(0, index) + ".prop";
                        btc.fillInWithDefaultsFrom(propFileName);
                    }
                    log.info("Running test " + testnum + " of " + totalTests + ": " + btc);
                    host = HostHelper.getLocalHost();
                    String cmd = null;
                    String type = null;
                    if (test.indexOf(".conf") != -1) {
                        type = "hydra";
                        cmd = System.getProperty("java.home") + sep + "bin" + sep + "java";
                        String vmType = VmPrms.defaultType();
                        if (vmType != null) {
                            cmd = cmd + " -" + vmType;
                        }
                        cmd = cmd + " -classpath " + System.getProperty("masterClassPath", "") + File.pathSeparator + System.getProperty("java.class.path");
                        cmd = cmd + " -Xmx" + masterHeapMB + "m";
                        cmd = cmd + " -DJTESTS=" + jtests;
                        if (hadoopDist != null) {
                            cmd = cmd + " -DHADOOP_DIST=" + hadoopDist;
                        }
                        if (extraJtests != null) {
                            cmd = cmd + " -DEXTRA_JTESTS=" + extraJtests;
                        }
                        if (gfmon != null) {
                            cmd = cmd + " -DGFMON=" + gfmon;
                        }
                        if (regressionDir != null) {
                            cmd = cmd + " -DREGRESSION_EXTRA_PATH=" + regressionDir;
                        }
                        if (releaseDir != null) {
                            cmd = cmd + " -DRELEASE_DIR=" + releaseDir;
                        }
                        if (jprobe != null) {
                            cmd = cmd + " -DJPROBE=" + jprobe;
                        }
                        cmd = cmd + " -Dsun.rmi.transport.tcp.handshakeTimeout=3600000";
                        if (System.getProperty("java.vm.vendor").startsWith("Sun") && !System.getProperty("java.version").startsWith("1.4")) {
                            cmd = cmd + " -XX:+HeapDumpOnOutOfMemoryError";
                        }
                        cmd = cmd + " -Dgemfire.home=" + gemfire + " -DconfigFileName=" + test + " -DparseOnly=" + parseOnly + " -D" + MOVE_HADOOP_DATA + "=" + moveHadoopData + btc.getPropertyString() + "hydra.MasterController";
                    } else if (test.indexOf(".pl") != -1) {
                        type = "script";
                        cmd = "perl " + test;
                    } else {
                        type = "unknown";
                        cmd = test;
                    }
                    String conf = FileUtil.filenameFor(test);
                    String base = resultDir + sep;
                    base = conf.lastIndexOf(".") == -1 ? base + conf : base + conf.substring(0, conf.lastIndexOf("."));
                    Date d = new Date();
                    String ds = d.toString();
                    workdir = base + "-" + BatteryTest.month(ds.substring(4, 7)) + ds.substring(8, 10) + "-" + ds.substring(11, 13) + ds.substring(14, 16) + ds.substring(17, 19);
                    FileUtil.mkdir(workdir);
                    if (!parseOnly) {
                        BatteryTest.logStatus(host, workdir);
                    }
                    if (type.equals("hydra") && (localConf != null || codeCoverage != null)) {
                        String testLocalConf = workdir + sep + "local.conf";
                        if (localConf != null) {
                            FileUtil.copyFile(localConf, testLocalConf);
                        }
                        if (codeCoverage != null) {
                            String cc = "\nhydra.VmPrms-extraVMArgs += \"" + codeCoverage + "\";\n";
                            FileUtil.appendToFile(testLocalConf, cc);
                        }
                    }
                    String testname = new File(base).getName();
                    btc.writePropertiesToFile(workdir + sep + testname + ".prop");
                    String logfile = null;
                    logfile = type.equals("hydra") ? "bgexecmaster.log" : "bgexectest.log";
                    long starttime = System.currentTimeMillis();
                    int pid = ProcessMgr.bgexec(host, cmd, workdir, logfile);
                    log.info("PID=" + pid);
                    log.info("DIR=" + workdir);
                    log.info("Waiting for test to complete...");
                    if (!parseOnly) {
                        MasterController.sleepForMs(15000);
                    }
                    String spawnfile = workdir + sep + "in_master.txt";
                    String inprogressfile = workdir + sep + "in_progress.txt";
                    String hangfile = workdir + sep + "hang.txt";
                    String errorfile = workdir + sep + "errors.txt";
                    boolean progressFileExists = true;
                    boolean masterProcessExists = true;
                    boolean timeoutOnProcessExists = false;
                    boolean hangFileExists = false;
                    try {
                        do {
                            if (interruptTest && new Date().after(until)) {
                                log.info("Interrupting battery test because it is after " + df.format(until));
                                FileUtil.appendToFile(hangfile, "Batterytest interrupted test at deadline configured with -for or -until");
                                break;
                            }
                            MasterController.sleepForMs(2500);
                            progressFileExists = FileUtil.exists(inprogressfile);
                            masterProcessExists = ProcessMgr.processExists(host, pid);
                        } while (progressFileExists && masterProcessExists);
                        hangFileExists = FileUtil.exists(hangfile);
                        if (!hangFileExists && masterProcessExists) {
                            log.info("Master process is no longer in progress, waiting 60 seconds for it to exit");
                            masterProcessExists = !ProcessMgr.waitForDeath(host, pid, 60);
                        }
                    }
                    catch (HydraTimeoutException e) {
                        timeoutOnProcessExists = true;
                    }
                    long elapsedSec = (System.currentTimeMillis() - starttime) / 1000L;
                    success = true;
                    terminateEarly = false;
                    if (!FileUtil.exists(spawnfile)) {
                        terminateEarly = false;
                        success = false;
                        msg = "Master process failed to get underway, see bgexecmaster_<pid>.log";
                        log.severe(msg);
                    } else {
                        FileUtil.deleteFile(spawnfile);
                    }
                    if (hangFileExists) {
                        terminateEarly = true;
                        success = false;
                        msg = "Test reported a possible hang, see hang.txt";
                        log.severe(msg);
                    }
                    if (!hangFileExists && masterProcessExists) {
                        terminateEarly = true;
                        success = false;
                        msg = "Master process failed to exit within 60 seconds of completion, treating as a hang";
                        log.severe(msg);
                    }
                    if (FileUtil.exists(inprogressfile)) {
                        terminateEarly = true;
                        success = false;
                        msg = "Master process died but claims to be in progress, see in_progress.txt";
                        log.severe(msg);
                    }
                    if (FileUtil.exists(errorfile)) {
                        success = false;
                        msg = "Test failed with errors, see errors.txt";
                        log.severe(msg);
                    }
                    if (FileUtil.exists(workdir + sep + "failed.txt")) {
                        success = false;
                        msg = "Test reported failure";
                        log.severe(msg);
                    }
                    if (timeoutOnProcessExists) {
                        terminateEarly = true;
                        success = false;
                        msg = "Timed out trying to determine whether master process exists: " + pid + ", possibly due to machine overload, treating as hang";
                        log.severe(msg);
                    }
                    StringBuffer oneliner = new StringBuffer(100);
                    StringBuffer dir = new StringBuffer(relativetest);
                    for (int n = 0; n < maxsize - relativetest.length(); ++n) {
                        dir.append(" ");
                    }
                    oneliner.append(dir.toString()).append("    ");
                    if (success) {
                        log.info("RESULT: Test PASSED");
                        oneliner.append("P    ");
                        ++passed;
                    } else if (terminateEarly) {
                        log.info("RESULT: Test HUNG");
                        oneliner.append("H    ");
                        ++hung;
                    } else {
                        log.info("RESULT: Test FAILED");
                        oneliner.append("F    ");
                        ++failed;
                    }
                    NumberFormat nf = NumberFormat.getIntegerInstance();
                    nf.setMinimumIntegerDigits(2);
                    String hrs = "00";
                    if (elapsedSec >= 3600L) {
                        hrs = nf.format(elapsedSec / 3600L).toString();
                    }
                    String mins = "00";
                    if (elapsedSec >= 60L) {
                        mins = nf.format(elapsedSec % 3600L / 60L).toString();
                    }
                    String secs = nf.format(elapsedSec % 60L).toString();
                    oneliner.append(hrs + ":" + mins + ":" + secs + "    " + workdir);
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(resultDir + sep + "oneliner.txt", true);
                    }
                    catch (FileNotFoundException e) {
                        log.severe("Unable to open oneliner.txt", (Throwable)e);
                    }
                    PrintWriter pw = new PrintWriter(fos);
                    pw.println(oneliner.toString());
                    pw.close();
                    if (terminateEarly) {
                        if (nukeHungTest) {
                            if (interruptTest) {
                                log.severe("Interrupting due to deadline configured with -for or -until, nuking test processes for currently running test");
                            } else {
                                log.severe("Proceeding past hung test, nuking test processes");
                            }
                            try {
                                if (osType == HostHelper.OSType.windows) {
                                    log.severe(ProcessMgr.fgexec(workdir + sep + "nukerun.bat", 1800));
                                } else {
                                    log.severe(ProcessMgr.fgexec("sh " + workdir + sep + "nukerun.sh", 600));
                                }
                            }
                            catch (HydraRuntimeException e) {
                                log.severe("Automatic nuke failed -- clean up manually", (Throwable)((Object)e));
                            }
                            try {
                                if (osType == HostHelper.OSType.windows) {
                                    log.severe(ProcessMgr.fgexec(workdir + sep + "nukehadoop.bat", 1800));
                                    break block139;
                                }
                                log.severe(ProcessMgr.fgexec("sh " + workdir + sep + "nukehadoop.sh", 600));
                            }
                            catch (HydraRuntimeException e) {
                                log.severe("Automatic nuke failed -- clean up manually", (Throwable)((Object)e));
                            }
                        } else {
                            BatteryTest.reportStatus(totalTests, passed, failed, hung);
                            log.severe("Terminating early, see last test result");
                            if (!parseOnly) {
                                BatteryTest.logStatus(host, workdir);
                            }
                            return failed + hung == 0;
                        }
                    }
                }
                if (!parseOnly && FileUtil.exists(jacocofn = workdir + sep + JACOCO_FN)) {
                    if (osType == HostHelper.OSType.unix) {
                        try {
                            log.severe("Moving jacoco output to batterytest directory");
                            String jacocofn2 = resultDir + sep + new File(workdir).getName() + "_" + JACOCO_FN;
                            log.severe(ProcessMgr.fgexec("/bin/mv " + jacocofn + " " + jacocofn2, 120));
                        }
                        catch (HydraRuntimeException e) {
                            log.severe("Automatic move for jacoco failed -- move file manually", (Throwable)((Object)e));
                        }
                    } else {
                        log.severe("Automatic move for jacoco not supported on this platform -- move file manually");
                    }
                }
                String script = null;
                script = sep.equals("/") ? workdir + sep + "netclean.sh" : workdir + sep + "netclean.bat";
                if (FileUtil.exists(script)) {
                    log.severe("Cleaning up network connections");
                    try {
                        if (osType == HostHelper.OSType.windows) {
                            log.severe(ProcessMgr.fgexec(script, 300));
                        } else {
                            log.severe(ProcessMgr.fgexec("sh " + script, 300));
                        }
                    }
                    catch (HydraRuntimeException e) {
                        log.severe("Automatic network connection cleanup failed -- clean up manually", (Throwable)((Object)e));
                    }
                }
                if (!parseOnly && moveRemoteDirs && (!terminateEarly || nukeHungTest)) {
                    log.severe("Moving remote directories to test result directory");
                    try {
                        if (osType == HostHelper.OSType.windows) {
                            log.severe(ProcessMgr.fgexec(workdir + sep + "movedirs.bat", 600));
                        } else {
                            log.severe(ProcessMgr.fgexec("sh " + workdir + sep + "movedirs.sh", 600));
                        }
                    }
                    catch (HydraRuntimeException e) {
                        log.severe("Automatic move failed -- clean up manually", (Throwable)((Object)e));
                    }
                }
                try {
                    if (osType == HostHelper.OSType.windows) {
                        log.severe(ProcessMgr.fgexec(workdir + sep + "nukehadoop.bat", 1800));
                    } else {
                        log.severe(ProcessMgr.fgexec("sh " + workdir + sep + "nukehadoop.sh", 600));
                    }
                }
                catch (HydraRuntimeException e) {
                    log.severe("Automatic nuke failed -- clean up manually", (Throwable)((Object)e));
                }
                if (moveHadoopData) {
                    log.severe("Moving Hadoop log and data directories to the test result directory");
                } else {
                    log.severe("Moving Hadoop log directories to the test result directory and removing Hadoop data directories");
                }
                try {
                    if (osType == HostHelper.OSType.windows) {
                        log.severe(ProcessMgr.fgexec(workdir + sep + "movehadoop.bat", 600));
                    } else {
                        log.severe(ProcessMgr.fgexec("sh " + workdir + sep + "movehadoop.sh", 600));
                    }
                }
                catch (HydraRuntimeException e) {
                    log.severe("Automatic clean failed -- clean up manually", (Throwable)((Object)e));
                }
                log.severe("Adding read permission to all files in test result directory");
                try {
                    ProcessMgr.setReadPermission(workdir);
                }
                catch (Exception e) {
                    log.severe(TestHelper.getStackTrace(e));
                    log.severe("Failed to add read permission to all files in test result directory. Please change permissions manually.");
                }
                if (!parseOnly) {
                    BatteryTest.logStatus(host, workdir);
                }
                if (provideRegressionSummary) {
                    Log.getLogWriter().info("Generating summary file...");
                    try {
                        RegressionSummary regrSumm = new RegressionSummary(2, resultDir, resultDir);
                        regrSumm.doSummary();
                    }
                    catch (Exception e) {
                        log.info(TestHelper.getStackTrace(e));
                    }
                }
                if (provideXMLReport) {
                    log.info("Generating XML report for " + workdir + "...");
                    try {
                        XMLReport.createReport(btc.getName(), btc.toTestProps(), localConf, workdir, testFileName);
                    }
                    catch (Exception e) {
                        log.warning("XML report generation failed for " + workdir + "\n" + TestHelper.getStackTrace(e));
                    }
                }
                if (provideBugReportTemplate && (!success || terminateEarly)) {
                    try {
                        log.info("Creating bug report template file for " + workdir + "...");
                        long startTime = System.currentTimeMillis();
                        BugReportTemplate.createTemplateFile(workdir, false);
                        long endTime = System.currentTimeMillis();
                        log.info("Bug report template generated in " + (endTime - startTime) + " ms");
                    }
                    catch (Exception e) {
                        log.info(TestHelper.getStackTrace(e));
                    }
                }
                if (grepLogs && success) {
                    try {
                        BatteryTest.javaGrepLogs(workdir, grepLogsHeapMB, grepLogsWaitSec);
                    }
                    catch (HydraRuntimeException hre) {
                        log.severe(TestHelper.getStackTrace((Throwable)((Object)hre)));
                    }
                    catch (HydraTimeoutException hte) {
                        log.severe(TestHelper.getStackTrace((Throwable)((Object)hte)));
                    }
                }
                if (removePassedTest && success) {
                    log.info("Test passed, deleting " + workdir);
                    if (!FileUtil.rmdir(workdir, false)) {
                        log.warning("Problems deleting: " + workdir);
                    }
                }
                if (!terminateEarly || !interruptTest) continue;
                log.severe("Terminating early due to deadline configured with -for or -until, see last test result");
                break block40;
            }
        }
        BatteryTest.reportStatus(totalTests, passed, failed, hung);
        return failed + hung == 0;
    }

    private static void reportStatus(int total, int passed, int failed, int hung) {
        StringBuffer msg = new StringBuffer(100);
        msg.append("\n").append("==== STATUS REPORT ====");
        msg.append("  Total: ").append(total);
        msg.append("  Tried: ").append(passed + failed + hung);
        msg.append("  Passed: ").append(passed);
        msg.append("  Failed: ").append(failed);
        msg.append("  Hung: ").append(hung);
        msg.append("  Remaining: ").append(total - (passed + failed + hung));
        msg.append("  ====");
        log.info(msg.toString());
    }

    private static void providePropertiesForJenkins() {
        StringBuffer sb = new StringBuffer();
        sb.append("platform.id").append('=').append(1).append('\n');
        sb.append("os.version").append('=').append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append('\n');
        sb.append("java.version").append('=').append(System.getProperty("java.version")).append('\n');
        Properties p = ProductVersionHelper.getInfo();
        if (p != null) {
            sb.append("product.version").append('=').append(p.getProperty("Product-Version")).append('\n');
            sb.append("source.repository").append('=').append(p.getProperty("Source-Repository")).append('\n');
            sb.append("source.revision").append('=').append(p.getProperty("Source-Revision")).append('\n');
        }
        try {
            FileUtil.writeToFile("jenkins.prop", sb.toString());
        }
        catch (HydraRuntimeException e) {
            log.severe(TestHelper.getStackTrace((Throwable)((Object)e)));
        }
    }

    private static void usage(String s) {
        PrintStream out = System.out;
        out.println("\n** " + s + "\n");
        out.println("Usage: java ");
        out.println("  -DGEMFIRE=<path_to_gemfire_product_tree> ");
        out.println("  -DJTESTS=<path_to_test_classes> ");
        out.println("  -DtestFileName=<batterytest_input_file> ");
        out.println("  [-DHADOOP_DIST=<path_to_Hadoop_distribution>] ");
        out.println("  [-DEXTRA_JTESTS=<path_to_extra_test_classes>] ");
        out.println("  [-DGFMON=<path_to_product-testcopy_in_gfmon_product_tree>]");
        out.println("  [-DREGRESSION_EXTRA_PATH=<extra_path_elements_in_autogenerated_regression_director>] ");
        out.println("  [-DRELEASE_DIR=&lt;path_to_gemfire_release_dir&gt;]");
        out.println("  [-DJPROBE=<path_to_jprobe_product_tree>] ");
        out.println("  [-DlocalConf=<local_conf_filename] ");
        out.println("  [-DmasterHeapMB=<max_size_of_master_controller_heap_in_megabytes(default:256)>]");
        out.println("  [-DnumTimesToRun=<number_of_times_to_run_tests_in_input_file(default:1)>] ");
        out.println("  [-DlogLevel=<batterytest_log_level(default:info)>]");
        out.println("  [-DprovideRegressionSummary=<whether_to_provide_a_regression_summary_report(default:true)>]");
        out.println("  [-DremovePassedTest=<whether_to_remove_test_result_dirs_for_passed_test(default:false)>]");
        out.println("  [-DcodeCoverage=<javaagent_command_for_code_coverage(default:null)>]");
        out.println("  [-DgrepLogs=<search_logs_for_suspect_strings(default:false)>]");
        out.println("  [-DgrepLogsHeapMB=<max_size_of_greplogs_heap_in_megabytes(default:unspecified)>]");
        out.println("  [-DgrepLogsHeapWaitSec=<time_in_seconds_to_wait_for_grepLogs_to_complete(default:3600)]");
        out.println("  [-DnukeHungTest=<whether_to_nuke_hung_test_and_keep_going(default:true)>] ");
        out.println("  [-DmoveRemoteDirs=<whether_to_move_remote_dirs_to_master_dir(default:false)>] ");
        out.println("  [-DmoveHadoopData=<whether_to_move_hadoop_data_dirs_to_master_dir(default:false)>] ");
        out.println("  [-DparseOnly=<whether_to_only_parse_test_config(default:false)>] ");
        out.println("  [-DprovideBugReportTemplate=<whether_to_create_bug_report_template(default:false)>] ");
        out.println("  [-DprovidePropertiesForJenkins=<whether_to_create_properties_file_for_Jenkins(default:false)>] ");
        out.println("  [-DprovideXMLReport=<whether_to_create_XML_report(default:false)>] ");
        out.println("batterytest.BatteryTest [options]");
        out.println("");
        out.println("Where options are:");
        out.println("  -until date/time");
        out.println("       Executes tests until a specific date.  Dates are");
        out.println("       specified according to the \"MM/dd/yyyy hh:mm a\"");
        out.println("       SimpleDateFormat.  Example: " + df.format(new Date()));
        out.println("  -for duration time-unit");
        out.println("       The amount of time tests should be executed.");
        out.println("       \"duration\" is an integer and time-unit is one of");
        out.println("       \"minutes\", \"hours\", or \"days\"");
        out.println("  -interrupt");
        out.println("       Interrupts the currently running test if time specified");
        out.println("       with -for or -until has elapsed.");
        out.println("  -continue");
        out.println("       Continues a test run that ended prematurely.  It");
        out.println("       consults oneliner.txt to determine how many tests have");
        out.println("       already been run.  It assumes that battery test is");
        out.println("       being run with the same .bt file as previous runs.");
        out.println("");
    }

    private static String month(String m) {
        if (m.equalsIgnoreCase("Jan")) {
            return "01";
        }
        if (m.equalsIgnoreCase("Feb")) {
            return "02";
        }
        if (m.equalsIgnoreCase("Mar")) {
            return "03";
        }
        if (m.equalsIgnoreCase("Apr")) {
            return "04";
        }
        if (m.equalsIgnoreCase("May")) {
            return "05";
        }
        if (m.equalsIgnoreCase("Jun")) {
            return "06";
        }
        if (m.equalsIgnoreCase("Jul")) {
            return "07";
        }
        if (m.equalsIgnoreCase("Aug")) {
            return "08";
        }
        if (m.equalsIgnoreCase("Sep")) {
            return "09";
        }
        if (m.equalsIgnoreCase("Oct")) {
            return "10";
        }
        if (m.equalsIgnoreCase("Nov")) {
            return "11";
        }
        if (m.equalsIgnoreCase("Dec")) {
            return "12";
        }
        return null;
    }

    private static void logStatus(String host, String workdir) {
        String status = "";
        try {
            status = status + "\n" + ProcessMgr.getProcessStatus(60) + "\n";
        }
        catch (HydraRuntimeException e) {
            BatteryTest.logError("Unable to log process status: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
        catch (HydraTimeoutException e) {
            BatteryTest.logError("Unable to log process status: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
        try {
            status = status + "\n" + ProcessMgr.getMemoryStatus(60) + "\n";
        }
        catch (HydraRuntimeException e) {
            BatteryTest.logError("Unable to log memory status: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
        catch (HydraTimeoutException e) {
            BatteryTest.logError("Unable to log memory status: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
        String fn = workdir + File.separator + "hoststats_" + host + ".txt";
        FileUtil.appendToFile(fn, status);
    }

    private static void logError(String msg) {
        if (log == null) {
            System.err.println(msg);
        } else {
            log.severe(msg);
        }
    }

    public static void javaGrepLogs(String workdir, Integer maxHeap, int maxWaitSec) {
        String sep = File.separator;
        String userDir = System.getProperty("user.dir");
        String suspectDir = userDir + sep + "suspectStrings";
        FileUtil.mkdir(suspectDir);
        String bgexecDir = suspectDir + sep + "bgexeclogs";
        FileUtil.mkdir(bgexecDir);
        File tmp = new File(workdir);
        String grepOutput = suspectDir + sep + tmp.getName() + ".txt";
        String xmx = maxHeap == null ? "" : "-Xmx" + maxHeap + "m ";
        log.info("Grepping logs for suspect strings: " + workdir);
        String cmd = System.getProperty("java.home") + sep + "bin" + sep + "java -classpath " + System.getProperty("java.class.path") + " -Duser.dir=" + userDir + " " + xmx + "batterytest.greplogs.GrepLogs -hydra -type battery -out " + grepOutput + " " + workdir;
        int pid = ProcessMgr.bgexec(cmd, bgexecDir, null);
        log.info("Waiting " + maxWaitSec + " seconds for greplogs PID=" + pid + " to complete");
        String host = HostHelper.getLocalHost();
        if (!ProcessMgr.waitForDeath(host, pid, maxWaitSec)) {
            String err = "Waited more than " + maxWaitSec + " seconds for greplogs PID=" + pid + " to complete";
            boolean killed = ProcessMgr.killProcessWait(host, pid, 30);
            if (killed) {
                throw new HydraTimeoutException(err + ", killed process");
            }
            throw new HydraTimeoutException(err + ", failed to kill process");
        }
        log.info("greplogs PID=" + pid + " has completed");
    }
}

