/*
 * Decompiled with CFR 0.152.
 */
package asyncMsg;

import asyncMsg.AsyncMsgTest;
import asyncMsg.SleepListenerPrms;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.MasterController;
import util.AbstractListener;
import util.BaseValueHolder;

public class SleepListener
extends AbstractListener
implements CacheListener {
    static int sleepMs = SleepListenerPrms.getSleepMs();

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        String key = (String)event.getKey();
        if (key.equals("SleepKey")) {
            Integer val = (Integer)event.getNewValue();
            sleepMs = val;
            Log.getLogWriter().info("SleepListener.afterCreate() - new sleepMs = " + sleepMs);
        }
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void afterUpdate(EntryEvent event) {
        String key;
        this.logCall("afterUpdate", (CacheEvent)event);
        if (event.getNewValue() instanceof BaseValueHolder) {
            int numUpdates = AsyncMsgTest.incNumUpdatesThisRound();
            Log.getLogWriter().info("afterUpdate: after incrementing counter, numUpdatesThisRound = " + numUpdates);
        }
        if ((key = (String)event.getKey()).equals("SleepKey")) {
            Integer val = (Integer)event.getNewValue();
            sleepMs = val;
            Log.getLogWriter().info("SleepListener.afterCreate() - new sleepMs = " + sleepMs);
        }
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        Log.getLogWriter().info("Sleeping for " + sleepMs);
        MasterController.sleepForMs(sleepMs);
        Log.getLogWriter().info("done Sleeping for " + sleepMs);
    }

    public void close() {
        this.logCall("close", null);
    }
}

