/*
 * Decompiled with CFR 0.152.
 */
package admin.keepalive;

import admin.AdminPrms;
import admin.CacheServerAdminTest;
import cacheLoader.smoke.Loader;
import cacheLoader.smoke.ObjectListener;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.util.Iterator;
import java.util.Set;
import util.CacheBB;
import util.CacheUtil;
import util.TestException;

public class RemoteVmTest
extends CacheServerAdminTest {
    protected static RemoteVmTest remoteVmTest = null;
    protected static final String REGION_NAME = "CacheLoaderTest";
    protected static final String MASTER_REGION_NAME = "MasterData";
    protected static final String CACHED_REGION_NAME = "CachedData";

    public static synchronized void initializeForAdminTask() {
        if (remoteVmTest == null) {
            remoteVmTest = new RemoteVmTest();
            CacheUtil.createCache();
            remoteVmTest.initializeForAdmin();
        }
    }

    public static void startCacheServerTask() {
        remoteVmTest.startCacheServer();
    }

    public static void defineCacheServerRegionsTask() {
        remoteVmTest.defineCacheServerRegions();
    }

    private void defineCacheServerRegions() {
        CacheVm[] cacheServers = null;
        if (this.admin == null) {
            RemoteVmTest.log().info("admin is null");
        }
        try {
            cacheServers = this.admin.getCacheVms();
        }
        catch (AdminException ae) {
            throw new HydraRuntimeException("Could not get Cache Servers");
        }
        if (cacheServers.length == 0) {
            RemoteVmTest.log().info("Admin found 0 configured cache servers");
        } else {
            RemoteVmTest.log().info("Admin found: " + cacheServers.length + " cacheServers");
        }
        for (int i = 0; i < cacheServers.length; ++i) {
            this.defineCacheRegions(cacheServers[i]);
        }
    }

    private void defineCacheRegions(CacheVm cacheServer) {
        SystemMemberRegion root;
        SystemMemberCache cache;
        boolean defineCacheLoader = AdminPrms.getDefineCacheLoaderRemote();
        RemoteVmTest.log().info("getDefineCacheLoader returned: " + defineCacheLoader);
        try {
            cache = cacheServer.getCache();
        }
        catch (AdminException ae) {
            throw new TestException("Unable to get CacheServer cache", ae);
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(CacheBB.getBB().getScopeAttribute());
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes regAttrs = factory.createRegionAttributes();
        try {
            root = cache.createVMRegion(REGION_NAME, regAttrs);
        }
        catch (AdminException ae) {
            throw new TestException("Unable to create region: CacheLoaderTest");
        }
        try {
            SystemMemberRegion master = root.createSubregion(MASTER_REGION_NAME, regAttrs);
        }
        catch (AdminException ae) {
            throw new TestException("Unable to create sub region: MasterData");
        }
        AttributesFactory factory2 = new AttributesFactory();
        factory2.setScope(CacheBB.getBB().getScopeAttribute());
        ObjectListener objEventListnr = new ObjectListener();
        factory2.setCacheListener((CacheListener)objEventListnr);
        factory2.setCacheWriter((CacheWriter)objEventListnr);
        if (defineCacheLoader) {
            Loader cacheLoader = new Loader();
            factory2.setCacheLoader((CacheLoader)cacheLoader);
            factory2.setMirrorType(MirrorType.NONE);
        } else {
            factory2.setMirrorType(MirrorType.KEYS_VALUES);
        }
        try {
            SystemMemberRegion cachedRegion = root.createSubregion(CACHED_REGION_NAME, factory2.createRegionAttributes());
        }
        catch (AdminException ae) {
            throw new TestException("Unable to create sub region: CachedData");
        }
        RemoteVmTest.log().info("Regions created... debug:");
        this.regionDebug((SystemMember)cacheServer);
    }

    private void regionDebug(SystemMember systemMember) {
        SystemMemberCache cache;
        try {
            cache = systemMember.getCache();
        }
        catch (Exception e) {
            throw new TestException("Could get System Member Cache for region debug", e);
        }
        cache.refresh();
        Set rootRegionNames = cache.getRootRegionNames();
        RemoteVmTest.log().info("DEBUG Found " + rootRegionNames.size() + " root regions");
        Iterator it = rootRegionNames.iterator();
        while (it.hasNext()) {
            try {
                SystemMemberRegion region = cache.getRegion((String)it.next());
                Log.getLogWriter().info("DEBUG Root region = " + region.getName());
                RemoteVmTest.log().info("CacheLoader: " + region.getCacheLoader());
                RemoteVmTest.log().info("CacheWriter: " + region.getCacheWriter());
                RemoteVmTest.log().info("InitialCapacity: " + region.getInitialCapacity());
                RemoteVmTest.log().info("Concurrency Level: " + region.getConcurrencyLevel());
                RemoteVmTest.log().info("scope: " + region.getScope());
                RemoteVmTest.log().info("DataPolicy: " + region.getDataPolicy().toString());
            }
            catch (AdminException ae) {
                throw new TestException("Failed to get root region: " + (String)it.next());
            }
        }
    }
}

