/*
 * Decompiled with CFR 0.152.
 */
package admin.jmx;

import admin.jmx.StatAlertNotificationListener;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import hydra.AgentHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXHelper {
    private static ObjectName agent;
    private static ObjectName distributedSys;
    private static JMXConnector connector;
    private static MBeanServerConnection mbsc;
    private static NotificationListener listener;
    static LogWriter logger;
    static final String JMX_URI = "service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/jmxconnector";
    static final String MBEAN_DOMAIN_GEMFIRE_NAME = "GemFire";
    static final String MBEAN_AGENT_TYPE = "Agent";
    static final String MBEAN_PROPERTY_BEAN_TYPE = "type";
    static final String MBEAN_DISTRIBUTED_SYSTEM_TYPE = "AdminDistributedSystem";

    public static void main(String[] args) throws Exception {
        String host = args[0];
        int port = Integer.valueOf(args[1]);
        JMXHelper.connectToDS(host, port);
    }

    public static void startJMXAgent() {
        JMXHelper.startJMXAgentButDoNotConnect();
        AgentHelper.connectAgent();
    }

    public static void startJMXAgentButDoNotConnect() {
        String agentConfig = ConfigPrms.getAgentConfig();
        AgentHelper.createAgent(agentConfig);
        AgentHelper.startAgent();
    }

    public static void disconnectAndThenReconnectToDSNoListeners() throws Exception {
        if (connector == null) {
            JMXHelper.connectToDSButDoNotAttachListeners();
            return;
        }
        if (listener != null) {
            mbsc.removeNotificationListener(distributedSys, listener);
        }
        JMXHelper.disconnectFromDS();
        connector.close();
        JMXHelper.connectToDSButDoNotAttachListeners();
    }

    public static void connectToDSButDoNotAttachListeners() throws Exception {
        int port = -1;
        String host = "";
        List vals = AgentHelper.getEndpoints();
        Iterator iter = vals.iterator();
        if (iter.hasNext()) {
            AgentHelper.Endpoint endpoint = (AgentHelper.Endpoint)iter.next();
            port = endpoint.getPort();
            host = endpoint.getHost();
        }
        JMXHelper.connectToDS(host, port);
    }

    public static void connectToDS() throws Exception {
        JMXHelper.connectToDSButDoNotAttachListeners();
        listener = new StatAlertNotificationListener(40L);
        NotificationFilterSupport support = new NotificationFilterSupport();
        support.enableType("gemfire.distributedsystem.statalert");
        mbsc.addNotificationListener(distributedSys, listener, (NotificationFilter)support, new Object());
        logger.info("Connected to JMX ADS " + distributedSys);
    }

    public static void connectToDS(String host, int port) throws Exception {
        String url = MessageFormat.format(JMX_URI, host, String.valueOf(port));
        try {
            String onType;
            JMXServiceURL jmxurl = new JMXServiceURL(url);
            connector = JMXConnectorFactory.connect(jmxurl, null);
            mbsc = connector.getMBeanServerConnection();
            String[] domains = mbsc.getDomains();
            String domain = null;
            for (int i = 0; i < domains.length; ++i) {
                if (!domains[i].equalsIgnoreCase(MBEAN_DOMAIN_GEMFIRE_NAME)) continue;
                domain = domains[i];
                break;
            }
            Set<ObjectName> set = mbsc.queryNames(new ObjectName(domain + ":*"), null);
            ObjectName on = null;
            Iterator<ObjectName> iter = set.iterator();
            while (iter.hasNext() && !MBEAN_AGENT_TYPE.equalsIgnoreCase(onType = (on = iter.next()).getKeyProperty(MBEAN_PROPERTY_BEAN_TYPE))) {
            }
            agent = on;
            if (agent == null) {
                throw new ServiceNotFoundException("Agent could not be connected");
            }
            Object[] params = new String[]{};
            String[] signature = new String[]{};
            String method = "connectToSystem";
            ObjectName ret = null;
            ret = (ObjectName)mbsc.invoke(agent, method, params, signature);
            logger.info("Connected DS client");
            if (ret == null || !MBEAN_DISTRIBUTED_SYSTEM_TYPE.equalsIgnoreCase(ret.getKeyProperty(MBEAN_PROPERTY_BEAN_TYPE))) {
                ServiceNotFoundException ex = new ServiceNotFoundException("AdminDistributedSystem could not be connected");
                throw ex;
            }
            distributedSys = ret;
        }
        catch (NullPointerException nullEx) {
            logger.error(url + " is construed NULL", (Throwable)nullEx);
            throw nullEx;
        }
        catch (MalformedURLException malfEx) {
            logger.error(url + " is construed Malformed", (Throwable)malfEx);
            throw malfEx;
        }
        catch (SecurityException secuEx) {
            logger.error("Connection denied due to Security reasons", (Throwable)secuEx);
            throw secuEx;
        }
        catch (InstanceNotFoundException instEx) {
            logger.error("Did not find MBean Instance", (Throwable)instEx);
            throw instEx;
        }
        catch (MBeanException beanEx) {
            logger.error("Exception in MBean", beanEx.getCause());
            throw beanEx;
        }
        catch (ReflectionException reflEx) {
            logger.error("Could not get MBean Info", (Throwable)reflEx);
            throw reflEx;
        }
        catch (IOException ioEx) {
            logger.error("JMX Connection problem. Attempt opeartion Again", (Throwable)ioEx);
            throw ioEx;
        }
    }

    public static void disconnectFromDS() throws Exception {
        try {
            String onType;
            String[] domains = mbsc.getDomains();
            String domain = null;
            for (int i = 0; i < domains.length; ++i) {
                if (!domains[i].equalsIgnoreCase(MBEAN_DOMAIN_GEMFIRE_NAME)) continue;
                domain = domains[i];
                break;
            }
            Set<ObjectName> set = mbsc.queryNames(new ObjectName(domain + ":*"), null);
            ObjectName on = null;
            Iterator<ObjectName> iter = set.iterator();
            while (iter.hasNext() && !MBEAN_AGENT_TYPE.equalsIgnoreCase(onType = (on = iter.next()).getKeyProperty(MBEAN_PROPERTY_BEAN_TYPE))) {
            }
            agent = on;
            if (agent == null) {
                throw new ServiceNotFoundException("Agent could not be contacted");
            }
            Object[] params = new String[]{};
            String[] signature = new String[]{};
            String method = "disconnectFromSystem";
            Object ret = null;
            mbsc.invoke(agent, method, params, signature);
            logger.info("DisConnected DS client");
        }
        catch (SecurityException secuEx) {
            logger.error("Connection denied due to Security reasons", (Throwable)secuEx);
            throw secuEx;
        }
        catch (InstanceNotFoundException instEx) {
            logger.error("Did not find MBean Instance", (Throwable)instEx);
            throw instEx;
        }
        catch (MBeanException beanEx) {
            logger.error("Exception in MBean", beanEx.getCause());
            throw beanEx;
        }
        catch (ReflectionException reflEx) {
            logger.error("Could not get MBean Info", (Throwable)reflEx);
            throw reflEx;
        }
        catch (IOException ioEx) {
            logger.error("JMX Connection problem. Attempt opeartion Again", (Throwable)ioEx);
            throw ioEx;
        }
    }

    public static void registerStatAlertDefinition(StatAlertDefinition def) throws Exception {
        Object[] params = new Object[]{def};
        String[] signature = new String[]{"com.gemstone.gemfire.internal.admin.StatAlertDefinition"};
        mbsc.invoke(distributedSys, "updateAlertDefinition", params, signature);
    }

    public static void killClient() throws Exception {
        try {
            ClientVmMgr.stop("killing myself", -21, -30);
            return;
        }
        catch (ClientVmNotFoundException ex) {
            throw new HydraRuntimeException("I should always be able to kill myself", ex);
        }
    }

    static {
        logger = Log.getLogWriter();
    }
}

