/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.util;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.util.TestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AEQHelper {
    protected static final Logger logger = LoggerFactory.getLogger(AEQHelper.class);
    static long waitEndTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAsyncEventQueuesToDrainOnce() {
        long waitRequestedTime = System.currentTimeMillis();
        logger.info("Wait for async event queues requested time is " + waitRequestedTime + ", end time is : " + waitEndTime);
        Class<AEQHelper> clazz = AEQHelper.class;
        synchronized (AEQHelper.class) {
            if (waitRequestedTime > waitEndTime) {
                try {
                    AEQHelper.waitForAsyncEventQueuesToDrain();
                }
                finally {
                    waitEndTime = System.currentTimeMillis();
                    logger.info("Wait end time is " + waitEndTime);
                }
            } else {
                logger.info("This thread is not waiting for async event queues to drain because it was done by another thread in this member");
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static void waitForAsyncEventQueuesToDrain() {
        GemFireCacheImpl theCache = GemFireCacheImpl.getInstance();
        if (theCache == null) {
            logger.info("No async event queues to wait for; cache is null");
            return;
        }
        HashMap<String, Region> queueRegions = new HashMap<String, Region>();
        GemFireCacheImpl gfci = theCache;
        Set senderSet = gfci.getAllGatewaySenders();
        if (senderSet == null || senderSet.size() == 0) {
            logger.info("No gateway senders in this member");
        } else {
            for (GatewaySender sender : senderSet) {
                List<Region> regions = AEQHelper.getGatewaySenderRegions(sender);
                for (Region region : regions) {
                    queueRegions.put(region.getFullPath(), region);
                }
            }
        }
        Set queues = gfci.getAsyncEventQueues();
        for (AsyncEventQueue queue : queues) {
            List<Region> regions = AEQHelper.getGatewaySenderRegions((GatewaySender)((AsyncEventQueueImpl)queue).getSender());
            for (Region region : regions) {
                queueRegions.put(region.getFullPath(), region);
            }
        }
        if (queueRegions.size() == 0) {
            logger.info("No async event queue regions found in this member.");
        }
        int MS_TO_SLEEP = 1000;
        int MAX_WAITS = 300;
        int waits = 0;
        while (waits++ < 300) {
            boolean allQueuesEmpty = true;
            for (Map.Entry entry : queueRegions.entrySet()) {
                String regionName = (String)entry.getKey();
                if (((Region)entry.getValue()).isDestroyed()) continue;
                int currentRegionSize = ((Region)entry.getValue()).size();
                logger.info("Queue size for " + regionName + ": " + currentRegionSize);
                if (currentRegionSize == 0) continue;
                allQueuesEmpty = false;
            }
            if (allQueuesEmpty) {
                logger.info("All async event queues are empty");
                break;
            }
            DistributedTestBase.sleepForMs(1000);
        }
        if (waits == 300) {
            throw new TestException("queues never drained");
        }
    }

    private static List<Region> getGatewaySenderRegions(GatewaySender sender) {
        ArrayList<Region> regions = new ArrayList<Region>();
        AbstractGatewaySenderEventProcessor processor = ((AbstractGatewaySender)sender).getEventProcessor();
        if (processor == null) {
            return regions;
        }
        if (processor instanceof SerialGatewaySenderEventProcessor) {
            regions.add(processor.getQueue().getRegion());
            logger.info("Serial gateway sender " + sender.getId() + " uses region named " + processor.getQueue().getRegion().getFullPath());
        } else if (processor instanceof ParallelGatewaySenderEventProcessor) {
            ParallelGatewaySenderQueue queue = (ParallelGatewaySenderQueue)processor.getQueue();
            Set regSet = queue.getRegions();
            regions.addAll(regSet);
            StringBuilder sb = new StringBuilder();
            sb.append("Parallel gateway sender " + sender.getId() + " uses " + regSet.size() + " regions");
            for (Region aRegion : regSet) {
                sb.append(" " + aRegion.getFullPath());
            }
            logger.info(sb.toString());
        } else if (processor instanceof ConcurrentSerialGatewaySenderEventProcessor) {
            ConcurrentSerialGatewaySenderEventProcessor cProcessor = (ConcurrentSerialGatewaySenderEventProcessor)processor;
            Set queues = cProcessor.getQueues();
            StringBuilder sb = new StringBuilder();
            sb.append("Concurrent serial gateway sender " + sender.getId() + " uses " + queues.size() + " regions");
            for (RegionQueue queue : queues) {
                Region aRegion = queue.getRegion();
                regions.add(aRegion);
                sb.append(" " + aRegion.getFullPath());
            }
            logger.info(sb.toString());
        } else if (processor instanceof ConcurrentParallelGatewaySenderEventProcessor) {
            regions.addAll(((ConcurrentParallelGatewaySenderQueue)processor.getQueue()).getRegions());
        } else {
            throw new TestException("Unknown processor class: " + processor.getClass().getName());
        }
        return regions;
    }
}

