/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit.standalone;

import io.snappydata.test.dunit.RemoteDUnitVMIF;
import io.snappydata.test.hydra.MethExecutor;
import io.snappydata.test.hydra.MethExecutorResult;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDUnitVM
extends UnicastRemoteObject
implements RemoteDUnitVMIF {
    private static final Logger logger = LoggerFactory.getLogger(RemoteDUnitVM.class);

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName) {
        String name = obj.getClass().getName() + "." + methodName + " on object: " + obj;
        logger.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName);
        long delta = System.currentTimeMillis() - start;
        logger.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName, Object[] args) {
        String name = obj.getClass().getName() + "." + methodName + (args != null ? " with " + args.length + " args" : "") + " on object: " + obj;
        logger.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName, args);
        long delta = System.currentTimeMillis() - start;
        logger.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    public MethExecutorResult executeMethodOnClass(String className, String methodName) {
        String name = className + "." + methodName;
        logger.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName);
        long delta = System.currentTimeMillis() - start;
        logger.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnClass(String className, String methodName, Object[] args) {
        String name = className + "." + methodName + (args != null ? " with " + args.length + " args" : "");
        logger.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName, args);
        long delta = System.currentTimeMillis() - start;
        logger.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    public void executeTask(int tsid, int type, int index) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void runShutdownHook() throws RemoteException {
    }

    public void notifyDynamicActionComplete(int actionId) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void shutDownVM(boolean disconnect, boolean runShutdownHook) throws RemoteException {
    }

    public void disconnectVM() throws RemoteException {
    }
}

