/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit.standalone;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import io.snappydata.test.dunit.standalone.DUnitLauncher;
import io.snappydata.test.dunit.standalone.RemoteDUnitVM;
import java.rmi.Naming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildVM {
    private static final Logger logger = LoggerFactory.getLogger(ChildVM.class);

    public static void main(String[] args) throws Throwable {
        try {
            int namingPort = Integer.getInteger("gemfire.DUnitLauncher.RMI_PORT");
            int vmNum = Integer.getInteger("gemfire.DUnitLauncher.VM_NUM");
            int pid = NativeCalls.getInstance().getProcessId();
            logger.info("VM" + vmNum + " is launching" + (pid > 0 ? " with PID " + pid : ""));
            DUnitLauncher.MasterRemote holder = (DUnitLauncher.MasterRemote)Naming.lookup("//localhost:" + namingPort + "/" + "DUNIT_MASTER");
            DUnitLauncher.init(holder);
            DUnitLauncher.locatorPort = holder.getLocatorPort();
            Naming.rebind("//localhost:" + namingPort + "/vm" + vmNum, new RemoteDUnitVM());
            holder.signalVMReady();
            while (true) {
                holder.ping();
                Thread.sleep(1000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
            return;
        }
    }
}

