/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit.standalone;

import io.snappydata.test.dunit.standalone.DUnitBB;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class AnyCyclicBarrier {
    private static final String KEY_PREFIX = "DUNIT_CYCLIC_BARRIER_";
    private final DUnitBB bb = DUnitBB.getBB();
    private final int parties;
    private final String keyName;
    private final AtomicInteger awaitRound;

    public AnyCyclicBarrier(int parties, String lockName) {
        this.parties = parties;
        this.keyName = KEY_PREFIX + lockName;
        this.awaitRound = new AtomicInteger(1);
    }

    public void await() throws InterruptedException, BrokenBarrierException {
        try {
            this.await(-1L);
        }
        catch (TimeoutException te) {
            throw new AssertionError("unexpected timeout exception", te);
        }
    }

    public void await(long timeoutInMillis) throws InterruptedException, BrokenBarrierException, TimeoutException {
        if (this.parties <= 1) {
            return;
        }
        long start = System.currentTimeMillis();
        int waiters = this.bb.addAndGet(this.keyName, 1, 1);
        while (waiters < this.parties * this.awaitRound.get()) {
            if (timeoutInMillis >= 0L && System.currentTimeMillis() - start > timeoutInMillis) {
                throw new TimeoutException("exceeded timeout of " + timeoutInMillis + "ms waiting on barrier");
            }
            Thread.sleep(10L);
            Object waitersObj = this.bb.get(this.keyName);
            if (waitersObj == null) {
                throw new BrokenBarrierException("Barrier broken: object destroyed");
            }
            waiters = (Integer)waitersObj;
        }
        this.awaitRound.incrementAndGet();
    }

    public void destroy() {
        this.bb.remove(this.keyName);
    }

    public static void destroy(String lockName) {
        DUnitBB.getBB().remove(KEY_PREFIX + lockName);
    }
}

