/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit;

import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.BounceResult;
import io.snappydata.test.dunit.DUnitEnv;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.RemoteDUnitVMIF;
import io.snappydata.test.dunit.RepeatableRunnable;
import io.snappydata.test.hydra.MethExecutorResult;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;

public class VM
implements Serializable {
    private Host host;
    private int pid;
    private RemoteDUnitVMIF client;
    private volatile boolean available;

    public VM(Host host, int pid, RemoteDUnitVMIF client) {
        this.host = host;
        this.pid = pid;
        this.client = client;
        this.available = true;
    }

    public Host getHost() {
        return this.host;
    }

    public int getPid() {
        return this.pid;
    }

    public Object invoke(Class c, String methodName) {
        return this.invoke(c, methodName, new Object[0]);
    }

    public AsyncInvocation invokeAsync(Class c, String methodName) {
        return this.invokeAsync(c, methodName, null);
    }

    public Object invoke(Class c, String methodName, Object arg) {
        return this.invoke(c, methodName, new Object[]{arg});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Class c, String methodName, Object[] args) {
        if (!this.available) {
            String s = "VM not available: " + this;
            throw new RMIException(this, c.getName(), methodName, new IllegalStateException(s));
        }
        MethExecutorResult result = null;
        int retryCount = 120;
        while (true) {
            try {
                result = this.client.executeMethodOnClass(c.getName(), methodName, args);
            }
            catch (RemoteException e) {
                boolean isWindows = false;
                String os = System.getProperty("os.name");
                if (os != null && os.indexOf("Windows") != -1) {
                    isWindows = true;
                }
                if (isWindows && retryCount-- > 0) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                throw new RMIException(this, c.getName(), methodName, e);
            }
            break;
        }
        if (!result.exceptionOccurred()) {
            return result.getResult();
        }
        Throwable thr = result.getException();
        throw new RMIException(this, c.getName(), methodName, thr, result.getStackTrace());
    }

    public AsyncInvocation invokeAsync(final Class c, final String methodName, final Object[] args) {
        AsyncInvocation ai = new AsyncInvocation(c, methodName, new Runnable(){

            @Override
            public void run() {
                Object o = VM.this.invoke(c, methodName, args);
                AsyncInvocation.setReturnValue(o);
            }
        });
        ai.start();
        return ai;
    }

    public AsyncInvocation invokeAsync(final Object o, final String methodName, final Object[] args) {
        AsyncInvocation ai = new AsyncInvocation(o, methodName, new Runnable(){

            @Override
            public void run() {
                Object ret = VM.this.invoke(o, methodName, args);
                AsyncInvocation.setReturnValue(ret);
            }
        });
        ai.start();
        return ai;
    }

    public AsyncInvocation invokeAsync(Runnable r) {
        return this.invokeAsync(r, "run", new Object[0]);
    }

    public AsyncInvocation invokeAsync(Callable c) {
        return this.invokeAsync(c, "call", new Object[0]);
    }

    public void invoke(Runnable r) {
        this.invoke(r, "run");
    }

    public Object invoke(Callable c) {
        return this.invoke(c, "call");
    }

    public void invokeRepeatingIfNecessary(RepeatableRunnable o, long repeatTimeoutMs) {
        this.invoke(o, "runRepeatingIfNecessary", new Object[]{repeatTimeoutMs});
    }

    public Object invoke(Object o, String methodName) {
        return this.invoke(o, methodName, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object o, String methodName, Object[] args) {
        if (!this.available) {
            String s = "VM not available: " + this;
            throw new RMIException(this, o.getClass().getName(), methodName, new IllegalStateException(s));
        }
        MethExecutorResult result = null;
        int retryCount = 120;
        while (true) {
            try {
                if (args == null) {
                    result = this.client.executeMethodOnObject(o, methodName);
                    break;
                }
                result = this.client.executeMethodOnObject(o, methodName, args);
            }
            catch (RemoteException e) {
                if (retryCount-- > 0) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                throw new RMIException(this, o.getClass().getName(), methodName, e);
            }
            break;
        }
        if (!result.exceptionOccurred()) {
            return result.getResult();
        }
        Throwable thr = result.getException();
        throw new RMIException(this, o.getClass().getName(), methodName, thr, result.getStackTrace());
    }

    public void invokeMain(Class c, String[] args) {
        Object[] stupid = new Object[]{args};
        this.invoke(c, "main", stupid);
    }

    public AsyncInvocation invokeMainAsync(Class c, String[] args) {
        Object[] stupid = new Object[]{args};
        return this.invokeAsync(c, "main", stupid);
    }

    public boolean invokeBoolean(Class c, String methodName) {
        return this.invokeBoolean(c, methodName, new Object[0]);
    }

    public boolean invokeBoolean(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a boolean";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a boolean";
        throw new IllegalArgumentException(s);
    }

    public boolean invokeBoolean(Object o, String methodName) {
        return this.invokeBoolean(o, methodName, new Object[0]);
    }

    public boolean invokeBoolean(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a boolean";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a boolean";
        throw new IllegalArgumentException(s);
    }

    public char invokeChar(Class c, String methodName) {
        return this.invokeChar(c, methodName, new Object[0]);
    }

    public char invokeChar(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a char";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Character) {
            return ((Character)result).charValue();
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a char";
        throw new IllegalArgumentException(s);
    }

    public char invokeChar(Object o, String methodName) {
        return this.invokeChar(o, methodName, new Object[0]);
    }

    public char invokeChar(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a char";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Character) {
            return ((Character)result).charValue();
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a char";
        throw new IllegalArgumentException(s);
    }

    public byte invokeByte(Class c, String methodName) {
        return this.invokeByte(c, methodName, new Object[0]);
    }

    public byte invokeByte(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a byte";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Byte) {
            return (Byte)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a byte";
        throw new IllegalArgumentException(s);
    }

    public byte invokeByte(Object o, String methodName) {
        return this.invokeByte(o, methodName, new Object[0]);
    }

    public byte invokeByte(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a byte";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Byte) {
            return (Byte)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a byte";
        throw new IllegalArgumentException(s);
    }

    public short invokeShort(Class c, String methodName) {
        return this.invokeShort(c, methodName, new Object[0]);
    }

    public short invokeShort(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a short";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Short) {
            return (Short)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a short";
        throw new IllegalArgumentException(s);
    }

    public short invokeShort(Object o, String methodName) {
        return this.invokeShort(o, methodName, new Object[0]);
    }

    public short invokeShort(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a short";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Short) {
            return (Short)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a short";
        throw new IllegalArgumentException(s);
    }

    public int invokeInt(Class c, String methodName) {
        return this.invokeInt(c, methodName, new Object[0]);
    }

    public int invokeInt(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a int";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a int";
        throw new IllegalArgumentException(s);
    }

    public int invokeInt(Object o, String methodName) {
        return this.invokeInt(o, methodName, new Object[0]);
    }

    public int invokeInt(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a int";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a int";
        throw new IllegalArgumentException(s);
    }

    public long invokeLong(Class c, String methodName) {
        return this.invokeLong(c, methodName, new Object[0]);
    }

    public long invokeLong(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a long";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a long";
        throw new IllegalArgumentException(s);
    }

    public long invokeLong(Object o, String methodName) {
        return this.invokeLong(o, methodName, new Object[0]);
    }

    public long invokeLong(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a long";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a long";
        throw new IllegalArgumentException(s);
    }

    public float invokeFloat(Class c, String methodName) {
        return this.invokeFloat(c, methodName, new Object[0]);
    }

    public float invokeFloat(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a float";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Float) {
            return ((Float)result).floatValue();
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a float";
        throw new IllegalArgumentException(s);
    }

    public float invokeFloat(Object o, String methodName) {
        return this.invokeFloat(o, methodName, new Object[0]);
    }

    public float invokeFloat(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a float";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Float) {
            return ((Float)result).floatValue();
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a float";
        throw new IllegalArgumentException(s);
    }

    public double invokeDouble(Class c, String methodName) {
        return this.invokeDouble(c, methodName, new Object[0]);
    }

    public double invokeDouble(Class c, String methodName, Object[] args) {
        Object result = this.invoke(c, methodName, args);
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a double";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Double) {
            return (Double)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a double";
        throw new IllegalArgumentException(s);
    }

    public double invokeDouble(Object o, String methodName) {
        return this.invokeDouble(o, methodName, new Object[0]);
    }

    public double invokeDouble(Object o, String methodName, Object[] args) {
        Object result = this.invoke(o, methodName, args);
        Class<?> c = o.getClass();
        if (result == null) {
            String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned null, expected a double";
            throw new IllegalArgumentException(s);
        }
        if (result instanceof Double) {
            return (Double)result;
        }
        String s = "Method \"" + methodName + "\" in class \"" + c.getName() + "\" returned a \"" + result.getClass().getName() + "\" expected a double";
        throw new IllegalArgumentException(s);
    }

    public synchronized void bounce() {
        if (!this.available) {
            String s = "VM not available: " + this;
            throw new RMIException(this, this.getClass().getName(), "bounceVM", new IllegalStateException(s));
        }
        this.available = false;
        try {
            BounceResult result = DUnitEnv.get().bounce(this.pid);
            this.pid = result.getNewPid();
            this.client = result.getNewClient();
            this.available = true;
        }
        catch (UnsupportedOperationException e) {
            this.available = true;
            throw e;
        }
        catch (RemoteException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            RMIException rmie = new RMIException(this, this.getClass().getName(), "bounceVM", e, sw.toString());
            throw rmie;
        }
    }

    public String toString() {
        return "VM " + this.getPid() + " running on " + this.getHost();
    }

    public static int getCurrentVMNum() {
        return DUnitEnv.get().getVMID();
    }

    public File getWorkingDirectory() {
        return DUnitEnv.get().getWorkingDirectory(this.getPid());
    }
}

