/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit;

import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import io.snappydata.test.dunit.DUnitEnv;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RepeatableRunnable;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.dunit.standalone.DUnitBB;
import io.snappydata.test.dunit.standalone.DUnitLauncher;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.junit.internal.MethodSorter;

public abstract class DistributedTestBase
extends TestCase
implements Serializable {
    private static volatile transient Logger globalLogger = DistributedTestBase.newGlobalLogger();
    private static volatile transient Logger logger = DistributedTestBase.newLogWriter();
    private static final LinkedHashSet<String> testHistory = new LinkedHashSet();
    private static Properties lastSystemProperties;
    public static volatile String testName;
    private static ConcurrentLinkedQueue<ExpectedException> expectedExceptions;
    private static final DecimalFormat format;
    public static boolean reconnect;
    public static final boolean logPerTest;
    public static final String lineSeparator;
    public static InternalDistributedSystem system;
    private static Class lastSystemCreatedInTest;
    protected static boolean beforeClassDone;
    protected static String lastTest;
    private static final boolean USE_JITTER = true;
    private static final Random jitter;

    public static void sleepForMs(int msToSleep) {
        if (msToSleep != 0) {
            try {
                Thread.sleep(msToSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter sw = new StringWriter();
        aThrowable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String getHostAddress(InetAddress addr) {
        int idx;
        String address = addr.getHostAddress();
        if ((addr instanceof Inet4Address || !addr.isLinkLocalAddress() && !addr.isLoopbackAddress()) && (idx = address.indexOf(37)) >= 0) {
            address = address.substring(0, idx);
        }
        return address;
    }

    public static final Properties getAllDistributedSystemProperties(Properties props) {
        Properties p = DUnitEnv.get().getDistributedSystemProperties();
        if (!p.contains("disable-auto-reconnect")) {
            p.put("disable-auto-reconnect", "true");
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            p.put(key, value);
        }
        return p;
    }

    public InternalDistributedSystem getSystem() {
        return this.getSystem(new Properties());
    }

    public InternalDistributedSystem getSystem(Properties props) {
        block5: {
            boolean needNewSystem;
            block7: {
                block6: {
                    block4: {
                        if (system == null) {
                            system = InternalDistributedSystem.getAnyInstance();
                        }
                        if (system != null && system.isConnected()) break block4;
                        Properties p = DistributedTestBase.getAllDistributedSystemProperties(props);
                        lastSystemCreatedInTest = this.getTestClass();
                        if (logPerTest) {
                            String testMethod = DistributedTestBase.getTestName();
                            String testName = lastSystemCreatedInTest.getName() + '-' + testMethod;
                            String oldLogFile = p.getProperty("log-file");
                            p.put("log-file", oldLogFile.replace("system.log", testName + ".log"));
                            String oldStatFile = p.getProperty("statistic-archive-file");
                            p.put("statistic-archive-file", oldStatFile.replace("statArchive.gfs", testName + ".gfs"));
                        }
                        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
                        lastSystemProperties = p;
                        break block5;
                    }
                    needNewSystem = false;
                    if (this.getTestClass().equals(lastSystemCreatedInTest)) break block6;
                    Properties newProps = DistributedTestBase.getAllDistributedSystemProperties(props);
                    boolean bl = needNewSystem = !newProps.equals(lastSystemProperties);
                    if (!needNewSystem) break block7;
                    this.getLogWriter().info((Object)("Test class has changed and the new DS properties are not an exact match. Forcing DS disconnect. Old props = " + lastSystemProperties + "new props=" + newProps));
                    break block7;
                }
                Properties activeProps = system.getProperties();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value.equals(activeProps.getProperty(key))) continue;
                    needNewSystem = true;
                    this.getLogWriter().info((Object)("Forcing DS disconnect. For property " + key + " old value = " + activeProps.getProperty(key) + " new value = " + value));
                    break;
                }
            }
            if (needNewSystem) {
                this.getLogWriter().info((Object)"Disconnecting from current DS in order to make a new one");
                DistributedTestBase.disconnectFromDS();
                this.getSystem(props);
            }
        }
        return system;
    }

    public static void disconnectFromDS() {
        InternalDistributedSystem ds;
        testName = null;
        GemFireCacheImpl.testCacheXml = null;
        if (system != null) {
            system.disconnect();
            system = null;
        }
        while ((ds = InternalDistributedSystem.getConnectedInstance()) != null) {
            try {
                ds.disconnect();
            }
            catch (Exception exception) {}
        }
        AdminDistributedSystemImpl ads = AdminDistributedSystemImpl.getConnectedInstance();
        if (ads != null) {
            ads.disconnect();
        }
    }

    public static void invokeInEveryVM(SerializableRunnable work) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(work);
            }
        }
    }

    public static void invokeInLocator(SerializableRunnable work) {
        Host.getLocator().invoke(work);
    }

    public static Map invokeInEveryVM(SerializableCallable work) {
        HashMap<VM, Object> ret = new HashMap<VM, Object>();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                ret.put(vm, vm.invoke(work));
            }
        }
        return ret;
    }

    public static void invokeInEveryVM(Class c, String method) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(c, method);
            }
        }
    }

    public static void invokeInEveryVM(Class c, String method, Object[] methodArgs) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(c, method, methodArgs);
            }
        }
    }

    public static void invokeInVM(VM vm, final String className, final String method, final Object[] methodArgs) {
        SerializableRunnable run = new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    Class<?> c = Class.forName(className);
                    DistributedTestBase testBase = (DistributedTestBase)c.getConstructor(String.class).newInstance("tmp");
                    for (Method m : c.getMethods()) {
                        if (!m.getName().equals(method)) continue;
                        m.invoke((Object)testBase, methodArgs);
                        return;
                    }
                    throw new TestException("No method with name " + method + " found in class " + className);
                }
                catch (Exception e) {
                    String msg = "Failed in " + method + " on ";
                    DistributedTestBase.getGlobalLogger().error((Object)msg, (Throwable)e);
                    throw new TestException(msg, e);
                }
            }
        };
        vm.invoke(run);
    }

    public void invokeInVM(VM vm, String method, Object ... methodArgs) {
        DistributedTestBase.invokeInVM(vm, this.getClass().getName(), method, methodArgs);
    }

    protected long getRepeatTimeoutMs() {
        return 0L;
    }

    protected void invokeRepeatingIfNecessary(VM vm, RepeatableRunnable task) {
        vm.invokeRepeatingIfNecessary(task, this.getRepeatTimeoutMs());
    }

    protected void invokeInEveryVMRepeatingIfNecessary(RepeatableRunnable work) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invokeRepeatingIfNecessary(work, this.getRepeatTimeoutMs());
            }
        }
    }

    protected static int getVMCount() {
        int count = 0;
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            count += host.getVMCount();
        }
        return count;
    }

    public static void dumpStack() {
        DistributedTestBase.dumpStack(DistributedTestBase.getGlobalLogger());
    }

    public static void dumpStack(Logger logger) {
        StringBuilder sb = new StringBuilder();
        sb.append("STACK DUMP:").append(lineSeparator).append(lineSeparator);
        DistributedTestBase.generateThreadDump(sb);
        logger.info((Object)sb.toString());
    }

    public static void dumpStack(VM vm) {
        vm.invoke(DistributedTestBase.class, "dumpStack");
    }

    public static void dumpStack(Host host) {
        for (int v = 0; v < host.getVMCount(); ++v) {
            host.getVM(v).invoke(DistributedTestBase.class, "dumpStack");
        }
    }

    public static void dumpAllStacks() {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            DistributedTestBase.dumpStack(Host.getHost(h));
        }
    }

    public static void generateThreadDump(StringBuilder msg) {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo tInfo : mbean.dumpAllThreads(true, true)) {
            msg.append('\"').append(tInfo.getThreadName()).append('\"').append(" Id=").append(tInfo.getThreadId()).append(' ').append((Object)tInfo.getThreadState());
            if (tInfo.getLockName() != null) {
                msg.append(" on ").append(tInfo.getLockName());
            }
            if (tInfo.getLockOwnerName() != null) {
                msg.append(" owned by \"").append(tInfo.getLockOwnerName()).append("\" Id=").append(tInfo.getLockOwnerId());
            }
            if (tInfo.isSuspended()) {
                msg.append(" (suspended)");
            }
            if (tInfo.isInNative()) {
                msg.append(" (in native)");
            }
            msg.append(lineSeparator);
            StackTraceElement[] stackTrace = tInfo.getStackTrace();
            for (int index = 0; index < stackTrace.length; ++index) {
                msg.append("\tat ").append(stackTrace[index].toString()).append(lineSeparator);
                if (index == 0 && tInfo.getLockInfo() != null) {
                    Thread.State ts = tInfo.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            msg.append("\t-  blocked on ").append(tInfo.getLockInfo()).append(lineSeparator);
                            break;
                        }
                        case WAITING: {
                            msg.append("\t-  waiting on ").append(tInfo.getLockInfo()).append(lineSeparator);
                            break;
                        }
                        case TIMED_WAITING: {
                            msg.append("\t-  waiting on ").append(tInfo.getLockInfo()).append(lineSeparator);
                            break;
                        }
                    }
                }
                for (LockInfo lockInfo : tInfo.getLockedMonitors()) {
                    if (((MonitorInfo)lockInfo).getLockedStackDepth() != index) continue;
                    msg.append("\t-  locked ").append(lockInfo).append(lineSeparator);
                }
            }
            LockInfo[] locks = tInfo.getLockedSynchronizers();
            if (locks.length > 0) {
                msg.append(lineSeparator).append("\tNumber of locked synchronizers = ").append(locks.length).append(lineSeparator);
                for (LockInfo lockInfo : locks) {
                    msg.append("\t- ").append(lockInfo).append(lineSeparator);
                }
            }
            msg.append(lineSeparator);
        }
    }

    public static String noteTiming(long operations, String operationUnit, long beginTime, long endTime, String timeUnit) {
        long delta = endTime - beginTime;
        StringBuffer sb = new StringBuffer();
        sb.append("  Performed ");
        sb.append(operations);
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" in ");
        sb.append(delta);
        sb.append(" ");
        sb.append(timeUnit);
        sb.append("\n");
        double ratio = (double)operations / (double)delta;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" per ");
        sb.append(timeUnit);
        sb.append("\n");
        ratio = (double)delta / (double)operations;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(timeUnit);
        sb.append(" per ");
        sb.append(operationUnit);
        sb.append("\n");
        return sb.toString();
    }

    public DistributedTestBase(String name) {
        super(name);
        DUnitLauncher.launchIfNeeded();
    }

    protected Class getTestClass() {
        Class<?> clazz = this.getClass();
        while (clazz.getDeclaringClass() != null) {
            clazz = clazz.getDeclaringClass();
        }
        return clazz;
    }

    private static Level getLevel(String gemfireLogLevel) {
        switch (gemfireLogLevel) {
            case "config": 
            case "info": {
                return Level.INFO;
            }
            case "fine": {
                return Level.DEBUG;
            }
            case "finer": 
            case "finest": {
                return Level.TRACE;
            }
            case "warning": {
                return Level.WARN;
            }
            case "error": {
                return Level.ERROR;
            }
            case "severe": {
                return Level.FATAL;
            }
            case "all": {
                return Level.ALL;
            }
            case "none": {
                return Level.OFF;
            }
        }
        return Level.INFO;
    }

    private static Logger newGlobalLogger() {
        Logger logger = LogManager.getLogger((String)"HOST");
        logger.setLevel(DistributedTestBase.getLevel(DUnitLauncher.LOG_LEVEL));
        return logger;
    }

    public static Logger getGlobalLogger() {
        Logger logger = globalLogger;
        if (logger != null) {
            return logger;
        }
        globalLogger = DistributedTestBase.newGlobalLogger();
        return globalLogger;
    }

    private static synchronized Logger newLogWriter() {
        Logger logger = LogManager.getLogger((String)"DUnitTest");
        try {
            Properties props = new Properties();
            try (InputStream in = DistributedTestBase.class.getResourceAsStream("/test-log4j.properties");){
                props.load(in);
            }
            new PropertyConfigurator().doConfigure(props, logger.getLoggerRepository());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.setLevel(DistributedTestBase.getLevel(DUnitLauncher.LOG_LEVEL));
        return logger;
    }

    public final Logger getLogWriter() {
        return DistributedTestBase.getStaticLogWriter();
    }

    public static Logger getStaticLogWriter() {
        Logger log = logger;
        if (log != null) {
            return log;
        }
        logger = DistributedTestBase.newLogWriter();
        return logger;
    }

    public String getLogLevel() {
        return DUnitLauncher.LOG_LEVEL;
    }

    private String getDefaultDiskStoreName() {
        String vmid = System.getProperty("vmid");
        return "DiskStore-" + vmid + "-" + this.getTestClass().getCanonicalName() + "." + DistributedTestBase.getTestName();
    }

    public void beforeClass() throws Exception {
    }

    public void afterClass() throws Exception {
    }

    public void setUp() throws Exception {
        InitializeRun.setUp();
        this.logTestHistory();
        testName = this.getName();
        Class<?> thisClass = this.getClass();
        Logger logger = this.getLogWriter();
        if (!beforeClassDone) {
            lastTest = null;
            logger.info((Object)("[setup] Invoking beforeClass for " + thisClass.getSimpleName() + "." + testName + "\n"));
            this.beforeClass();
            beforeClassDone = true;
            System.out.println("\n[setup] Invoked beforeClass for " + thisClass.getSimpleName() + "." + testName + "\n");
        }
        if (lastTest == null) {
            Class<?> scanClass = thisClass;
            while (Test.class.isAssignableFrom(scanClass)) {
                for (Method m : MethodSorter.getDeclaredMethods(scanClass)) {
                    String methodName = m.getName();
                    if (!methodName.startsWith("test") || m.getParameterTypes().length != 0 || !m.getReturnType().equals(Void.TYPE)) continue;
                    lastTest = methodName;
                }
                scanClass = scanClass.getSuperclass();
            }
            if (lastTest == null) {
                DistributedTestBase.fail((String)("Could not find any last test in " + thisClass.getName()));
            } else {
                logger.info((Object)("[setup] Last test for " + thisClass.getName() + ": " + lastTest));
            }
        }
        if (testName != null) {
            String baseDefaultDiskStoreName = this.getTestClass().getCanonicalName() + "." + DistributedTestBase.getTestName();
            for (int h = 0; h < Host.getHostCount(); ++h) {
                Host host = Host.getHost(h);
                for (int v = 0; v < host.getVMCount(); ++v) {
                    VM vm = host.getVM(v);
                    String vmDefaultDiskStoreName = "DiskStore-" + h + "-" + v + "-" + baseDefaultDiskStoreName;
                    this.invokeInVM(vm, "perVMSetUp", testName, vmDefaultDiskStoreName);
                }
            }
        }
        System.out.println("\n\n[setup] START TEST " + thisClass.getSimpleName() + "." + testName + "\n\n");
    }

    protected void logTestHistory() {
        String classname = this.getClass().getSimpleName();
        testHistory.add(classname);
        System.out.println("Previously run tests: " + testHistory);
    }

    public void perVMSetUp(String name, String defaultDiskStoreName) {
        DistributedTestBase.setTestName(name);
    }

    public static void setTestName(String name) {
        testName = name;
    }

    public static String getTestName() {
        return testName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tearDown() throws Exception {
        try {
            this.tearDown2();
            for (int h = 0; h < Host.getHostCount(); ++h) {
                Host host = Host.getHost(h);
                for (int v = 0; v < host.getVMCount(); ++v) {
                    VM vm = host.getVM(v);
                    this.invokeInVM(vm, "perVMTearDown", testName);
                }
            }
        }
        finally {
            boolean isLastTest = this.getName().equals(lastTest);
            try {
                this.tearDownAfter();
                if (isLastTest) {
                    System.out.println("\n[tearDown] Invoking afterClass post " + this.getClass().getSimpleName() + "." + testName + "\n");
                    this.afterClass();
                    System.out.println("\n[tearDown] Invoked afterClass post " + this.getClass().getSimpleName() + "." + testName + "\n");
                }
            }
            finally {
                if (isLastTest) {
                    beforeClassDone = false;
                    lastTest = null;
                }
            }
        }
    }

    public void perVMTearDown(String name) {
        DistributedTestBase.setTestName(null);
    }

    public void tearDown2() throws Exception {
    }

    protected void tearDownAfter() throws Exception {
    }

    private String getShortClassName() {
        String result = this.getClass().getName();
        int idx = result.lastIndexOf(46);
        if (idx != -1) {
            result = result.substring(idx + 1);
        }
        return result;
    }

    public static String getServerHostName(Host host) {
        return System.getProperty("gemfire.server-bind-address") != null ? System.getProperty("gemfire.server-bind-address") : host.getHostName();
    }

    public static String getIPLiteral() {
        return "localhost";
    }

    public static int getDUnitLocatorPort() {
        return DUnitEnv.get().getLocatorPort();
    }

    public String getUniqueName() {
        return this.getShortClassName() + "_" + this.getName();
    }

    public static void fail(String message, Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.print(message);
        pw.print(": ");
        ex.printStackTrace(pw);
        DistributedTestBase.fail((String)sw.toString());
    }

    protected void pause() {
        DistributedTestBase.pause(250);
    }

    public static final void staticPause(int ms) {
        long target = System.currentTimeMillis() + (long)ms;
        try {
            long msLeft;
            while ((msLeft = target - System.currentTimeMillis()) > 0L) {
                Thread.sleep(msLeft);
            }
        }
        catch (InterruptedException e) {
            DistributedTestBase.fail("interrupted", e);
        }
    }

    public static final void pause(int ms) {
        if (ms > 50) {
            DistributedTestBase.getGlobalLogger().info((Object)("Pausing for " + ms + " ms..."));
        }
        long target = System.currentTimeMillis() + (long)ms;
        try {
            long msLeft;
            while ((msLeft = target - System.currentTimeMillis()) > 0L) {
                Thread.sleep(msLeft);
            }
        }
        catch (InterruptedException e) {
            DistributedTestBase.fail("interrupted", e);
        }
    }

    private static int jitterInterval(long ms) {
        int minLegal = 50;
        int maxLegal = 5000;
        if (ms <= 50L) {
            return (int)ms;
        }
        int maxReturn = 5000;
        if (ms < 5000L) {
            maxReturn = (int)ms;
        }
        return 50 + jitter.nextInt(maxReturn - 50 + 1);
    }

    public static void waitForCriterion(WaitCriterion ev, long ms, long interval, boolean throwOnTimeout) {
        long waitThisTime = DistributedTestBase.jitterInterval(interval);
        long tilt = System.currentTimeMillis() + ms;
        while (!ev.done()) {
            WaitCriterion2 ev2;
            if (ev instanceof WaitCriterion2 && (ev2 = (WaitCriterion2)ev).stopWaiting()) {
                if (throwOnTimeout) {
                    DistributedTestBase.fail((String)("stopWaiting returned true: " + ev.description()));
                }
                return;
            }
            long timeLeft = tilt - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                if (!throwOnTimeout) {
                    return;
                }
                DistributedTestBase.fail((String)("Event never occurred after " + ms + " ms: " + ev.description()));
            }
            if (waitThisTime > timeLeft) {
                waitThisTime = timeLeft;
            }
            Thread.yield();
            try {
                Thread.sleep(waitThisTime);
                continue;
            }
            catch (InterruptedException e) {
                DistributedTestBase.fail((String)"interrupted");
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitMutex(WaitCriterion ev, Object mutex, long ms, long interval, boolean throwOnTimeout) {
        long tilt = System.currentTimeMillis() + ms;
        long waitThisTime = DistributedTestBase.jitterInterval(interval);
        Object object = mutex;
        synchronized (object) {
            while (!ev.done()) {
                long timeLeft = tilt - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    if (!throwOnTimeout) {
                        return;
                    }
                    DistributedTestBase.fail((String)("Event never occurred after " + ms + " ms: " + ev.description()));
                }
                if (waitThisTime > timeLeft) {
                    waitThisTime = timeLeft;
                }
                try {
                    mutex.wait(waitThisTime);
                }
                catch (InterruptedException e) {
                    DistributedTestBase.fail((String)"interrupted");
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static void join(Thread t, long ms, Logger logger) {
        long elapsedMs;
        long tilt = System.currentTimeMillis() + ms;
        long incrementalWait = DistributedTestBase.jitterInterval(ms);
        long start = System.currentTimeMillis();
        while (t.isAlive()) {
            try {
                t.join(incrementalWait);
            }
            catch (InterruptedException e) {
                DistributedTestBase.fail((String)"interrupted");
            }
            if (System.currentTimeMillis() < tilt) continue;
        }
        if (logger == null) {
            logger = DistributedTestBase.getGlobalLogger();
        }
        if (t.isAlive()) {
            logger.info((Object)"HUNG THREAD");
            DistributedTestBase.dumpStackTrace(t, t.getStackTrace(), logger);
            DistributedTestBase.dumpStack(logger);
            t.interrupt();
            DistributedTestBase.fail((String)("Thread did not terminate after " + ms + " ms: " + t));
        }
        if ((elapsedMs = System.currentTimeMillis() - start) > 0L) {
            String msg = "Thread " + t + " took " + elapsedMs + " ms to exit.";
            logger.info((Object)msg);
        }
    }

    public static void dumpStackTrace(Thread t, StackTraceElement[] stack, Logger logger) {
        StringBuilder msg = new StringBuilder();
        msg.append("Thread=<").append(t).append("> stackDump:\n");
        for (int i = 0; i < stack.length; ++i) {
            msg.append("\t").append(stack[i]).append("\n");
        }
        logger.info((Object)msg.toString());
    }

    public static void staticLogString(String msg) {
        DistributedTestBase.getGlobalLogger().info((Object)msg);
    }

    public static ExpectedException addExpectedException(String exception) {
        return DistributedTestBase.addExpectedException(exception, null);
    }

    public static ExpectedException addExpectedException(String exception, VM v) {
        ExpectedException ret = v != null ? new ExpectedException(exception, v) : new ExpectedException(exception);
        String add = ret.getAddString();
        if (v != null) {
            v.invoke(DistributedTestBase.class, "staticLogString", new Object[]{add});
        } else {
            DistributedTestBase.invokeInEveryVM(DistributedTestBase.class, "staticLogString", new Object[]{add});
        }
        DistributedTestBase.getGlobalLogger().info((Object)add);
        expectedExceptions.add(ret);
        return ret;
    }

    public void deleteLocatorStateFile(int ... ports) {
        for (int i = 0; i < ports.length; ++i) {
            File stateFile = new File("locator" + ports[i] + "state.dat");
            if (!stateFile.exists()) continue;
            stateFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incBBFlag(String name) {
        DUnitBB bb = DUnitBB.getBB();
        bb.acquireSharedLock();
        try {
            int currentVal = 0;
            Object result = bb.get(name);
            if (result != null && result instanceof Integer) {
                currentVal = (Integer)result;
            }
            bb.put(name, ++currentVal);
        }
        finally {
            bb.releaseSharedLock();
        }
    }

    public static void clearBBFlag(String name) {
        DUnitBB bb = DUnitBB.getBB();
        bb.acquireSharedLock();
        try {
            bb.remove(name);
        }
        finally {
            bb.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkBBFlag(String name, int expectedValue) throws CacheException {
        DUnitBB bb = DUnitBB.getBB();
        int gotValue = -1;
        bb.acquireSharedLock();
        try {
            Object result = bb.get(name);
            if (result != null && result instanceof Integer) {
                gotValue = (Integer)result;
            }
        }
        finally {
            bb.releaseSharedLock();
        }
        if (expectedValue != gotValue) {
            throw new TestException("Expected value " + expectedValue + " for flag [" + name + "] but got " + gotValue){};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBBFlag(String name, int expectedValue, long timeout) throws TimeoutException {
        DUnitBB bb = DUnitBB.getBB();
        int gotValue = -1;
        long endTime = System.currentTimeMillis() + timeout;
        while (gotValue != expectedValue) {
            if (timeout > 0L && System.currentTimeMillis() >= endTime) {
                throw new TestException("timed out waiting for BB key " + name + " for " + timeout + " millis");
            }
            bb.acquireSharedLock();
            try {
                Object result = bb.get(name);
                if (result == null || !(result instanceof Integer)) continue;
                gotValue = (Integer)result;
            }
            finally {
                bb.releaseSharedLock();
            }
        }
    }

    static {
        expectedExceptions = new ConcurrentLinkedQueue();
        format = new DecimalFormat("###.###");
        reconnect = false;
        logPerTest = Boolean.getBoolean("dunitLogPerTest");
        lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
        InitializeRun.setUp();
        jitter = new Random();
    }

    public static class ExpectedException
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String ex;
        final transient VM v;

        public ExpectedException(String exception) {
            this.ex = exception;
            this.v = null;
        }

        ExpectedException(String exception, VM vm) {
            this.ex = exception;
            this.v = vm;
        }

        public String getRemoveString() {
            return "<ExpectedException action=remove>" + this.ex + "</ExpectedException>";
        }

        public String getAddString() {
            return "<ExpectedException action=add>" + this.ex + "</ExpectedException>";
        }

        public void remove() {
            String s = this.getRemoveString();
            if (this.v != null) {
                this.v.invoke(DistributedTestBase.class, "staticLogString", new Object[]{s});
            } else {
                DistributedTestBase.invokeInEveryVM(DistributedTestBase.class, "staticLogString", new Object[]{s});
            }
            DistributedTestBase.getGlobalLogger().info((Object)s);
        }
    }

    public static interface WaitCriterion2
    extends WaitCriterion {
        public boolean stopWaiting();
    }

    public static interface WaitCriterion {
        public boolean done();

        public String description();
    }

    public static final class InitializeRun {
        public static void setUp() {
            System.setProperty("gemfire.DISALLOW_RESERVE_SPACE", "true");
        }

        public static String getBaseDir() {
            return "vm_" + NativeCalls.getInstance().getProcessId();
        }

        static {
            if (System.getProperty("gemfire.DUnitLauncher.VM_NUM") == null) {
                File baseDirFile = new File(InitializeRun.getBaseDir());
                baseDirFile.mkdirs();
                NativeCalls.getInstance().setCurrentWorkingDirectory(baseDirFile.getAbsolutePath());
            }
        }
    }
}

