/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit.standalone;

import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import io.snappydata.test.dunit.RemoteDUnitVMIF;
import io.snappydata.test.dunit.logging.log4j.ConfigLocator;
import io.snappydata.test.dunit.standalone.ChildVM;
import io.snappydata.test.dunit.standalone.DUnitLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ProcessManager {
    private int namingPort;
    private Map<Integer, ProcessHolder> processes = new HashMap<Integer, ProcessHolder>();
    private File log4jConfig;
    private int pendingVMs;
    private Registry registry;

    public ProcessManager(int namingPort, Registry registry) {
        this.namingPort = namingPort;
        this.registry = registry;
    }

    public void launchVMs() throws IOException, NotBoundException {
        this.log4jConfig = ConfigLocator.findConfigInWorkingDirectory();
    }

    public synchronized void launchVM(int vmNum) throws IOException {
        if (this.processes.containsKey(vmNum)) {
            throw new IllegalStateException("VM " + vmNum + " is already running.");
        }
        String[] cmd = this.buildJavaCommand(vmNum, this.namingPort);
        System.out.println("Executing " + Arrays.asList(cmd));
        File workingDir = this.getVMDir(vmNum, true);
        try {
            FileUtil.delete((File)workingDir);
        }
        catch (IOException e) {
            System.err.println("Unable to delete " + workingDir + ". Currently contains " + Arrays.asList(workingDir.list()));
        }
        workingDir.mkdirs();
        if (this.log4jConfig != null) {
            FileUtils.copyFileToDirectory((File)this.log4jConfig, (File)workingDir);
        }
        Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
        ++this.pendingVMs;
        ProcessHolder holder = new ProcessHolder(process, workingDir.getAbsoluteFile());
        this.processes.put(vmNum, holder);
        this.linkStreams(vmNum, holder, process.getErrorStream(), System.err);
        this.linkStreams(vmNum, holder, process.getInputStream(), System.out);
    }

    public File getVMDir(int vmNum, boolean launch) {
        if (launch) {
            return new File("dunit", "vm" + vmNum + '_' + NativeCalls.getInstance().getProcessId());
        }
        ProcessHolder holder = this.processes.get(vmNum);
        if (holder != null) {
            return holder.getWorkingDir();
        }
        throw new IllegalArgumentException("No VM " + vmNum + " found.");
    }

    public synchronized void killVMs() {
        for (ProcessHolder process : this.processes.values()) {
            if (process == null) continue;
            process.kill();
        }
    }

    public synchronized void bounce(int vmNum) {
        if (!this.processes.containsKey(vmNum)) {
            throw new IllegalStateException("No such process " + vmNum);
        }
        try {
            ProcessHolder holder = this.processes.remove(vmNum);
            holder.kill();
            holder.getProcess().waitFor();
            this.launchVM(vmNum);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to restart VM " + vmNum, e);
        }
    }

    private void linkStreams(final int vmNum, final ProcessHolder holder, final InputStream in, final PrintStream out) {
        Thread ioTransport = new Thread(){

            @Override
            public void run() {
                block3: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String vmName = vmNum == -2 ? "[locator]" : "[vm_" + vmNum + "]";
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            out.print(vmName);
                            out.println(line);
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e) {
                        if (holder.isKilled()) break block3;
                        out.println("Error transporting IO from child process");
                        e.printStackTrace(out);
                    }
                }
            }
        };
        ioTransport.setDaemon(true);
        ioTransport.start();
    }

    private String[] buildJavaCommand(int vmNum, int namingPort) {
        String cmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classPath = System.getProperty("java.class.path");
        String agent = this.getAgentString();
        return new String[]{cmd, "-classpath", classPath, "-Dgemfire.DUnitLauncher.RMI_PORT=" + namingPort, "-Dgemfire.DUnitLauncher.VM_NUM=" + vmNum, "-DWORKSPACE_DIR=" + new File(".").getAbsolutePath(), "-DlogLevel=" + DUnitLauncher.LOG_LEVEL, "-Dgemfire.log-level=" + DUnitLauncher.LOG_LEVEL, "-DsecurityLogLevel=" + DUnitLauncher.SECURITY_LOG_LEVEL, "-Dgemfire.security-log-level=" + DUnitLauncher.SECURITY_LOG_LEVEL, "-Djava.library.path=" + System.getProperty("java.library.path"), "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n", "-XX:+HeapDumpOnOutOfMemoryError", "-Xmx1g", "-Xms1g", "-XX:+UseParNewGC", "-XX:+UseConcMarkSweepGC", "-XX:CMSInitiatingOccupancyFraction=50", "-XX:+CMSClassUnloadingEnabled", "-Dgemfire.DEFAULT_MAX_OPLOG_SIZE=10", "-Dgemfire.disallowMcastDefaults=true", "-Djava.net.preferIPv4Stack=true", "-Dsun.rmi.dgc.client.gcInterval=600000 ", "-Dsun.rmi.dgc.server.gcInterval=600000", "-Dsun.rmi.transport.tcp.handshakeTimeout=3600000", "-ea", agent, ChildVM.class.getName()};
    }

    private String getAgentString() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            for (String arg : runtimeBean.getInputArguments()) {
                if (!arg.contains("-javaagent:")) continue;
                arg = arg.replace("-javaagent:..", "-javaagent:" + System.getProperty("user.dir") + File.separator + "..");
                arg = arg.replace("destfile=..", "destfile=" + System.getProperty("user.dir") + File.separator + "..");
                return arg;
            }
        }
        return "-DdummyArg=true";
    }

    synchronized void signalVMReady() {
        --this.pendingVMs;
        this.notifyAll();
    }

    public synchronized boolean waitForVMs(long timeout) throws InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        while (this.pendingVMs > 0) {
            long remaining = end - System.currentTimeMillis();
            if (remaining <= 0L) {
                return false;
            }
            this.wait(remaining);
        }
        return true;
    }

    public RemoteDUnitVMIF getStub(int i) throws AccessException, RemoteException, NotBoundException, InterruptedException {
        this.waitForVMs(30000L);
        return (RemoteDUnitVMIF)this.registry.lookup("vm" + i);
    }

    private static class ProcessHolder {
        private final Process process;
        private final File workingDir;
        private volatile boolean killed = false;

        public ProcessHolder(Process process, File workingDir) {
            this.process = process;
            this.workingDir = workingDir;
        }

        public void kill() {
            this.killed = true;
            this.process.destroy();
        }

        public Process getProcess() {
            return this.process;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public boolean isKilled() {
            return this.killed;
        }
    }
}

