/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit;

import io.snappydata.test.dunit.RemoteDUnitVMIF;
import io.snappydata.test.dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Host
implements Serializable {
    protected static List hosts = new ArrayList();
    private static VM locator;
    protected static int NO_REGISTRY;
    private String hostName;
    private List vms;
    private List systems;
    private HashMap systemNames;
    public static final String BASE_LOGGER_NAME = "HOST";

    public static int getHostCount() {
        return hosts.size();
    }

    protected static void addHost(Host host) {
        hosts.add(host);
    }

    public static Host getHost(int n) {
        int size = hosts.size();
        if (n >= size) {
            String s = "Cannot request host " + n + ".  There are only " + size + " hosts.";
            throw new IllegalArgumentException(s);
        }
        return (Host)hosts.get(n);
    }

    protected Host(String hostName) {
        if (hostName == null) {
            String s = "Cannot create a Host with a null name";
            throw new NullPointerException(s);
        }
        this.hostName = hostName;
        this.vms = new ArrayList();
        this.systems = new ArrayList();
        this.systemNames = new HashMap();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getVMCount() {
        return this.vms.size();
    }

    public VM getVM(int n) {
        int size = this.vms.size();
        if (n >= size) {
            String s = "Cannot request VM " + n + ".  There are only " + size + " VMs on " + this;
            throw new IllegalArgumentException(s);
        }
        return (VM)this.vms.get(n);
    }

    protected void addVM(int pid, RemoteDUnitVMIF client) {
        VM vm = new VM(this, pid, client);
        this.vms.add(vm);
    }

    public static VM getLocator() {
        return locator;
    }

    private static void setLocator(VM l) {
        locator = l;
    }

    protected void addLocator(int pid, RemoteDUnitVMIF client) {
        Host.setLocator(new VM(this, pid, client));
    }

    public int getSystemCount() {
        return this.systems.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Host ");
        sb.append(this.getHostName());
        sb.append(" with ");
        sb.append(this.getVMCount());
        sb.append(" VMs");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Host) {
            return ((Host)o).getHostName().equals(this.getHostName());
        }
        return false;
    }

    public int hashCode() {
        return this.getHostName().hashCode();
    }

    static {
        NO_REGISTRY = -1;
    }
}

