/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.memscale;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.offheap.MemoryBlock;
import com.gemstone.gemfire.internal.offheap.MemoryInspector;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.memscale.OffHeapChunkInfo;
import io.snappydata.test.memscale.OffHeapHelperVersionHelper;
import io.snappydata.test.util.AEQHelper;
import io.snappydata.test.util.TestException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class OffHeapHelper {
    private static final int _totalNumberOffHeapObjects = 0;
    private static final int _numberInlineValues = 1;
    private static final int _numRefCountProblems = 2;
    private static final int _lobCount = 3;
    private static final int _totalNumberOnHeapObjects = 4;
    protected static final Logger logger = LogManager.getLogger(OffHeapHelper.class);

    public static void verifyOffHeapMemoryConsistency(boolean checkRefCounts) {
        if (!OffHeapHelper.isOffHeapMemoryConfigured()) {
            logger.info((Object)"No off-heap memory configured, skipping off-heap memory consistency checks");
            return;
        }
        Set<Region<?, ?>> allRegions = OffHeapHelper.getAllRegions();
        if (allRegions == null) {
            allRegions = new HashSet();
        }
        long beginObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        logger.info((Object)("Verifying off-heap memory consistency for " + allRegions.size() + " regions " + (checkRefCounts ? "including refCounts " : "NOT including refCounts")));
        int MAX_ORPHANS_TO_REPORT = 20;
        int MAX_REF_COUNT_PROBLEMS_TO_REPORT = 20;
        StringBuilder err = new StringBuilder();
        StringBuilder refCountErrStr = new StringBuilder();
        long[] statNumbers = new long[5];
        ArrayList<OffHeapChunkInfo> chunkList = new ArrayList<OffHeapChunkInfo>();
        ArrayList<SimpleMemoryAllocatorImpl.Chunk> lobChunkList = new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
        for (Region<?, ?> aRegion : allRegions) {
            String regionName = aRegion.getFullPath();
            logger.info((Object)("Verifying off-heap memory for " + regionName + ", enableOffHeapMemory for this region is " + aRegion.getAttributes().getEnableOffHeapMemory()));
            PartitionedRegion aPR = null;
            if (aRegion.getAttributes().getDataPolicy().withPartitioning()) {
                aPR = (PartitionedRegion)aRegion;
            }
            HashSet<Object> offHeapKeys = new HashSet<Object>();
            HashSet<Object> onHeapKeys = new HashSet<Object>();
            HashSet<String> onHeapValueClasses = new HashSet<String>();
            if (aPR == null) {
                OffHeapHelper.analyzeLocalRegion((LocalRegion)aRegion, offHeapKeys, onHeapKeys, onHeapValueClasses, statNumbers, chunkList, lobChunkList, checkRefCounts, refCountErrStr, err, 20);
                continue;
            }
            PartitionedRegionDataStore prs = aPR.getDataStore();
            if (prs == null) continue;
            for (BucketRegion br : prs.getAllLocalBucketRegions()) {
                if (br == null) continue;
                logger.info((Object)("Verifying bucket " + br.getFullPath()));
                OffHeapHelper.analyzeLocalRegion((LocalRegion)br, offHeapKeys, onHeapKeys, onHeapValueClasses, statNumbers, chunkList, lobChunkList, checkRefCounts, refCountErrStr, err, 20);
            }
        }
        long numberInlineValues = statNumbers[1];
        long numRefCountProblems = statNumbers[2];
        long lobCount = statNumbers[3];
        long totalNumberOnHeapObjects = statNumbers[4];
        long totalNumberOffHeapObjects = statNumbers[0] + lobCount;
        if (refCountErrStr.length() > 0) {
            err.append((CharSequence)refCountErrStr);
            if (numRefCountProblems > 20L) {
                err.append("...<").append(numRefCountProblems - 20L).append(" more refCount problems>...\n");
            }
        }
        int objects = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        long numUnreachable = 0L;
        if ((long)objects != totalNumberOffHeapObjects) {
            err.append("Total number of off-heap objects reachable via regions is ").append(totalNumberOffHeapObjects).append(lobCount == 0L ? "" : " (including " + lobCount + " SqlFire Lobs)").append(", but the number of objects stored off-heap according to stats is ").append(objects).append(" (difference of ").append(Math.abs((long)objects - totalNumberOffHeapObjects)).append(")\n");
            if ((long)objects > totalNumberOffHeapObjects) {
                numUnreachable = (long)objects - totalNumberOffHeapObjects;
            }
        }
        boolean foundOrphans = numUnreachable > 0L;
        SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
        if (offHeapStore != null) {
            List orphanedChunks = offHeapStore.getLostChunks();
            orphanedChunks.removeAll(lobChunkList);
            int numOrphanedChunks = orphanedChunks.size();
            if ((long)numOrphanedChunks != numUnreachable) {
                err.append("Number of off-heap values unreachable through regions is ").append(numUnreachable).append(" but number of orphaned chunks ").append("detected with internal free and live lists is ").append(numOrphanedChunks).append("\n");
            }
            if (numOrphanedChunks > 0) {
                foundOrphans = true;
                String aStr = numOrphanedChunks + " orphaned chunks detected with internal free and live lists";
                logger.info((Object)aStr);
                err.append(aStr).append("\n");
                for (int i = 0; i < orphanedChunks.size(); ++i) {
                    SimpleMemoryAllocatorImpl.Chunk aChunk = (SimpleMemoryAllocatorImpl.Chunk)orphanedChunks.get(i);
                    aStr = "orphaned @" + Long.toHexString(aChunk.getMemoryAddress()) + " rc=" + aChunk.getRefCount();
                    List info = SimpleMemoryAllocatorImpl.getRefCountInfo((long)aChunk.getMemoryAddress());
                    String logStr = info != null ? aStr + " history=" + info : aStr;
                    logger.info((Object)logStr);
                    if (i >= 20) continue;
                    err.append(aStr).append("\n");
                }
                if (orphanedChunks.size() > 20) {
                    err.append("...<").append(orphanedChunks.size() - 20).append(" more orphans>...\n");
                }
            }
        }
        if (foundOrphans) {
            OffHeapHelper.dumpOffHeapOrphans();
        }
        err.append(OffHeapHelper.verifyChunks(chunkList));
        if (err.length() > 0) {
            logger.info((Object)err.toString());
        }
        long totalVerified = totalNumberOffHeapObjects + totalNumberOnHeapObjects + numberInlineValues;
        logger.info((Object)("Verified a total of " + totalVerified + " objects in " + allRegions.size() + " regions including " + totalNumberOffHeapObjects + " off-heap objects, " + totalNumberOnHeapObjects + " on-heap objects, and " + numberInlineValues + " in-line values"));
        if (err.length() > 0) {
            logger.info((Object)err.toString());
            long finalObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
            if (beginObjectsStat != finalObjectsStat) {
                err.insert(0, "Off-heap memory was not stable during off-heap memory validation. Number of off-heap objects at the beginning of validation: " + beginObjectsStat + ", number of off-heap " + "objects at the end of validation: " + finalObjectsStat + "\n");
            }
            throw new TestException(err.toString());
        }
    }

    private static void analyzeLocalRegion(LocalRegion localReg, Set<Object> offHeapKeys, Set<Object> onHeapKeys, Set<String> onHeapValueClasses, long[] statNumbers, List<OffHeapChunkInfo> chunkList, List<SimpleMemoryAllocatorImpl.Chunk> lobChunkList, boolean checkRefCounts, StringBuilder refCountErrStr, StringBuilder errStr, int MAX_REF_COUNT_PROBLEMS_TO_REPORT) {
        String regionName = localReg.getFullPath();
        for (Object key : localReg.keySet()) {
            RegionEntry entry = localReg.getRegionEntry(key);
            if (entry == null) {
                throw new TestException("For key " + key + " in region " + regionName + ", LocalRegion.getRegionEntry(key) returned null");
            }
            Object value = entry._getValue();
            if (value instanceof SimpleMemoryAllocatorImpl.Chunk) {
                int refCount;
                offHeapKeys.add(key);
                statNumbers[0] = statNumbers[0] + 1L;
                SimpleMemoryAllocatorImpl.Chunk aChunk = (SimpleMemoryAllocatorImpl.Chunk)value;
                OffHeapChunkInfo info = new OffHeapChunkInfo(regionName, key, aChunk.getMemoryAddress(), aChunk.getSize());
                chunkList.add(info);
                OffHeapHelperVersionHelper.checkIsAllocated(aChunk);
                if (checkRefCounts && (refCount = aChunk.getRefCount()) != 1) {
                    statNumbers[2] = statNumbers[2] + 1L;
                    if (statNumbers[2] <= (long)MAX_REF_COUNT_PROBLEMS_TO_REPORT) {
                        refCountErrStr.append(localReg.getFullPath()).append(" key ").append(key).append(" has off-heap refCount ").append(refCount).append(" @").append(Long.toHexString(aChunk.getMemoryAddress())).append("\n");
                        if (SimpleMemoryAllocatorImpl.trackReferenceCounts()) {
                            List history = SimpleMemoryAllocatorImpl.getRefCountInfo((long)aChunk.getMemoryAddress());
                            if (history != null) {
                                String logStr = "extraRefs for @" + Long.toHexString(aChunk.getMemoryAddress()) + " rc=" + refCount + " history=" + history;
                                logger.info((Object)logStr);
                            } else {
                                logger.info((Object)("No history for @" + Long.toHexString(aChunk.getMemoryAddress())));
                            }
                        }
                    }
                }
                List<SimpleMemoryAllocatorImpl.Chunk> aList = OffHeapHelper.getSqlLobChunks(aChunk, regionName, key);
                for (SimpleMemoryAllocatorImpl.Chunk lobChunk : aList) {
                    info = new OffHeapChunkInfo(regionName, key, lobChunk.getMemoryAddress(), lobChunk.getSize());
                    chunkList.add(info);
                    int refCount2 = lobChunk.getRefCount();
                    if (refCount2 == 1) continue;
                    statNumbers[2] = statNumbers[2] + 1L;
                    if (statNumbers[2] > (long)MAX_REF_COUNT_PROBLEMS_TO_REPORT) continue;
                    refCountErrStr.append(localReg.getFullPath()).append(" key ").append(key).append(" lob at address ").append(lobChunk.getMemoryAddress()).append(" has off-heap refCount ").append(refCount2).append("\n");
                    List history = SimpleMemoryAllocatorImpl.getRefCountInfo((long)lobChunk.getMemoryAddress());
                    if (history == null) continue;
                    String logStr = "extraRefs for @" + Long.toHexString(lobChunk.getMemoryAddress()) + " rc=" + refCount2 + " history=" + history;
                    logger.info((Object)logStr);
                }
                lobChunkList.addAll(aList);
                statNumbers[3] = statNumbers[3] + (long)aList.size();
                continue;
            }
            if (value instanceof SimpleMemoryAllocatorImpl.DataAsAddress) {
                statNumbers[1] = statNumbers[1] + 1L;
                continue;
            }
            if (value == Token.INVALID || value == Token.LOCAL_INVALID || value == null) continue;
            onHeapKeys.add(key);
            onHeapValueClasses.add(value.getClass().getName());
        }
        statNumbers[4] = statNumbers[4] + (long)onHeapKeys.size();
        if (localReg.getAttributes().getEnableOffHeapMemory()) {
            if (onHeapKeys.size() > 0) {
                boolean isHDFS;
                Class<?> clazz = localReg.getClass();
                try {
                    Method isHDFSRegionMethod = clazz.getDeclaredMethod("isHDFSRegion", null);
                    isHDFSRegionMethod.setAccessible(true);
                    isHDFS = (Boolean)isHDFSRegionMethod.invoke((Object)localReg, new Object[0]);
                }
                catch (Throwable th) {
                    throw new RuntimeException("Could not determine if it is a HDFS region", th);
                }
                if (!isHDFS) {
                    errStr.append(localReg.getFullPath()).append(" has off-heap enabled, but the following ").append(onHeapKeys.size()).append(" keys had values not found in off-heap memory: ").append(onHeapKeys).append(", set of value classes for those keys: ").append(onHeapValueClasses).append("\n");
                }
            }
        } else if (offHeapKeys.size() > 0) {
            errStr.append(localReg.getFullPath()).append(" has off-heap disabled, but the following keys had values ").append(" found in off-heap memory: ").append(offHeapKeys).append("\n");
        }
    }

    private static List<SimpleMemoryAllocatorImpl.Chunk> getSqlLobChunks(SimpleMemoryAllocatorImpl.Chunk chunk, String regionName, Object key) {
        ArrayList<SimpleMemoryAllocatorImpl.Chunk> aList = new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
        if (chunk instanceof OffHeapRowWithLobs) {
            OffHeapRowWithLobs ohbs = (OffHeapRowWithLobs)chunk;
            int numLobs = ohbs.readNumLobsColumns(false);
            if (numLobs <= 0) {
                throw new TestException("For key " + key + " + in region " + regionName + " the off-heap memory byte source " + ohbs + " has lobs " + true + ", but the number of lobs is " + numLobs);
            }
            for (int i = 1; i <= numLobs; ++i) {
                Object byteSrc = ohbs.getGfxdByteSource(i);
                if (!(byteSrc instanceof SimpleMemoryAllocatorImpl.Chunk)) continue;
                SimpleMemoryAllocatorImpl.Chunk lobChunk = (SimpleMemoryAllocatorImpl.Chunk)byteSrc;
                aList.add(lobChunk);
            }
        }
        return aList;
    }

    public static void dumpOffHeapOrphans() {
        SimpleMemoryAllocatorImpl store = SimpleMemoryAllocatorImpl.getAllocator();
        if (store == null) {
            logger.info((Object)"Not dumping off-heap orphans, offHeapStore is null");
            return;
        }
        MemoryInspector inspector = store.getMemoryInspector();
        List orphans = inspector.getOrphans();
        for (MemoryBlock block : orphans) {
            logger.error((Object)("Orphaned MemoryBlock: " + block.toString()));
        }
    }

    public static synchronized void closeAllRegions() {
        OffHeapHelper.closeAllOffHeapRegions();
    }

    public static synchronized void closeAllOffHeapRegions() {
        GemFireCacheImpl theCache = GemFireCacheImpl.getInstance();
        if (theCache == null) {
            logger.info((Object)"The cache is null");
            return;
        }
        Set<Region<?, ?>> regionSet = OffHeapHelper.getAllRegions();
        if (regionSet != null && regionSet.size() > 0) {
            for (Region<?, ?> aRegion : regionSet) {
                if (aRegion.getAttributes().getEnableOffHeapMemory()) {
                    logger.info((Object)("Closing " + aRegion.getFullPath()));
                    try {
                        aRegion.close();
                        logger.info((Object)("Closed " + aRegion.getFullPath()));
                    }
                    catch (RegionDestroyedException e) {
                        logger.info((Object)(aRegion.getFullPath() + " was already destroyed"));
                    }
                    continue;
                }
                logger.info((Object)("Not closing " + aRegion.getFullPath() + " because off-heap memory is not enabled for this region"));
            }
            if (OffHeapHelper.isOffHeapMemoryConfigured()) {
                long numObjectsInOffHeapMemory = OffHeapHelper.getOffHeapMemoryStats().getObjects();
                for (int retryCount = 0; numObjectsInOffHeapMemory != 0L && retryCount < 31; ++retryCount) {
                    logger.info((Object)("Waiting for off-heap memory to empty, current number of objects is " + numObjectsInOffHeapMemory));
                    DistributedTestBase.sleepForMs(2000);
                    numObjectsInOffHeapMemory = OffHeapHelper.getOffHeapMemoryStats().getObjects();
                }
                if (numObjectsInOffHeapMemory > 0L) {
                    logger.error((Object)("Number of objects in off-heap memory: " + numObjectsInOffHeapMemory));
                } else {
                    logger.info((Object)("Number of objects in off-heap memory: " + numObjectsInOffHeapMemory));
                }
            }
        }
    }

    private static String verifyChunks(List<OffHeapChunkInfo> chunkList) {
        Collections.sort(chunkList);
        logger.info((Object)("Verifying " + chunkList.size() + " off-heap memory chunks"));
        StringBuilder errStr = new StringBuilder();
        ArrayList<Integer> freeMemoryIndexes = new ArrayList<Integer>();
        long totalBytesConsumedInChunks = 0L;
        for (int i = 0; i < chunkList.size(); ++i) {
            OffHeapChunkInfo currentInfo = chunkList.get(i);
            long firstAddress = currentInfo.getFirstMemoryAddress();
            if ((firstAddress & 7L) != 0L) {
                errStr.append("Off-heap memory address was not 8 byte aligned: ").append(currentInfo).append("\n");
            }
            if (firstAddress < 1024L) {
                throw new IllegalStateException("Off-heap memory address was smaller than expected " + currentInfo + "\n");
            }
            totalBytesConsumedInChunks += currentInfo.getNumberBytes();
            if (i <= 0) continue;
            OffHeapChunkInfo previousInfo = chunkList.get(i - 1);
            if (firstAddress == previousInfo.getFirstMemoryAddress()) {
                errStr.append("<").append(currentInfo).append("> is referencing the same off-heap memory address as <").append(previousInfo).append(">\n");
                continue;
            }
            if (firstAddress <= previousInfo.getLastMemoryAddress()) {
                errStr.append("<").append(currentInfo).append("> overlaps off-heap memory with <").append(previousInfo).append(">\n");
                continue;
            }
            if (previousInfo.getLastMemoryAddress() + 1L == firstAddress) continue;
            freeMemoryIndexes.add(i - 1);
        }
        StringBuilder aStr = new StringBuilder();
        long totalFreeMemoryInBytes = 0L;
        long minFreeMemorySizeInBytes = Long.MAX_VALUE;
        long maxFreeMemorySizeInBytes = 0L;
        int maxChunksToLog = Math.min(freeMemoryIndexes.size(), 20);
        for (int i = 0; i < freeMemoryIndexes.size(); ++i) {
            int chunkListIndex = (Integer)freeMemoryIndexes.get(i);
            OffHeapChunkInfo chunkBeforeFreeMemory = chunkList.get(chunkListIndex);
            OffHeapChunkInfo chunkAfterFreeMemory = chunkList.get(chunkListIndex + 1);
            long memoryAddressOfFreeMemory = chunkBeforeFreeMemory.getLastMemoryAddress() + 1L;
            long freeMemorySizeInBytes = chunkAfterFreeMemory.getFirstMemoryAddress() - memoryAddressOfFreeMemory;
            totalFreeMemoryInBytes += freeMemorySizeInBytes;
            minFreeMemorySizeInBytes = Math.min(minFreeMemorySizeInBytes, freeMemorySizeInBytes);
            maxFreeMemorySizeInBytes = Math.max(maxFreeMemorySizeInBytes, freeMemorySizeInBytes);
            if (i + 1 > maxChunksToLog) continue;
            aStr.append("  ").append(i + 1).append(": free memory of size ").append(freeMemorySizeInBytes).append(" bytes between chunk ").append(chunkListIndex).append(" <").append(chunkBeforeFreeMemory).append("> and next chunk <").append(chunkAfterFreeMemory).append(">\n");
        }
        logger.info((Object)(chunkList.size() + " chunks consumed " + totalBytesConsumedInChunks + " bytes of off-heap memory"));
        if (minFreeMemorySizeInBytes < 8L) {
            errStr.append("The minimum free memory size is ").append(minFreeMemorySizeInBytes).append(", but expected it to be >= 8\n");
        }
        if (freeMemoryIndexes.size() == 0) {
            logger.info((Object)"Found 0 free memory segments between chunks");
        } else {
            double average = totalFreeMemoryInBytes / (long)freeMemoryIndexes.size();
            logger.info((Object)("Found " + freeMemoryIndexes.size() + " free memory segments between chunks; free memory totals " + totalFreeMemoryInBytes + " bytes, min free memory size " + minFreeMemorySizeInBytes + " bytes, max free memory size " + maxFreeMemorySizeInBytes + " bytes, average free memory size " + average + " bytes\nFirst " + maxChunksToLog + " free memory chunks:\n" + aStr));
        }
        return errStr.toString();
    }

    public static Set<Region<?, ?>> getAllRegions() {
        GemFireCacheImpl theCache = GemFireCacheImpl.getInstance();
        if (theCache == null) {
            logger.info((Object)"There are no regions in this member, cache is null");
            return null;
        }
        Set rootRegions = theCache.rootRegions();
        HashSet allRegions = new HashSet();
        allRegions.addAll(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        return allRegions;
    }

    public static void verifyRegionsEnabledWithOffHeap(List<String> regionNames) {
        StringBuilder errStr = new StringBuilder();
        Set<Region<?, ?>> allRegions = OffHeapHelper.getAllRegions();
        assert (allRegions != null);
        Iterator<Region<?, ?>> iterator = allRegions.iterator();
        while (iterator.hasNext()) {
            boolean offHeapEnabled;
            Region<?, ?> aRegion;
            boolean expectOffHeapEnabled = regionNames == null || regionNames.contains(aRegion.getFullPath());
            if (expectOffHeapEnabled == (offHeapEnabled = (aRegion = iterator.next()).getAttributes().getEnableOffHeapMemory())) continue;
            errStr.append("Expected attributes for ").append(aRegion.getFullPath()).append(" to have enableOffHeapMemory ").append(expectOffHeapEnabled).append(", but it is ").append(offHeapEnabled).append("\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static boolean isOffHeapMemoryConfigured() {
        try {
            SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
            return offHeapStore != null;
        }
        catch (CacheClosedException e) {
            String errStr = e.toString();
            if (errStr.contains("Off Heap memory allocator does not exist")) {
                return false;
            }
            throw e;
        }
    }

    public static OffHeapMemoryStats getOffHeapMemoryStats() {
        SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
        if (offHeapStore == null) {
            throw new TestException("Cannot get off-heap memory stats because the offHeapStore is null");
        }
        OffHeapMemoryStats offHeapStats = offHeapStore.getStats();
        if (offHeapStats == null) {
            throw new TestException("The off-heap stats is null");
        }
        return offHeapStats;
    }

    public static void waitForWanQueuesToDrain() {
        AEQHelper.waitForAsyncEventQueuesToDrain();
    }
}

