/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.test.dunit.standalone;

import com.gemstone.gemfire.distributed.Locator;
import io.snappydata.test.batterytest.greplogs.ExpectedStrings;
import io.snappydata.test.batterytest.greplogs.LogConsumer;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.BounceResult;
import io.snappydata.test.dunit.DUnitEnv;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RemoteDUnitVMIF;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.dunit.standalone.ProcessManager;
import io.snappydata.test.dunit.standalone.RemoteDUnitVM;
import io.snappydata.test.dunit.standalone.StandAloneDUnitEnv;
import io.snappydata.test.hydra.MethExecutorResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.junit.Assert;

public class DUnitLauncher {
    static int locatorPort;
    static ProcessManager processManager;
    private static MasterRemote masterRemote;
    private static final Map<Object, Object> blackboard;
    private static final Semaphore sharedLock;
    private static final int NUM_VMS;
    private static final int DEBUGGING_VM_NUM = -1;
    private static final int LOCATOR_VM_NUM = -2;
    static final long STARTUP_TIMEOUT = 30000L;
    private static final String SUSPECT_FILENAME = "dunit_suspect.log";
    private static File DUNIT_SUSPECT_FILE;
    public static final String DUNIT_DIR = "dunit";
    public static final String LOG_LEVEL;
    public static final String SECURITY_LOG_LEVEL;
    public static final String WORKSPACE_DIR_PARAM = "WORKSPACE_DIR";
    public static final boolean LOCATOR_LOG_TO_DISK;
    static final String MASTER_PARAM = "DUNIT_MASTER";
    static final String RMI_PORT_PARAM = "gemfire.DUnitLauncher.RMI_PORT";
    public static final String VM_NUM_PARAM = "gemfire.DUnitLauncher.VM_NUM";
    private static final String LAUNCHED_PROPERTY = "gemfire.DUnitLauncher.LAUNCHED";

    private DUnitLauncher() {
    }

    private static boolean isHydra() {
        try {
            Class<?> clazz = Class.forName("hydra.TestConfig");
            Method getInstance = clazz.getMethod("getInstance", new Class[0]);
            getInstance.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void launchIfNeeded() {
        if (System.getProperties().contains(VM_NUM_PARAM)) {
            return;
        }
        if (!DUnitLauncher.isHydra() && !DUnitLauncher.isLaunched()) {
            try {
                DUnitLauncher.launch();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to launch dunit VMS", e);
            }
        }
    }

    public static boolean isLaunched() {
        return Boolean.getBoolean(LAUNCHED_PROPERTY);
    }

    public static String getLocatorString() {
        return "localhost[" + locatorPort + "]";
    }

    public static int getLocator() {
        return locatorPort;
    }

    private static void launch() throws URISyntaxException, AlreadyBoundException, IOException, InterruptedException, NotBoundException {
        DUNIT_SUSPECT_FILE = new File(SUSPECT_FILENAME);
        DUNIT_SUSPECT_FILE.delete();
        DUNIT_SUSPECT_FILE.deleteOnExit();
        locatorPort = AvailablePortHelper.getRandomAvailableTCPPort();
        int namingPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Registry registry = LocateRegistry.createRegistry(namingPort);
        processManager = new ProcessManager(namingPort, registry);
        Master master = new Master(registry, processManager);
        registry.bind(MASTER_PARAM, master);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processManager.killVMs();
            }
        });
        processManager.launchVM(-2);
        for (int i = 0; i < NUM_VMS; ++i) {
            processManager.launchVM(i);
        }
        if (!processManager.waitForVMs(30000L)) {
            throw new RuntimeException("VMs did not start up with 30 seconds");
        }
        DUnitHost host = new DUnitHost(InetAddress.getLocalHost().getCanonicalHostName(), processManager);
        host.init(registry, NUM_VMS);
        DUnitLauncher.init(master);
    }

    public static Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        p.setProperty("locators", DUnitLauncher.getLocatorString());
        p.setProperty("mcast-port", "0");
        p.setProperty("log-level", LOG_LEVEL);
        p.setProperty("security-log-level", SECURITY_LOG_LEVEL);
        return p;
    }

    private static void addSuspectFileAppender(String workspaceDir) {
        String suspectFilename = new File(workspaceDir, SUSPECT_FILENAME).getAbsolutePath();
        Logger logger = LogManager.getLogger((String)"HOST");
        logger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("[%level{lowerCase=true} %date{yyyy/MM/dd HH:mm:ss.SSS z} <%thread> tid=%tid] %message%n%throwable%n");
        try {
            FileAppender fileAppender = new FileAppender((Layout)layout, suspectFilename, true);
            logger.addAppender((Appender)fileAppender);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void startLocator(Registry registry) throws IOException, NotBoundException {
        File locatorLogFile;
        RemoteDUnitVMIF remote = (RemoteDUnitVMIF)registry.lookup("vm-2");
        MethExecutorResult result = remote.executeMethodOnObject(new SerializableCallable(locatorLogFile = LOCATOR_LOG_TO_DISK ? new File("locator-" + locatorPort + ".log") : new File("")){
            final /* synthetic */ File val$locatorLogFile;
            {
                this.val$locatorLogFile = file;
            }

            @Override
            public Object call() throws IOException {
                Properties p = DUnitLauncher.getDistributedSystemProperties();
                p.setProperty("jmx-manager", "false");
                Locator.startLocatorAndDS((int)locatorPort, (File)this.val$locatorLogFile, (Properties)p);
                return null;
            }
        }, "call");
        if (result.getException() != null) {
            RuntimeException ex = new RuntimeException("Failed to start locator", result.getException());
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void init(MasterRemote master) {
        masterRemote = master;
        DUnitEnv.set(new StandAloneDUnitEnv(master));
        String workspaceDir = System.getProperty(WORKSPACE_DIR_PARAM);
        workspaceDir = workspaceDir == null ? new File(".").getAbsolutePath() : workspaceDir;
        DUnitLauncher.addSuspectFileAppender(workspaceDir);
        System.setProperty("gemfire.free-off-heap-memory", "true");
        System.setProperty(LAUNCHED_PROPERTY, "true");
    }

    public static MasterRemote getMaster() {
        return masterRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForSuspectStrings() {
        if (DUnitLauncher.isLaunched()) {
            BufferedReader buffReader;
            FileChannel fileChannel;
            boolean skipLogMsgs = ExpectedStrings.skipLogMsgs(DUNIT_DIR);
            List expectedStrings = ExpectedStrings.create(DUNIT_DIR);
            LogConsumer logConsumer = new LogConsumer(skipLogMsgs, expectedStrings, "log4j", 5);
            StringBuilder suspectStringBuilder = new StringBuilder();
            try {
                fileChannel = new FileOutputStream(DUNIT_SUSPECT_FILE, true).getChannel();
                buffReader = new BufferedReader(new FileReader(DUNIT_SUSPECT_FILE));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not find the suspect string output file: " + e);
                return;
            }
            try {
                try {
                    String line;
                    while ((line = buffReader.readLine()) != null) {
                        StringBuilder builder = logConsumer.consume(line);
                        if (builder == null) continue;
                        suspectStringBuilder.append((CharSequence)builder);
                    }
                }
                catch (IOException e) {
                    System.err.println("Could not read the suspect string output file: " + e);
                }
                try {
                    fileChannel.truncate(0L);
                }
                catch (IOException e) {
                    System.err.println("Could not truncate the suspect string output file: " + e);
                }
            }
            finally {
                try {
                    buffReader.close();
                    fileChannel.close();
                }
                catch (IOException e) {
                    System.err.println("Could not close the suspect string output file: " + e);
                }
            }
            if (suspectStringBuilder.length() != 0) {
                System.err.println("Suspicious strings were written to the log during this run.\nFix the strings or use DistributedTestBase.addExpectedException to ignore.\n" + suspectStringBuilder);
                Assert.fail((String)("Suspicious strings were written to the log during this run.\nFix the strings or use DistributedTestBase.addExpectedException to ignore.\n" + suspectStringBuilder));
            }
        }
    }

    static {
        blackboard = new HashMap<Object, Object>();
        sharedLock = new Semaphore(1);
        NUM_VMS = Integer.getInteger("gemfire.DUnitLauncher.NUM_VMS", 4);
        LOG_LEVEL = System.getProperty("logLevel", "config");
        SECURITY_LOG_LEVEL = System.getProperty("securityLogLevel", LOG_LEVEL);
        LOCATOR_LOG_TO_DISK = Boolean.getBoolean("locatorLogToDisk");
    }

    private static class DUnitHost
    extends Host {
        private static final long serialVersionUID = -8034165624503666383L;
        private final transient VM debuggingVM = new VM(this, -1, new RemoteDUnitVM());
        private transient ProcessManager processManager;

        public DUnitHost(String hostName, ProcessManager processManager) throws RemoteException {
            super(hostName);
            this.processManager = processManager;
        }

        public void init(Registry registry, int numVMs) throws AccessException, RemoteException, NotBoundException, InterruptedException {
            for (int i = 0; i < numVMs; ++i) {
                RemoteDUnitVMIF remote = this.processManager.getStub(i);
                this.addVM(i, remote);
            }
            this.addLocator(-2, this.processManager.getStub(-2));
            DUnitHost.addHost(this);
        }

        @Override
        public VM getVM(int n) {
            if (n == -1) {
                return this.debuggingVM;
            }
            int oldVMCount = this.getVMCount();
            if (n >= oldVMCount) {
                try {
                    int i;
                    for (i = oldVMCount; i <= n; ++i) {
                        this.processManager.launchVM(i);
                    }
                    this.processManager.waitForVMs(30000L);
                    for (i = oldVMCount; i <= n; ++i) {
                        this.addVM(i, this.processManager.getStub(i));
                    }
                }
                catch (IOException | InterruptedException | NotBoundException e) {
                    throw new RuntimeException("Could not dynamically launch vm + " + n, e);
                }
            }
            return super.getVM(n);
        }
    }

    public static class Master
    extends UnicastRemoteObject
    implements MasterRemote {
        private static final long serialVersionUID = 1178600200232603119L;
        private final Registry registry;
        private final ProcessManager processManager;

        public Master(Registry registry, ProcessManager processManager) throws RemoteException {
            this.processManager = processManager;
            this.registry = registry;
        }

        @Override
        public int getLocatorPort() throws RemoteException {
            return locatorPort;
        }

        @Override
        public synchronized void signalVMReady() {
            this.processManager.signalVMReady();
        }

        @Override
        public void ping() {
        }

        @Override
        public BounceResult bounce(int pid) {
            this.processManager.bounce(pid);
            try {
                if (!this.processManager.waitForVMs(30000L)) {
                    throw new RuntimeException("VMs did not start up with 30 seconds");
                }
                RemoteDUnitVMIF remote = (RemoteDUnitVMIF)this.registry.lookup("vm" + pid);
                return new BounceResult(pid, remote);
            }
            catch (NotBoundException | RemoteException e) {
                throw new RuntimeException("could not lookup name", e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for VM", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(Object key) {
            Map map = blackboard;
            synchronized (map) {
                return blackboard.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean put(Object key, Object value) {
            Map map = blackboard;
            synchronized (map) {
                return blackboard.put(key, value) == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key) {
            Map map = blackboard;
            synchronized (map) {
                return blackboard.remove(key) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addAndGet(Object key, int delta, int defaultValue) {
            Map map = blackboard;
            synchronized (map) {
                Object current = blackboard.get(key);
                if (current == null) {
                    blackboard.put(key, defaultValue);
                    return defaultValue;
                }
                int newValue = (Integer)current + delta;
                blackboard.put(key, newValue);
                return newValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<Object, Object> getMapCopy() {
            Map map = blackboard;
            synchronized (map) {
                return new HashMap<Object, Object>(blackboard);
            }
        }

        @Override
        public void acquireSharedLock() {
            try {
                sharedLock.acquire();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Failed waiting for shared lock", ie);
            }
        }

        @Override
        public void releaseSharedLock() {
            sharedLock.release();
        }
    }

    public static interface MasterRemote
    extends Remote {
        public int getLocatorPort() throws RemoteException;

        public void signalVMReady() throws RemoteException;

        public void ping() throws RemoteException;

        public BounceResult bounce(int var1) throws RemoteException;

        public Object get(Object var1) throws RemoteException;

        public boolean put(Object var1, Object var2) throws RemoteException;

        public boolean remove(Object var1) throws RemoteException;

        public int addAndGet(Object var1, int var2, int var3) throws RemoteException;

        public Map<Object, Object> getMapCopy() throws RemoteException;

        public void acquireSharedLock() throws RemoteException;

        public void releaseSharedLock() throws RemoteException;
    }
}

