/**
 * snapCX - Shippping Tracking API for commerce & retailers.
 * This API provides real time shipping tracking status (along with tracking events) for multiple carriers. It takes carrier code (UPS or USPS or FEDEX or DHL Or Canada Post) and tracking number as input. To invoke this API, you need to have your own private api key (aka user_key). You can always sign up for FREE plan to get user_key.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@snapcx.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.snapcx.tracking.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * TrackSummary
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-01-03T19:17:01.024-05:00")
public class TrackSummary   {
  @JsonProperty("errorCode")
  private String errorCode = null;

  @JsonProperty("errorMessage")
  private String errorMessage = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("cached")
  private Boolean cached = null;

  @JsonProperty("carrier")
  private String carrier = null;

  @JsonProperty("trackingId")
  private String trackingId = null;

  @JsonProperty("delivered")
  private Boolean delivered = null;

  @JsonProperty("lastCheckWithCarrier")
  private String lastCheckWithCarrier = null;

  @JsonProperty("estimatedDeliveryDate")
  private String estimatedDeliveryDate = null;

  @JsonProperty("destination")
  private String destination = null;

  @JsonProperty("origin")
  private String origin = null;

  @JsonProperty("destinationLat")
  private String destinationLat = null;

  @JsonProperty("destinationLong")
  private String destinationLong = null;

  public TrackSummary errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

   /**
   * Error Code in case of any problem for this particular tracking id.
   * @return errorCode
  **/
  @ApiModelProperty(example = "null", value = "Error Code in case of any problem for this particular tracking id.")
  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public TrackSummary errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * Error Message in case of any problem for this particular tracking id. 
   * @return errorMessage
  **/
  @ApiModelProperty(example = "null", value = "Error Message in case of any problem for this particular tracking id. ")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public TrackSummary status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Two possible values, SUCCESS or FAIL.
   * @return status
  **/
  @ApiModelProperty(example = "null", value = "Two possible values, SUCCESS or FAIL.")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public TrackSummary cached(Boolean cached) {
    this.cached = cached;
    return this;
  }

   /**
   * if tracking details were retrieved from cache. Generally, it will be always be true (except for first time for a new tracking#).
   * @return cached
  **/
  @ApiModelProperty(example = "null", value = "if tracking details were retrieved from cache. Generally, it will be always be true (except for first time for a new tracking#).")
  public Boolean getCached() {
    return cached;
  }

  public void setCached(Boolean cached) {
    this.cached = cached;
  }

  public TrackSummary carrier(String carrier) {
    this.carrier = carrier;
    return this;
  }

   /**
   * Carrier code
   * @return carrier
  **/
  @ApiModelProperty(example = "null", value = "Carrier code")
  public String getCarrier() {
    return carrier;
  }

  public void setCarrier(String carrier) {
    this.carrier = carrier;
  }

  public TrackSummary trackingId(String trackingId) {
    this.trackingId = trackingId;
    return this;
  }

   /**
   * Tracking number of response.
   * @return trackingId
  **/
  @ApiModelProperty(example = "null", value = "Tracking number of response.")
  public String getTrackingId() {
    return trackingId;
  }

  public void setTrackingId(String trackingId) {
    this.trackingId = trackingId;
  }

  public TrackSummary delivered(Boolean delivered) {
    this.delivered = delivered;
    return this;
  }

   /**
   * if package is delivered, then true otherwise false.
   * @return delivered
  **/
  @ApiModelProperty(example = "null", value = "if package is delivered, then true otherwise false.")
  public Boolean getDelivered() {
    return delivered;
  }

  public void setDelivered(Boolean delivered) {
    this.delivered = delivered;
  }

  public TrackSummary lastCheckWithCarrier(String lastCheckWithCarrier) {
    this.lastCheckWithCarrier = lastCheckWithCarrier;
    return this;
  }

   /**
   * null
   * @return lastCheckWithCarrier
  **/
  @ApiModelProperty(example = "null", value = "null")
  public String getLastCheckWithCarrier() {
    return lastCheckWithCarrier;
  }

  public void setLastCheckWithCarrier(String lastCheckWithCarrier) {
    this.lastCheckWithCarrier = lastCheckWithCarrier;
  }

  public TrackSummary estimatedDeliveryDate(String estimatedDeliveryDate) {
    this.estimatedDeliveryDate = estimatedDeliveryDate;
    return this;
  }

   /**
   * Estimated delivery date, as per carrier.
   * @return estimatedDeliveryDate
  **/
  @ApiModelProperty(example = "null", value = "Estimated delivery date, as per carrier.")
  public String getEstimatedDeliveryDate() {
    return estimatedDeliveryDate;
  }

  public void setEstimatedDeliveryDate(String estimatedDeliveryDate) {
    this.estimatedDeliveryDate = estimatedDeliveryDate;
  }

  public TrackSummary destination(String destination) {
    this.destination = destination;
    return this;
  }

   /**
   * Destination city, state, Country etc.
   * @return destination
  **/
  @ApiModelProperty(example = "null", value = "Destination city, state, Country etc.")
  public String getDestination() {
    return destination;
  }

  public void setDestination(String destination) {
    this.destination = destination;
  }

  public TrackSummary origin(String origin) {
    this.origin = origin;
    return this;
  }

   /**
   * Shipping origin city, state, Country etc.
   * @return origin
  **/
  @ApiModelProperty(example = "null", value = "Shipping origin city, state, Country etc.")
  public String getOrigin() {
    return origin;
  }

  public void setOrigin(String origin) {
    this.origin = origin;
  }

  public TrackSummary destinationLat(String destinationLat) {
    this.destinationLat = destinationLat;
    return this;
  }

   /**
   * Destination geo location Coordinates, Latitude.
   * @return destinationLat
  **/
  @ApiModelProperty(example = "null", value = "Destination geo location Coordinates, Latitude.")
  public String getDestinationLat() {
    return destinationLat;
  }

  public void setDestinationLat(String destinationLat) {
    this.destinationLat = destinationLat;
  }

  public TrackSummary destinationLong(String destinationLong) {
    this.destinationLong = destinationLong;
    return this;
  }

   /**
   * Destination geo location Coordinates, Longtitude.
   * @return destinationLong
  **/
  @ApiModelProperty(example = "null", value = "Destination geo location Coordinates, Longtitude.")
  public String getDestinationLong() {
    return destinationLong;
  }

  public void setDestinationLong(String destinationLong) {
    this.destinationLong = destinationLong;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrackSummary trackSummary = (TrackSummary) o;
    return Objects.equals(this.errorCode, trackSummary.errorCode) &&
        Objects.equals(this.errorMessage, trackSummary.errorMessage) &&
        Objects.equals(this.status, trackSummary.status) &&
        Objects.equals(this.cached, trackSummary.cached) &&
        Objects.equals(this.carrier, trackSummary.carrier) &&
        Objects.equals(this.trackingId, trackSummary.trackingId) &&
        Objects.equals(this.delivered, trackSummary.delivered) &&
        Objects.equals(this.lastCheckWithCarrier, trackSummary.lastCheckWithCarrier) &&
        Objects.equals(this.estimatedDeliveryDate, trackSummary.estimatedDeliveryDate) &&
        Objects.equals(this.destination, trackSummary.destination) &&
        Objects.equals(this.origin, trackSummary.origin) &&
        Objects.equals(this.destinationLat, trackSummary.destinationLat) &&
        Objects.equals(this.destinationLong, trackSummary.destinationLong);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, errorMessage, status, cached, carrier, trackingId, delivered, lastCheckWithCarrier, estimatedDeliveryDate, destination, origin, destinationLat, destinationLong);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrackSummary {\n");
    
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cached: ").append(toIndentedString(cached)).append("\n");
    sb.append("    carrier: ").append(toIndentedString(carrier)).append("\n");
    sb.append("    trackingId: ").append(toIndentedString(trackingId)).append("\n");
    sb.append("    delivered: ").append(toIndentedString(delivered)).append("\n");
    sb.append("    lastCheckWithCarrier: ").append(toIndentedString(lastCheckWithCarrier)).append("\n");
    sb.append("    estimatedDeliveryDate: ").append(toIndentedString(estimatedDeliveryDate)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    destinationLat: ").append(toIndentedString(destinationLat)).append("\n");
    sb.append("    destinationLong: ").append(toIndentedString(destinationLong)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

