/**
 * snapCX - Shippping Tracking API for commerce & retailers.
 * This API provides real time shipping tracking status (along with tracking events) for multiple carriers. It takes carrier code (UPS or USPS or FEDEX or DHL Or Canada Post) and tracking number as input. To invoke this API, you need to have your own private api key (aka user_key). You can always sign up for FREE plan to get user_key.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@snapcx.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.snapcx.tracking.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * TrackEvent
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-01-03T19:17:01.024-05:00")
public class TrackEvent   {
  @JsonProperty("time")
  private String time = null;

  @JsonProperty("date")
  private String date = null;

  @JsonProperty("location")
  private String location = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("latitude")
  private String latitude = null;

  @JsonProperty("longtitude")
  private String longtitude = null;

  public TrackEvent time(String time) {
    this.time = time;
    return this;
  }

   /**
   * Timestamp of track event.
   * @return time
  **/
  @ApiModelProperty(example = "null", value = "Timestamp of track event.")
  public String getTime() {
    return time;
  }

  public void setTime(String time) {
    this.time = time;
  }

  public TrackEvent date(String date) {
    this.date = date;
    return this;
  }

   /**
   * Date of track event.
   * @return date
  **/
  @ApiModelProperty(example = "null", value = "Date of track event.")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public TrackEvent location(String location) {
    this.location = location;
    return this;
  }

   /**
   * City, State etc of track event.
   * @return location
  **/
  @ApiModelProperty(example = "null", value = "City, State etc of track event.")
  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public TrackEvent message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Track event actual description.
   * @return message
  **/
  @ApiModelProperty(example = "null", value = "Track event actual description.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public TrackEvent latitude(String latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Geo location Coordinates, Latitude.
   * @return latitude
  **/
  @ApiModelProperty(example = "null", value = "Geo location Coordinates, Latitude.")
  public String getLatitude() {
    return latitude;
  }

  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }

  public TrackEvent longtitude(String longtitude) {
    this.longtitude = longtitude;
    return this;
  }

   /**
   * Geo location Coordinates, Longtitude.
   * @return longtitude
  **/
  @ApiModelProperty(example = "null", value = "Geo location Coordinates, Longtitude.")
  public String getLongtitude() {
    return longtitude;
  }

  public void setLongtitude(String longtitude) {
    this.longtitude = longtitude;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrackEvent trackEvent = (TrackEvent) o;
    return Objects.equals(this.time, trackEvent.time) &&
        Objects.equals(this.date, trackEvent.date) &&
        Objects.equals(this.location, trackEvent.location) &&
        Objects.equals(this.message, trackEvent.message) &&
        Objects.equals(this.latitude, trackEvent.latitude) &&
        Objects.equals(this.longtitude, trackEvent.longtitude);
  }

  @Override
  public int hashCode() {
    return Objects.hash(time, date, location, message, latitude, longtitude);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrackEvent {\n");
    
    sb.append("    time: ").append(toIndentedString(time)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longtitude: ").append(toIndentedString(longtitude)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

