/**
 * snapCX - Address Validation APIs for commerce & retailers.
 * This set of API end points, provides real time address validations and corrections. Also do zipcode lookups etc. To invoke this API, you need to have your own private api key (aka user_key). You can always sign up for FREE plan to get user_key.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@snapcx.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.snapcx.avs.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * ZipDetails
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-01-03T19:15:39.720-05:00")
public class ZipDetails   {
  @JsonProperty("city")
  private String city = null;

  @JsonProperty("state")
  private String state = null;

  @JsonProperty("county")
  private String county = null;

  @JsonProperty("zipCode")
  private String zipCode = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("latitude")
  private Boolean latitude = null;

  @JsonProperty("longitude")
  private Boolean longitude = null;

  @JsonProperty("notes")
  private Boolean notes = null;

  public ZipDetails city(String city) {
    this.city = city;
    return this;
  }

   /**
   * Name of city
   * @return city
  **/
  @ApiModelProperty(example = "null", value = "Name of city")
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public ZipDetails state(String state) {
    this.state = state;
    return this;
  }

   /**
   * 2 Char state abbrv.
   * @return state
  **/
  @ApiModelProperty(example = "null", value = "2 Char state abbrv.")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public ZipDetails county(String county) {
    this.county = county;
    return this;
  }

   /**
   * Name of county
   * @return county
  **/
  @ApiModelProperty(example = "null", value = "Name of county")
  public String getCounty() {
    return county;
  }

  public void setCounty(String county) {
    this.county = county;
  }

  public ZipDetails zipCode(String zipCode) {
    this.zipCode = zipCode;
    return this;
  }

   /**
   * 5 Digit zipcode
   * @return zipCode
  **/
  @ApiModelProperty(example = "null", value = "5 Digit zipcode")
  public String getZipCode() {
    return zipCode;
  }

  public void setZipCode(String zipCode) {
    this.zipCode = zipCode;
  }

  public ZipDetails type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Type indicates, purpose of this zipcode. Is it residential or PO Box only or some commercial purpose.
   * @return type
  **/
  @ApiModelProperty(example = "null", value = "Type indicates, purpose of this zipcode. Is it residential or PO Box only or some commercial purpose.")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ZipDetails latitude(Boolean latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * latitude of city center.
   * @return latitude
  **/
  @ApiModelProperty(example = "null", value = "latitude of city center.")
  public Boolean getLatitude() {
    return latitude;
  }

  public void setLatitude(Boolean latitude) {
    this.latitude = latitude;
  }

  public ZipDetails longitude(Boolean longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * longitude of city center.
   * @return longitude
  **/
  @ApiModelProperty(example = "null", value = "longitude of city center.")
  public Boolean getLongitude() {
    return longitude;
  }

  public void setLongitude(Boolean longitude) {
    this.longitude = longitude;
  }

  public ZipDetails notes(Boolean notes) {
    this.notes = notes;
    return this;
  }

   /**
   * Any notes regarding this zipcode.
   * @return notes
  **/
  @ApiModelProperty(example = "null", value = "Any notes regarding this zipcode.")
  public Boolean getNotes() {
    return notes;
  }

  public void setNotes(Boolean notes) {
    this.notes = notes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ZipDetails zipDetails = (ZipDetails) o;
    return Objects.equals(this.city, zipDetails.city) &&
        Objects.equals(this.state, zipDetails.state) &&
        Objects.equals(this.county, zipDetails.county) &&
        Objects.equals(this.zipCode, zipDetails.zipCode) &&
        Objects.equals(this.type, zipDetails.type) &&
        Objects.equals(this.latitude, zipDetails.latitude) &&
        Objects.equals(this.longitude, zipDetails.longitude) &&
        Objects.equals(this.notes, zipDetails.notes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(city, state, county, zipCode, type, latitude, longitude, notes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ZipDetails {\n");
    
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    county: ").append(toIndentedString(county)).append("\n");
    sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

