/**
 * snapCX - Address Validation APIs for commerce & retailers.
 * This set of API end points, provides real time address validations and corrections. Also do zipcode lookups etc. To invoke this API, you need to have your own private api key (aka user_key). You can always sign up for FREE plan to get user_key.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@snapcx.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.snapcx.avs.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * AddressSummary
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-01-03T19:15:39.720-05:00")
public class AddressSummary   {
  @JsonProperty("errorCode")
  private String errorCode = null;

  @JsonProperty("errorMessage")
  private String errorMessage = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("cached")
  private Boolean cached = null;

  @JsonProperty("matchCode")
  private String matchCode = null;

  @JsonProperty("detailedMatchCodes")
  private String detailedMatchCodes = null;

  @JsonProperty("dpvIndicator")
  private String dpvIndicator = null;

  @JsonProperty("dpvFootNote1")
  private String dpvFootNote1 = null;

  @JsonProperty("dpvFootNote2")
  private String dpvFootNote2 = null;

  @JsonProperty("dpvVacantIndicator")
  private String dpvVacantIndicator = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("footnotes")
  private String footnotes = null;

  public AddressSummary errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

   /**
   * Error Code in case of any problem for this particular address.
   * @return errorCode
  **/
  @ApiModelProperty(example = "null", value = "Error Code in case of any problem for this particular address.")
  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public AddressSummary errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * Error Message in case of any problem for this particular address. 
   * @return errorMessage
  **/
  @ApiModelProperty(example = "null", value = "Error Message in case of any problem for this particular address. ")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public AddressSummary status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Two possible values, SUCCESS or FAIL.
   * @return status
  **/
  @ApiModelProperty(example = "null", value = "Two possible values, SUCCESS or FAIL.")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public AddressSummary cached(Boolean cached) {
    this.cached = cached;
    return this;
  }

   /**
   * if address was validated using cache. Generally, it will be always be false.
   * @return cached
  **/
  @ApiModelProperty(example = "null", value = "if address was validated using cache. Generally, it will be always be false.")
  public Boolean getCached() {
    return cached;
  }

  public void setCached(Boolean cached) {
    this.cached = cached;
  }

  public AddressSummary matchCode(String matchCode) {
    this.matchCode = matchCode;
    return this;
  }

   /**
   * Primary match code. Either of AVS_01 or AVS_02 or AVS_03
   * @return matchCode
  **/
  @ApiModelProperty(example = "null", value = "Primary match code. Either of AVS_01 or AVS_02 or AVS_03")
  public String getMatchCode() {
    return matchCode;
  }

  public void setMatchCode(String matchCode) {
    this.matchCode = matchCode;
  }

  public AddressSummary detailedMatchCodes(String detailedMatchCodes) {
    this.detailedMatchCodes = detailedMatchCodes;
    return this;
  }

   /**
   * Further drill down on matchCode above.
   * @return detailedMatchCodes
  **/
  @ApiModelProperty(example = "null", value = "Further drill down on matchCode above.")
  public String getDetailedMatchCodes() {
    return detailedMatchCodes;
  }

  public void setDetailedMatchCodes(String detailedMatchCodes) {
    this.detailedMatchCodes = detailedMatchCodes;
  }

  public AddressSummary dpvIndicator(String dpvIndicator) {
    this.dpvIndicator = dpvIndicator;
    return this;
  }

   /**
   * dpvIndicator
   * @return dpvIndicator
  **/
  @ApiModelProperty(example = "null", value = "dpvIndicator")
  public String getDpvIndicator() {
    return dpvIndicator;
  }

  public void setDpvIndicator(String dpvIndicator) {
    this.dpvIndicator = dpvIndicator;
  }

  public AddressSummary dpvFootNote1(String dpvFootNote1) {
    this.dpvFootNote1 = dpvFootNote1;
    return this;
  }

   /**
   * dpvFootNote1 (Future use)
   * @return dpvFootNote1
  **/
  @ApiModelProperty(example = "null", value = "dpvFootNote1 (Future use)")
  public String getDpvFootNote1() {
    return dpvFootNote1;
  }

  public void setDpvFootNote1(String dpvFootNote1) {
    this.dpvFootNote1 = dpvFootNote1;
  }

  public AddressSummary dpvFootNote2(String dpvFootNote2) {
    this.dpvFootNote2 = dpvFootNote2;
    return this;
  }

   /**
   * dpvFootNote2 (Future Use).
   * @return dpvFootNote2
  **/
  @ApiModelProperty(example = "null", value = "dpvFootNote2 (Future Use).")
  public String getDpvFootNote2() {
    return dpvFootNote2;
  }

  public void setDpvFootNote2(String dpvFootNote2) {
    this.dpvFootNote2 = dpvFootNote2;
  }

  public AddressSummary dpvVacantIndicator(String dpvVacantIndicator) {
    this.dpvVacantIndicator = dpvVacantIndicator;
    return this;
  }

   /**
   * dpvVacantIndicator (Future Use).
   * @return dpvVacantIndicator
  **/
  @ApiModelProperty(example = "null", value = "dpvVacantIndicator (Future Use).")
  public String getDpvVacantIndicator() {
    return dpvVacantIndicator;
  }

  public void setDpvVacantIndicator(String dpvVacantIndicator) {
    this.dpvVacantIndicator = dpvVacantIndicator;
  }

  public AddressSummary message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Message from validation engine, hinting what has been corrected on input address.
   * @return message
  **/
  @ApiModelProperty(example = "null", value = "Message from validation engine, hinting what has been corrected on input address.")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public AddressSummary footnotes(String footnotes) {
    this.footnotes = footnotes;
    return this;
  }

   /**
   * USPS footnotes values.
   * @return footnotes
  **/
  @ApiModelProperty(example = "null", value = "USPS footnotes values.")
  public String getFootnotes() {
    return footnotes;
  }

  public void setFootnotes(String footnotes) {
    this.footnotes = footnotes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddressSummary addressSummary = (AddressSummary) o;
    return Objects.equals(this.errorCode, addressSummary.errorCode) &&
        Objects.equals(this.errorMessage, addressSummary.errorMessage) &&
        Objects.equals(this.status, addressSummary.status) &&
        Objects.equals(this.cached, addressSummary.cached) &&
        Objects.equals(this.matchCode, addressSummary.matchCode) &&
        Objects.equals(this.detailedMatchCodes, addressSummary.detailedMatchCodes) &&
        Objects.equals(this.dpvIndicator, addressSummary.dpvIndicator) &&
        Objects.equals(this.dpvFootNote1, addressSummary.dpvFootNote1) &&
        Objects.equals(this.dpvFootNote2, addressSummary.dpvFootNote2) &&
        Objects.equals(this.dpvVacantIndicator, addressSummary.dpvVacantIndicator) &&
        Objects.equals(this.message, addressSummary.message) &&
        Objects.equals(this.footnotes, addressSummary.footnotes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, errorMessage, status, cached, matchCode, detailedMatchCodes, dpvIndicator, dpvFootNote1, dpvFootNote2, dpvVacantIndicator, message, footnotes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddressSummary {\n");
    
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cached: ").append(toIndentedString(cached)).append("\n");
    sb.append("    matchCode: ").append(toIndentedString(matchCode)).append("\n");
    sb.append("    detailedMatchCodes: ").append(toIndentedString(detailedMatchCodes)).append("\n");
    sb.append("    dpvIndicator: ").append(toIndentedString(dpvIndicator)).append("\n");
    sb.append("    dpvFootNote1: ").append(toIndentedString(dpvFootNote1)).append("\n");
    sb.append("    dpvFootNote2: ").append(toIndentedString(dpvFootNote2)).append("\n");
    sb.append("    dpvVacantIndicator: ").append(toIndentedString(dpvVacantIndicator)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    footnotes: ").append(toIndentedString(footnotes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

