/**
 * snapCX - Address Validation APIs for commerce & retailers.
 * This set of API end points, provides real time address validations and corrections. Also do zipcode lookups etc. To invoke this API, you need to have your own private api key (aka user_key). You can always sign up for FREE plan to get user_key.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@snapcx.io
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.snapcx.avs.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.snapcx.avs.client.model.Address;
import io.snapcx.avs.client.model.AddressSummary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * AddressRecordObj
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-01-03T19:15:39.720-05:00")
public class AddressRecordObj   {
  @JsonProperty("addressSummary")
  private AddressSummary addressSummary = null;

  @JsonProperty("address")
  private List<Address> address = new ArrayList<Address>();

  public AddressRecordObj addressSummary(AddressSummary addressSummary) {
    this.addressSummary = addressSummary;
    return this;
  }

   /**
   * Get addressSummary
   * @return addressSummary
  **/
  @ApiModelProperty(example = "null", value = "")
  public AddressSummary getAddressSummary() {
    return addressSummary;
  }

  public void setAddressSummary(AddressSummary addressSummary) {
    this.addressSummary = addressSummary;
  }

  public AddressRecordObj address(List<Address> address) {
    this.address = address;
    return this;
  }

  public AddressRecordObj addAddressItem(Address addressItem) {
    this.address.add(addressItem);
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @ApiModelProperty(example = "null", value = "")
  public List<Address> getAddress() {
    return address;
  }

  public void setAddress(List<Address> address) {
    this.address = address;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddressRecordObj addressRecordObj = (AddressRecordObj) o;
    return Objects.equals(this.addressSummary, addressRecordObj.addressSummary) &&
        Objects.equals(this.address, addressRecordObj.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressSummary, address);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddressRecordObj {\n");
    
    sb.append("    addressSummary: ").append(toIndentedString(addressSummary)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

