/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.configsource;

import io.smallrye.configsource.ZooKeeperConfigException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ZooKeeperConfigSource
implements ConfigSource {
    private static final Logger logger = Logger.getLogger(ZooKeeperConfigSource.class.getName());
    private AtomicReference<CuratorFramework> curatorReference = new AtomicReference();
    private String applicationId;
    private static final String IGNORED_PREFIX = "io.smallrye.configsource.zookeeper";
    private static final String ZOOKEEPER_URL_KEY = "io.smallrye.configsource.zookeeper.url";
    private static final String APPLICATION_ID_KEY = "io.smallrye.configsource.zookeeper.applicationId";
    private static final String ZOOKEEPER_CONFIG_SOURCE_NAME = "io.smallrye.configsource.zookeeper";

    public int getOrdinal() {
        return 150;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        try {
            List children = (List)this.getCuratorClient().getChildren().forPath(this.applicationId);
            propertyNames.addAll(children);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return propertyNames;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            List children = (List)this.getCuratorClient().getChildren().forPath(this.applicationId);
            for (String key : children) {
                String value = new String((byte[])this.getCuratorClient().getData().forPath(this.applicationId + "/" + key));
                props.put(key, value);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return props;
    }

    public String getValue(String key) {
        if (key.startsWith("io.smallrye.configsource.zookeeper")) {
            return null;
        }
        try {
            Stat stat = (Stat)this.getCuratorClient().checkExists().forPath(this.applicationId + "/" + key);
            if (stat != null) {
                return new String((byte[])this.getCuratorClient().getData().forPath(this.applicationId + "/" + key));
            }
            return null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String getName() {
        return "io.smallrye.configsource.zookeeper";
    }

    private CuratorFramework getCuratorClient() throws ZooKeeperConfigException {
        CuratorFramework cachedClient = this.curatorReference.get();
        if (cachedClient == null) {
            Config cfg = ConfigProvider.getConfig();
            Optional zookeeperUrl = cfg.getOptionalValue(ZOOKEEPER_URL_KEY, String.class);
            Optional optApplicationId = cfg.getOptionalValue(APPLICATION_ID_KEY, String.class);
            if (zookeeperUrl.isPresent() && optApplicationId.isPresent()) {
                logger.info("Configuring ZooKeeperConfigSource using url: " + zookeeperUrl + ", applicationId: " + (String)optApplicationId.get());
                this.applicationId = (String)optApplicationId.get();
                if (!this.applicationId.startsWith("/")) {
                    this.applicationId = "/" + this.applicationId;
                }
                cachedClient = CuratorFrameworkFactory.newClient((String)((String)zookeeperUrl.get()), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
                this.curatorReference.compareAndSet(null, cachedClient);
                cachedClient.start();
            } else {
                throw new ZooKeeperConfigException("Please set properties for \"io.smallrye.configsource.zookeeper.url\" and \"io.smallrye.configsource.zookeeper.applicationId\"");
            }
        }
        return cachedClient;
    }
}

