/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.powerannotations.utils.jandex;

import com.github.t1.annotations.AmbiguousAnnotationResolutionException;
import com.github.t1.annotations.Annotations;
import com.github.t1.annotations.AnnotationsLoader;
import com.github.t1.powerannotations.common.CommonUtils;
import com.github.t1.powerannotations.common.Jandex;
import com.github.t1.powerannotations.scanner.IndexBuilder;
import com.github.t1.powerannotations.utils.jandex.AnnotationProxy;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexAnnotationsLoader
extends AnnotationsLoader {
    static final Index jandex = IndexBuilder.loadOrScan();

    public Annotations onType(Class<?> type) {
        final ClassInfo classInfo = this.getClassInfo(type);
        return new Annotations(){

            public Stream<Annotation> all() {
                return classInfo.classAnnotations().stream().flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }

            public <T extends Annotation> Optional<T> get(Class<T> type) {
                return (Optional)this.all(type).collect(JandexAnnotationsLoader.toOptionalOrThrow());
            }

            public <T extends Annotation> Stream<T> all(Class<T> type) {
                DotName typeName = CommonUtils.toDotName(type);
                return classInfo.classAnnotations().stream().flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).filter(annotationInstance -> annotationInstance.name().equals((Object)typeName)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }
        };
    }

    public Annotations onField(Class<?> type, String fieldName) {
        ClassInfo classInfo = this.getClassInfo(type);
        final FieldInfo fieldInfo = classInfo.field(fieldName);
        if (fieldInfo == null) {
            throw new RuntimeException("no field '" + fieldName + "' in class " + classInfo.name());
        }
        return new Annotations(){

            public Stream<Annotation> all() {
                return fieldInfo.annotations().stream().flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }

            public <T extends Annotation> Optional<T> get(Class<T> type) {
                return (Optional)this.all(type).collect(JandexAnnotationsLoader.toOptionalOrThrow());
            }

            public <T extends Annotation> Stream<T> all(Class<T> type) {
                DotName typeName = CommonUtils.toDotName(type);
                return fieldInfo.annotations().stream().flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).filter(annotationInstance -> annotationInstance.name().equals((Object)typeName)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }
        };
    }

    public Annotations onMethod(Class<?> type, String methodName, Class<?> ... argTypes) {
        Type[] jandexArgTypes;
        ClassInfo classInfo = this.getClassInfo(type);
        final MethodInfo methodInfo = classInfo.method(methodName, jandexArgTypes = (Type[])Stream.of(argTypes).map(Class::getName).map(JandexAnnotationsLoader::createClassType).toArray(Type[]::new));
        if (methodInfo == null) {
            String[] argTypeNames = (String[])Stream.of(argTypes).map(Class::getName).toArray(String[]::new);
            throw new RuntimeException("no method " + CommonUtils.signature((String)methodName, (String[])argTypeNames) + " in class " + classInfo.name());
        }
        return new Annotations(){

            public Stream<Annotation> all() {
                return methodInfo.annotations().stream().filter(annotationInstance -> annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD).flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }

            public <T extends Annotation> Optional<T> get(Class<T> type) {
                return (Optional)this.all(type).collect(JandexAnnotationsLoader.toOptionalOrThrow());
            }

            public <T extends Annotation> Stream<T> all(Class<T> type) {
                DotName typeName = CommonUtils.toDotName(type);
                return methodInfo.annotations().stream().flatMap(x$0 -> JandexAnnotationsLoader.resolveRepeatableAnnotations(x$0)).filter(annotationInstance -> annotationInstance.name().equals((Object)typeName)).map(x$0 -> (Annotation)JandexAnnotationsLoader.proxy(x$0));
            }
        };
    }

    private static Stream<AnnotationInstance> resolveRepeatableAnnotations(AnnotationInstance annotationInstance) {
        return new Jandex(jandex).isRepeatedAnnotation(annotationInstance) ? JandexAnnotationsLoader.resolveRepeatableAnnotationsDo(annotationInstance) : Stream.of(annotationInstance);
    }

    private static Stream<AnnotationInstance> resolveRepeatableAnnotationsDo(AnnotationInstance annotationInstance) {
        return Stream.of(annotationInstance.value().asNestedArray());
    }

    private ClassInfo getClassInfo(Class<?> type) {
        ClassInfo classInfo = jandex.getClassByName(CommonUtils.toDotName(type));
        if (classInfo == null) {
            throw new RuntimeException("class not found in index: " + type.getName());
        }
        return classInfo;
    }

    private static Type createClassType(String name) {
        return Type.create((DotName)DotName.createSimple((String)name), (Type.Kind)Type.Kind.CLASS);
    }

    private static <T> T proxy(AnnotationInstance annotationInstance) {
        return (T)AnnotationProxy.proxy(annotationInstance);
    }

    private static <T> Collector<T, ?, Optional<T>> toOptionalOrThrow() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, list -> {
            switch (list.size()) {
                case 0: {
                    return Optional.empty();
                }
                case 1: {
                    return Optional.of(list.get(0));
                }
            }
            throw new AmbiguousAnnotationResolutionException("expected one element maximum, but found " + list);
        }, new Collector.Characteristics[0]);
    }
}

