/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.annotations;

import com.github.t1.annotations.AnnotationsLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;

public interface Annotations {
    public static Annotations on(Class<?> type) {
        return AnnotationsLoader.INSTANCE.onType(type);
    }

    public static Annotations on(Field field) {
        return Annotations.onField(field.getDeclaringClass(), field.getName());
    }

    public static Annotations onField(Class<?> type, String fieldName) {
        return AnnotationsLoader.INSTANCE.onField(type, fieldName);
    }

    public static Annotations on(Method method) {
        return Annotations.onMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    public static Annotations onMethod(Class<?> type, String methodName, Class<?> ... argTypes) {
        return AnnotationsLoader.INSTANCE.onMethod(type, methodName, argTypes);
    }

    public Stream<Annotation> all();

    public <T extends Annotation> Optional<T> get(Class<T> var1);

    public <T extends Annotation> Stream<T> all(Class<T> var1);
}

