/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ParameterProcessor;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class JandexUtil {
    private static final String JAXRS_PACKAGE = "javax.ws.rs";
    private static final Pattern componentKeyPattern = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+$");

    private JandexUtil() {
    }

    public static String refValue(AnnotationInstance annotation, RefType refType) {
        AnnotationValue value = annotation.value("ref");
        if (value == null) {
            return null;
        }
        String $ref = value.asString();
        if (!componentKeyPattern.matcher($ref).matches()) {
            return $ref;
        }
        if (refType == null) {
            throw new NullPointerException("RefType must not be null");
        }
        $ref = "#/components/" + refType.componentPath + "/" + $ref;
        return $ref;
    }

    public static <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (isArray ? value.componentKind() : value.kind()) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public static String stringValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public static Boolean booleanValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asBoolean();
    }

    public static Boolean booleanValueWithDefault(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        return value != null && value.asBoolean();
    }

    public static BigDecimal bigDecimalValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        if (value.kind() == AnnotationValue.Kind.DOUBLE) {
            return BigDecimal.valueOf(value.asDouble());
        }
        if (value.kind() == AnnotationValue.Kind.STRING) {
            return new BigDecimal(value.asString());
        }
        throw new RuntimeException("Call to bigDecimalValue failed because the annotation property was not a double or a String.");
    }

    public static Integer intValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asInt();
    }

    public static List<String> stringListValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(value.asStringArray()));
    }

    public static <T extends Enum> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        Enum[] constants;
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        String strVal = value.asString();
        for (Enum t : constants = (Enum[])clazz.getEnumConstants()) {
            if (!t.toString().equals(strVal)) continue;
            return (T)t;
        }
        for (Enum t : constants) {
            if (!t.name().equalsIgnoreCase(strVal)) continue;
            return (T)t;
        }
        return null;
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return annotation.value("ref") != null;
    }

    public static boolean isEmpty(AnnotationInstance annotation) {
        return annotation.values() == null || annotation.values().isEmpty();
    }

    public static AnnotationInstance getClassAnnotation(ClassInfo ct, DotName name) {
        if (name == null) {
            return null;
        }
        Collection annotations = ct.classAnnotations();
        for (AnnotationInstance annotationInstance : annotations) {
            if (!annotationInstance.name().equals((Object)name)) continue;
            return annotationInstance;
        }
        return null;
    }

    public static Collection<ClassInfo> getJaxRsResourceClasses(IndexView index) {
        ArrayList<ClassInfo> resourceClasses = new ArrayList<ClassInfo>();
        Collection pathAnnotations = index.getAnnotations(OpenApiConstants.DOTNAME_PATH);
        for (AnnotationInstance pathAnno : pathAnnotations) {
            AnnotationTarget annotationTarget = pathAnno.target();
            if (annotationTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = (ClassInfo)annotationTarget;
            if (Modifier.isInterface(classInfo.flags())) {
                if (!index.getAllKnownImplementors(classInfo.name()).stream().anyMatch(info -> !Modifier.isAbstract(info.flags()))) continue;
                resourceClasses.add(annotationTarget.asClass());
                continue;
            }
            resourceClasses.add(annotationTarget.asClass());
        }
        return resourceClasses;
    }

    public static List<AnnotationInstance> getParameterAnnotations(MethodInfo method, short paramPosition) {
        return method.annotations().stream().filter(annotation -> {
            AnnotationTarget target = annotation.target();
            return target != null && target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER && target.asMethodParameter().position() == paramPosition;
        }).collect(Collectors.toList());
    }

    public static String nameFromRef(AnnotationInstance annotation) {
        String ref = annotation.value("ref").asString();
        return ModelUtil.nameFromRef(ref);
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(MethodInfo method, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationInstance annotation2;
        AnnotationValue annotationValue;
        List<AnnotationInstance> annotations = method.annotations().stream().filter(annotation -> annotation.name().equals((Object)singleAnnotationName)).collect(Collectors.toList());
        if (repeatableAnnotationName != null && method.hasAnnotation(repeatableAnnotationName) && (annotationValue = (annotation2 = method.annotation(repeatableAnnotationName)).value()) != null) {
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            annotations.addAll(Arrays.asList(nestedArray));
        }
        return annotations;
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(ClassInfo clazz, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationValue annotationValue;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        AnnotationInstance single = JandexUtil.getClassAnnotation(clazz, singleAnnotationName);
        AnnotationInstance repeatable = JandexUtil.getClassAnnotation(clazz, repeatableAnnotationName);
        if (single != null) {
            annotations.add(single);
        }
        if (repeatable != null && (annotationValue = repeatable.value()) != null) {
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            annotations.addAll(Arrays.asList(nestedArray));
        }
        return annotations;
    }

    public static Type getMethodParameterType(MethodInfo method, short position) {
        Type type = (Type)method.parameters().get(position);
        return type;
    }

    public static Type getMethodParameterType(MethodParameterInfo parameter) {
        Type type = (Type)parameter.method().parameters().get(parameter.position());
        return type;
    }

    public static Type getRequestBodyParameterClassType(MethodInfo method, List<AnnotationScannerExtension> extensions) {
        List methodParams = method.parameters();
        if (methodParams.isEmpty()) {
            return null;
        }
        for (short i = 0; i < methodParams.size(); i = (short)(i + 1)) {
            List<AnnotationInstance> parameterAnnotations = JandexUtil.getParameterAnnotations(method, i);
            if (!parameterAnnotations.isEmpty() && JandexUtil.containsJaxRsAnnotations(parameterAnnotations, extensions)) continue;
            return (Type)methodParams.get(i);
        }
        return null;
    }

    private static boolean containsJaxRsAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (ParameterProcessor.JaxRsParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(JAXRS_PACKAGE)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isJaxRsAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public static AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != parameterIndex || !annotation.name().equals((Object)annotationName)) continue;
            return annotation;
        }
        return null;
    }

    public static boolean isSimpleClassSchema(AnnotationInstance annotation) {
        List values = annotation.values();
        return values.size() == 1 && ((AnnotationValue)values.get(0)).name().equals("implementation");
    }

    public static boolean isSimpleArraySchema(AnnotationInstance annotation) {
        List values = annotation.values();
        if (values.size() != 2) {
            return false;
        }
        Schema.SchemaType type = JandexUtil.enumValue(annotation, "type", Schema.SchemaType.class);
        String implementation = JandexUtil.stringValue(annotation, "implementation");
        return type == Schema.SchemaType.ARRAY && implementation != null;
    }

    @Deprecated
    public static class JaxRsParameterInfo {
        public String name;
        public Parameter.In in;
    }

    public static enum RefType {
        Header("headers"),
        Schema("schemas"),
        SecurityScheme("securitySchemes"),
        Callback("callbacks"),
        Link("links"),
        Response("responses"),
        Parameter("parameters"),
        Example("examples"),
        RequestBody("requestBodies");

        String componentPath;

        private RefType(String componentPath) {
            this.componentPath = componentPath;
        }
    }
}

