/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class SchemaFactory {
    private SchemaFactory() {
    }

    public static Schema readSchema(IndexView index, Schema schema, AnnotationInstance annotation, Map<String, Object> overrides) {
        if (annotation == null) {
            return schema;
        }
        Boolean isHidden = JandexUtil.booleanValue(annotation, "hidden");
        if (isHidden != null && isHidden == Boolean.TRUE) {
            return schema;
        }
        schema.setNot((Schema)overrides.getOrDefault("not", SchemaFactory.readClassSchema(index, annotation.value("not"))));
        schema.setOneOf(overrides.getOrDefault("oneOf", SchemaFactory.readClassSchemas(index, annotation.value("oneOf"))));
        schema.setAnyOf(overrides.getOrDefault("anyOf", SchemaFactory.readClassSchemas(index, annotation.value("anyOf"))));
        schema.setAllOf(overrides.getOrDefault("allOf", SchemaFactory.readClassSchemas(index, annotation.value("allOf"))));
        schema.setTitle((String)overrides.getOrDefault("title", JandexUtil.stringValue(annotation, "title")));
        schema.setMultipleOf((BigDecimal)overrides.getOrDefault("multipleOf", JandexUtil.bigDecimalValue(annotation, "multipleOf")));
        schema.setMaximum((BigDecimal)overrides.getOrDefault("maximum", JandexUtil.bigDecimalValue(annotation, "maximum")));
        schema.setExclusiveMaximum((Boolean)overrides.getOrDefault("exclusiveMaximum", JandexUtil.booleanValue(annotation, "exclusiveMaximum")));
        schema.setMinimum((BigDecimal)overrides.getOrDefault("minimum", JandexUtil.bigDecimalValue(annotation, "minimum")));
        schema.setExclusiveMinimum((Boolean)overrides.getOrDefault("exclusiveMinimum", JandexUtil.booleanValue(annotation, "exclusiveMinimum")));
        schema.setMaxLength((Integer)overrides.getOrDefault("maxLength", JandexUtil.intValue(annotation, "maxLength")));
        schema.setMinLength((Integer)overrides.getOrDefault("minLength", JandexUtil.intValue(annotation, "minLength")));
        schema.setPattern((String)overrides.getOrDefault("pattern", JandexUtil.stringValue(annotation, "pattern")));
        schema.setMaxProperties((Integer)overrides.getOrDefault("maxProperties", JandexUtil.intValue(annotation, "maxProperties")));
        schema.setMinProperties((Integer)overrides.getOrDefault("minProperties", JandexUtil.intValue(annotation, "minProperties")));
        schema.setRequired(overrides.getOrDefault("requiredProperties", JandexUtil.stringListValue(annotation, "requiredProperties")));
        schema.setDescription((String)overrides.getOrDefault("description", JandexUtil.stringValue(annotation, "description")));
        schema.setFormat((String)overrides.getOrDefault("format", JandexUtil.stringValue(annotation, "format")));
        schema.setRef((String)overrides.getOrDefault("ref", JandexUtil.stringValue(annotation, "ref")));
        schema.setNullable((Boolean)overrides.getOrDefault("nullable", JandexUtil.booleanValue(annotation, "nullable")));
        schema.setReadOnly((Boolean)overrides.getOrDefault("readOnly", JandexUtil.booleanValue(annotation, "readOnly")));
        schema.setWriteOnly((Boolean)overrides.getOrDefault("writeOnly", JandexUtil.booleanValue(annotation, "writeOnly")));
        schema.setExample(overrides.getOrDefault("example", JandexUtil.stringValue(annotation, "example")));
        schema.setExternalDocs(SchemaFactory.readExternalDocs(annotation.value("externalDocs")));
        schema.setDeprecated((Boolean)overrides.getOrDefault("deprecated", JandexUtil.booleanValue(annotation, "deprecated")));
        schema.setType((Schema.SchemaType)overrides.getOrDefault("type", JandexUtil.enumValue(annotation, "type", Schema.SchemaType.class)));
        schema.setEnumeration(overrides.getOrDefault("enum", JandexUtil.stringListValue(annotation, "enum")));
        schema.setDefaultValue(overrides.getOrDefault("defaultValue", JandexUtil.stringValue(annotation, "defaultValue")));
        schema.setMaxItems((Integer)overrides.getOrDefault("maxItems", JandexUtil.intValue(annotation, "maxItems")));
        schema.setMinItems((Integer)overrides.getOrDefault("minItems", JandexUtil.intValue(annotation, "minItems")));
        schema.setUniqueItems((Boolean)overrides.getOrDefault("uniqueItems", JandexUtil.booleanValue(annotation, "uniqueItems")));
        Schema implSchema = SchemaFactory.readClassSchema(index, annotation.value("implementation"));
        if (schema.getType() == Schema.SchemaType.ARRAY && implSchema != null) {
            schema.setItems(implSchema);
        } else {
            schema = MergeUtil.mergeObjects(implSchema, schema);
        }
        return schema;
    }

    private static Schema readClassSchema(IndexView index, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        ClassType ctype = (ClassType)value.asClass();
        return SchemaFactory.introspectClassToSchema(index, ctype);
    }

    private static Schema introspectClassToSchema(IndexView index, ClassType ctype) {
        return OpenApiDataObjectScanner.process(index, (Type)ctype);
    }

    private static List<Schema> readClassSchemas(IndexView index, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        Type[] classArray = value.asClassArray();
        ArrayList<Schema> schemas = new ArrayList<Schema>(classArray.length);
        for (Type type : classArray) {
            ClassType ctype = (ClassType)type;
            Schema schema = SchemaFactory.introspectClassToSchema(index, ctype);
            schemas.add(schema);
        }
        return schemas;
    }

    private static ExternalDocumentation readExternalDocs(AnnotationValue externalDocAnno) {
        if (externalDocAnno == null) {
            return null;
        }
        AnnotationInstance nested = externalDocAnno.asNested();
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JandexUtil.stringValue(nested, "description"));
        externalDoc.setUrl(JandexUtil.stringValue(nested, "url"));
        return externalDoc;
    }
}

