/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.ui;

import io.smallrye.openapi.ui.Option;
import io.smallrye.openapi.ui.ThemeHref;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexCreator {
    private static final List<Option> BOOLEAN_OR_STRING_KEYS = Arrays.asList(Option.filter, Option.syntaxHighlight);
    private static final List<Option> STRING_ARRAY_KEYS = Arrays.asList(Option.supportedSubmitMethods);
    private static final String VAR_BEGIN = "${";
    private static final String VAR_END = "}";
    private static final Map<Option, String> DEFAULT_OPTIONS = new HashMap<Option, String>();
    private static final String DEFAULT_URLS_PRIMARY_NAME = "Default";
    private static final String URL_FORMAT = "url: '%s'";
    private static final String URLS_ENTRY_FORMAT = "{url: \"%s\", name: \"%s\"}";

    private IndexCreator() {
    }

    public static byte[] createIndexHtml() throws IOException {
        return IndexCreator.createIndexHtml(null);
    }

    public static byte[] createIndexHtml(Map<Option, String> options) throws IOException {
        return IndexCreator.createIndexHtml(null, null, options);
    }

    /*
     * Exception decompiling
     */
    public static byte[] createIndexHtml(Map<String, String> urls, String urlsPrimaryName, Map<Option, String> options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String replace(String line, Map<String, String> urls, String urlsPrimaryName, Map<Option, String> options) {
        Option variableOption;
        if (line.contains(VAR_BEGIN) && (variableOption = IndexCreator.getVariable(line)) != null) {
            if (options != null && options.containsKey((Object)variableOption)) {
                String replacement = options.get((Object)variableOption);
                if (replacement == null) {
                    return null;
                }
                replacement = replacement.trim();
                if (BOOLEAN_OR_STRING_KEYS.contains((Object)variableOption) && !replacement.equals("true") && !replacement.equals("false")) {
                    replacement = "'" + replacement + "'";
                }
                if (STRING_ARRAY_KEYS.contains((Object)variableOption)) {
                    String[] parts;
                    ArrayList<String> newArray = new ArrayList<String>();
                    for (String part : parts = replacement.replace("[", "").replace("]", "").split(",")) {
                        newArray.add("'" + part.trim() + "'");
                    }
                    replacement = Arrays.toString(newArray.toArray(new String[0]));
                }
                line = line.replace(VAR_BEGIN + (Object)((Object)variableOption) + VAR_END, replacement);
            }
            return IndexCreator.replace(line, urls, urlsPrimaryName, options);
        }
        return line;
    }

    private static Option getVariable(String line) {
        try {
            String stringValue = line.substring(line.indexOf(VAR_BEGIN) + 2, line.indexOf(VAR_END));
            return Option.valueOf(stringValue);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private static Map<Option, String> populateDefaults(Map<Option, String> options) {
        if (options == null) {
            options = new HashMap<Option, String>(DEFAULT_OPTIONS);
        } else {
            for (Map.Entry<Option, String> defaultVar : DEFAULT_OPTIONS.entrySet()) {
                if (options.containsKey((Object)defaultVar.getKey())) continue;
                options.put(defaultVar.getKey(), defaultVar.getValue());
            }
        }
        return options;
    }

    private static void addUrlSection(Map<String, String> urls, String urlsPrimaryName, Map<Option, String> options) {
        if (!options.containsKey((Object)Option.urlSection)) {
            if (urls == null || urls.isEmpty()) {
                if (options.containsKey((Object)Option.url)) {
                    options.put(Option.urlSection, String.format(URL_FORMAT, options.get((Object)Option.url)));
                } else {
                    options.put(Option.urlSection, String.format(URL_FORMAT, "/openapi"));
                }
            } else if (urls.size() == 1) {
                options.put(Option.urlSection, String.format(URL_FORMAT, urls.values().iterator().next()));
            } else {
                Set<Map.Entry<String, String>> urlsSet = urls.entrySet();
                ArrayList<String> urlsLines = new ArrayList<String>();
                for (Map.Entry<String, String> kv : urlsSet) {
                    urlsLines.add(String.format(URLS_ENTRY_FORMAT, kv.getValue(), kv.getKey()));
                }
                String urlSection = "urls: [" + String.join((CharSequence)",", urlsLines.toArray(new String[0])) + "]";
                if (urlsPrimaryName != null) {
                    urlSection = urlSection + ",\n\t\t \"urls.primaryName\": '" + urlsPrimaryName + "'";
                }
                options.put(Option.urlSection, urlSection);
            }
        }
    }

    static {
        DEFAULT_OPTIONS.put(Option.url, "/openapi");
        DEFAULT_OPTIONS.put(Option.title, "SmallRye OpenAPI UI");
        DEFAULT_OPTIONS.put(Option.selfHref, "/openapi-ui");
        DEFAULT_OPTIONS.put(Option.themeHref, ThemeHref.feeling_blue.toString());
        DEFAULT_OPTIONS.put(Option.logoHref, "logo.png");
        DEFAULT_OPTIONS.put(Option.styleHref, "style.css");
        DEFAULT_OPTIONS.put(Option.footer, null);
        DEFAULT_OPTIONS.put(Option.domId, "#swagger-ui");
        DEFAULT_OPTIONS.put(Option.deepLinking, "true");
        DEFAULT_OPTIONS.put(Option.displayOperationId, null);
        DEFAULT_OPTIONS.put(Option.defaultModelsExpandDepth, null);
        DEFAULT_OPTIONS.put(Option.defaultModelExpandDepth, null);
        DEFAULT_OPTIONS.put(Option.defaultModelRendering, null);
        DEFAULT_OPTIONS.put(Option.displayRequestDuration, null);
        DEFAULT_OPTIONS.put(Option.docExpansion, null);
        DEFAULT_OPTIONS.put(Option.filter, null);
        DEFAULT_OPTIONS.put(Option.maxDisplayedTags, null);
        DEFAULT_OPTIONS.put(Option.operationsSorter, null);
        DEFAULT_OPTIONS.put(Option.showExtensions, null);
        DEFAULT_OPTIONS.put(Option.showCommonExtensions, null);
        DEFAULT_OPTIONS.put(Option.tagsSorter, null);
        DEFAULT_OPTIONS.put(Option.onComplete, null);
        DEFAULT_OPTIONS.put(Option.syntaxHighlight, null);
        DEFAULT_OPTIONS.put(Option.oauth2RedirectUrl, null);
        DEFAULT_OPTIONS.put(Option.requestInterceptor, null);
        DEFAULT_OPTIONS.put(Option.requestCurlOptions, null);
        DEFAULT_OPTIONS.put(Option.responseInterceptor, null);
        DEFAULT_OPTIONS.put(Option.showMutatedRequest, null);
        DEFAULT_OPTIONS.put(Option.supportedSubmitMethods, null);
        DEFAULT_OPTIONS.put(Option.validatorUrl, null);
        DEFAULT_OPTIONS.put(Option.withCredentials, null);
        DEFAULT_OPTIONS.put(Option.modelPropertyMacro, null);
        DEFAULT_OPTIONS.put(Option.parameterMacro, null);
        DEFAULT_OPTIONS.put(Option.persistAuthorization, null);
        DEFAULT_OPTIONS.put(Option.layout, "StandaloneLayout");
        DEFAULT_OPTIONS.put(Option.plugins, "[SwaggerUIBundle.plugins.DownloadUrl]");
        DEFAULT_OPTIONS.put(Option.presets, "[SwaggerUIBundle.presets.apis,SwaggerUIStandalonePreset]");
    }
}

