/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.mavenplugin.MavenDependencyIndexCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.jandex.IndexView;

@Mojo(name="generate-schema", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateSchemaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/", property="outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="openapi", property="schemaFilename")
    private String schemaFilename;
    @Parameter(defaultValue="compile,system", property="includeDependenciesScopes")
    private List<String> includeDependenciesScopes;
    @Parameter(defaultValue="jar", property="includeDependenciesTypes")
    private List<String> includeDependenciesTypes;
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="scanDependenciesDisable")
    private boolean scanDependenciesDisable;
    @Parameter(defaultValue="false", property="attachArtifacts")
    private boolean attachArtifacts;
    @Parameter(property="configProperties")
    private File configProperties;
    @Parameter(property="modelReader")
    private String modelReader;
    @Parameter(property="filter")
    private String filter;
    @Parameter(property="scanDisabled")
    private Boolean scanDisabled;
    @Parameter(property="scanPackages")
    private String scanPackages;
    @Parameter(property="scanClasses")
    private String scanClasses;
    @Parameter(property="scanExcludePackages")
    private String scanExcludePackages;
    @Parameter(property="scanExcludeClasses")
    private String scanExcludeClasses;
    @Parameter(property="servers")
    private List<String> servers;
    @Parameter(property="pathServers")
    private List<String> pathServers;
    @Parameter(property="operationServers")
    private List<String> operationServers;
    @Parameter(property="customSchemaRegistryClass")
    private String customSchemaRegistryClass;
    @Parameter(defaultValue="false", property="applicationPathDisable")
    private Boolean applicationPathDisable;
    @Parameter(defaultValue="3.0.3", property="openApiVersion")
    private String openApiVersion;
    @Parameter(property="infoTitle")
    private String infoTitle;
    @Parameter(property="infoVersion")
    private String infoVersion;
    @Parameter(property="infoDescription")
    private String infoDescription;
    @Parameter(property="infoTermsOfService")
    private String infoTermsOfService;
    @Parameter(property="infoContactEmail")
    private String infoContactEmail;
    @Parameter(property="infoContactName")
    private String infoContactName;
    @Parameter(property="infoContactUrl")
    private String infoContactUrl;
    @Parameter(property="infoLicenseName")
    private String infoLicenseName;
    @Parameter(property="infoLicenseUrl")
    private String infoLicenseUrl;
    @Parameter(property="operationIdStrategy")
    private String operationIdStrategy;
    @Parameter(property="scanProfiles")
    private List<String> scanProfiles;
    @Parameter(property="scanExcludeProfiles")
    private List<String> scanExcludeProfiles;
    @Parameter(property="encoding")
    private String encoding;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter(property="scanResourceClasses")
    private Map<String, String> scanResourceClasses;
    @Parameter(property="outputFileTypeFilter", defaultValue="ALL")
    private String outputFileTypeFilter;
    @Component
    private MavenDependencyIndexCreator mavenDependencyIndexCreator;
    @Component
    MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            try {
                IndexView index = this.mavenDependencyIndexCreator.createIndex(this.mavenProject, this.scanDependenciesDisable, this.includeDependenciesScopes, this.includeDependenciesTypes);
                SmallRyeOpenAPI openAPI = this.generateOpenAPI(index);
                this.write(openAPI);
            }
            catch (Exception ex) {
                this.getLog().error((Throwable)ex);
                throw new MojoExecutionException("Could not generate OpenAPI Schema", ex);
            }
        }
    }

    private SmallRyeOpenAPI generateOpenAPI(IndexView index) throws IOException, DependencyResolutionRequiredException {
        if (this.systemPropertyVariables != null) {
            this.systemPropertyVariables.forEach(System::setProperty);
        }
        SmallRyeConfig config = new SmallRyeConfigBuilder().addDefaultSources().withSources(new ConfigSource[]{new PropertiesConfigSource(this.getProperties(), "maven-plugin", 100)}).build();
        return SmallRyeOpenAPI.builder().withConfig((Config)config).withApplicationClassLoader(this.getClassLoader()).withIndex(index).build();
    }

    private ClassLoader getClassLoader() throws DependencyResolutionRequiredException {
        HashSet<URI> elements = new HashSet<URI>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Adding directories/artifacts to annotation scanner class loader:");
        }
        for (String element : this.mavenProject.getCompileClasspathElements()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("  " + element));
            }
            elements.add(new File(element).toURI());
        }
        URL[] locators = (URL[])elements.stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException mue) {
                throw new UncheckedIOException(mue);
            }
        }).toArray(URL[]::new);
        return URLClassLoader.newInstance(locators, Thread.currentThread().getContextClassLoader());
    }

    private Map<String, String> getProperties() throws IOException {
        HashMap<String, String> cp = new HashMap<String, String>();
        if (this.configProperties != null && this.configProperties.exists()) {
            Properties p = new Properties();
            try (InputStream is = Files.newInputStream(this.configProperties.toPath(), new OpenOption[0]);){
                p.load(is);
                p.stringPropertyNames().forEach(k -> cp.put((String)k, p.getProperty((String)k)));
            }
        }
        this.addToPropertyMap(cp, "mp.openapi.model.reader", this.modelReader);
        this.addToPropertyMap(cp, "mp.openapi.filter", this.filter);
        this.addToPropertyMap(cp, "mp.openapi.scan.disable", this.scanDisabled);
        this.addToPropertyMap(cp, "mp.openapi.scan.packages", this.scanPackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.classes", this.scanClasses);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.packages", this.scanExcludePackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.classes", this.scanExcludeClasses);
        this.addToPropertyMap(cp, "mp.openapi.servers", this.servers);
        this.addToPropertyMap(cp, "mp.openapi.servers.path.", this.pathServers);
        this.addToPropertyMap(cp, "mp.openapi.servers.operation.", this.operationServers);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan-dependencies.disable", this.scanDependenciesDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.custom-schema-registry.class", this.customSchemaRegistryClass);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.application-path.disable", this.applicationPathDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.openapi", this.openApiVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.title", this.infoTitle);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.version", this.infoVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.description", this.infoDescription);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.termsOfService", this.infoTermsOfService);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.email", this.infoContactEmail);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.name", this.infoContactName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.url", this.infoContactUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.name", this.infoLicenseName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.url", this.infoLicenseUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.operationIdStrategy", this.operationIdStrategy);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.profiles", this.scanProfiles);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.exclude.profiles", this.scanExcludeProfiles);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.resource-class.", this.scanResourceClasses);
        return cp;
    }

    private void addToPropertyMap(Map<String, String> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            map.put(key, String.join((CharSequence)",", values));
        }
    }

    private void addToPropertyMap(Map<String, String> map, String keyPrefix, Map<String, String> values) {
        if (values != null) {
            values.forEach((key, value) -> map.put(keyPrefix + key, (String)value));
        }
    }

    private void write(SmallRyeOpenAPI openAPI) throws MojoExecutionException {
        try {
            String yaml = openAPI.toYAML();
            String json = openAPI.toJSON();
            if (this.outputDirectory == null) {
                this.getLog().info((CharSequence)yaml);
            } else {
                Path directory = this.outputDirectory.toPath();
                if (!Files.exists(directory, new LinkOption[0])) {
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                Charset charset = GenerateSchemaMojo.getCharset(this.encoding);
                if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.YAML).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(this.outputFileTypeFilter)))) {
                    this.writeFile(directory, "yaml", yaml.getBytes(charset));
                }
                if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.JSON).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(this.outputFileTypeFilter)))) {
                    this.writeFile(directory, "json", json.getBytes(charset));
                }
                this.getLog().info((CharSequence)("Wrote the schema files to " + this.outputDirectory.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write the result", (Exception)e);
        }
    }

    static Charset getCharset(String encoding) throws MojoExecutionException {
        Charset charset;
        if (StringUtils.isBlank((CharSequence)encoding)) {
            return Charset.defaultCharset();
        }
        try {
            charset = Charset.forName(encoding.trim());
        }
        catch (IllegalCharsetNameException e) {
            throw new MojoExecutionException("encoding parameter does not define a legal charset name", (Exception)e);
        }
        catch (UnsupportedCharsetException e) {
            throw new MojoExecutionException("encoding parameter does not define a supported charset", (Exception)e);
        }
        return charset;
    }

    private void writeFile(Path directory, String type, byte[] contents) throws IOException {
        Path file = Paths.get(directory.toString(), this.schemaFilename + "." + type);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, contents, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        if (this.attachArtifacts) {
            this.mavenProjectHelper.attachArtifact(this.mavenProject, type, this.schemaFilename, file.toFile());
        }
    }

    static enum OutputFileFilter {
        ALL,
        YAML,
        JSON;

    }
}

