/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.mavenplugin.MavenConfig;
import io.smallrye.openapi.mavenplugin.MavenDependencyIndexCreator;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

@Mojo(name="generate-schema", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateSchemaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/", property="outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="openapi", property="schemaFilename")
    private String schemaFilename;
    @Parameter(defaultValue="compile,system", property="includeDependenciesScopes")
    private List<String> includeDependenciesScopes;
    @Parameter(defaultValue="jar", property="includeDependenciesTypes")
    private List<String> includeDependenciesTypes;
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="scanDependenciesDisable")
    private boolean scanDependenciesDisable;
    @Parameter(defaultValue="false", property="attachArtifacts")
    private boolean attachArtifacts;
    @Parameter(property="configProperties")
    private File configProperties;
    @Parameter(property="modelReader")
    private String modelReader;
    @Parameter(property="filter")
    private String filter;
    @Parameter(property="scanDisabled")
    private Boolean scanDisabled;
    @Parameter(property="scanPackages")
    private String scanPackages;
    @Parameter(property="scanClasses")
    private String scanClasses;
    @Parameter(property="scanExcludePackages")
    private String scanExcludePackages;
    @Parameter(property="scanExcludeClasses")
    private String scanExcludeClasses;
    @Parameter(property="servers")
    private List<String> servers;
    @Parameter(property="pathServers")
    private List<String> pathServers;
    @Parameter(property="operationServers")
    private List<String> operationServers;
    @Parameter(property="customSchemaRegistryClass")
    private String customSchemaRegistryClass;
    @Parameter(defaultValue="false", property="applicationPathDisable")
    private Boolean applicationPathDisable;
    @Parameter(defaultValue="3.0.3", property="openApiVersion")
    private String openApiVersion;
    @Parameter(property="infoTitle")
    private String infoTitle;
    @Parameter(property="infoVersion")
    private String infoVersion;
    @Parameter(property="infoDescription")
    private String infoDescription;
    @Parameter(property="infoTermsOfService")
    private String infoTermsOfService;
    @Parameter(property="infoContactEmail")
    private String infoContactEmail;
    @Parameter(property="infoContactName")
    private String infoContactName;
    @Parameter(property="infoContactUrl")
    private String infoContactUrl;
    @Parameter(property="infoLicenseName")
    private String infoLicenseName;
    @Parameter(property="infoLicenseUrl")
    private String infoLicenseUrl;
    @Parameter(property="operationIdStrategy")
    private String operationIdStrategy;
    @Parameter(property="scanProfiles")
    private List<String> scanProfiles;
    @Parameter(property="scanExcludeProfiles")
    private List<String> scanExcludeProfiles;
    @Parameter(property="encoding")
    private String encoding;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Component
    private MavenDependencyIndexCreator mavenDependencyIndexCreator;
    @Component
    MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            try {
                IndexView index = this.mavenDependencyIndexCreator.createIndex(this.mavenProject, this.scanDependenciesDisable, this.includeDependenciesScopes, this.includeDependenciesTypes);
                OpenApiDocument schema = this.generateSchema(index);
                this.write(schema);
            }
            catch (Exception ex) {
                this.getLog().error((Throwable)ex);
                throw new MojoExecutionException("Could not generate OpenAPI Schema", ex);
            }
        }
    }

    private OpenApiDocument generateSchema(IndexView index) throws IOException, DependencyResolutionRequiredException {
        if (this.systemPropertyVariables != null) {
            this.systemPropertyVariables.forEach(System::setProperty);
        }
        MavenConfig openApiConfig = new MavenConfig(this.getProperties());
        ClassLoader classLoader = this.getClassLoader();
        OpenAPI staticModel = this.generateStaticModel();
        OpenAPI annotationModel = this.generateAnnotationModel(index, openApiConfig, classLoader);
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)classLoader);
        OpenApiDocument document = OpenApiDocument.newInstance();
        document.reset();
        document.config((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        if (readerModel != null) {
            document.modelFromReader(readerModel);
        }
        if (staticModel != null) {
            document.modelFromStaticFile(staticModel);
        }
        document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)classLoader));
        document.initialize();
        return document;
    }

    private ClassLoader getClassLoader() throws MalformedURLException, DependencyResolutionRequiredException {
        HashSet<URL> urls = new HashSet<URL>();
        for (String element : this.mavenProject.getCompileClasspathElements()) {
            this.getLog().debug((CharSequence)("Adding " + element + " to annotation scanner class loader"));
            urls.add(new File(element).toURI().toURL());
        }
        return URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, OpenApiConfig openApiConfig, ClassLoader classLoader) {
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner(openApiConfig, classLoader, indexView);
        return openApiAnnotationScanner.scan(new String[0]);
    }

    private OpenAPI generateStaticModel() throws IOException {
        Path staticFile = this.getStaticFile();
        if (staticFile != null) {
            try (InputStream is = Files.newInputStream(staticFile, new OpenOption[0]);){
                OpenAPI openAPI;
                try (OpenApiStaticFile openApiStaticFile = new OpenApiStaticFile(is, this.getFormat(staticFile));){
                    openAPI = OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)openApiStaticFile);
                }
                return openAPI;
            }
        }
        return null;
    }

    private Path getStaticFile() {
        Path classesPath = new File(this.mavenProject.getBuild().getOutputDirectory()).toPath();
        if (Files.exists(classesPath, new LinkOption[0])) {
            Path resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
        }
        return null;
    }

    private Format getFormat(Path path) {
        if (path.endsWith(".json")) {
            return Format.JSON;
        }
        return Format.YAML;
    }

    private Map<String, String> getProperties() throws IOException {
        HashMap<String, String> cp = new HashMap<String, String>();
        if (this.configProperties != null && this.configProperties.exists()) {
            Properties p = new Properties();
            try (InputStream is = Files.newInputStream(this.configProperties.toPath(), new OpenOption[0]);){
                p.load(is);
                cp.putAll(p);
            }
        }
        this.addToPropertyMap(cp, "mp.openapi.model.reader", this.modelReader);
        this.addToPropertyMap(cp, "mp.openapi.filter", this.filter);
        this.addToPropertyMap(cp, "mp.openapi.scan.disable", this.scanDisabled);
        this.addToPropertyMap(cp, "mp.openapi.scan.packages", this.scanPackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.classes", this.scanClasses);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.packages", this.scanExcludePackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.classes", this.scanExcludeClasses);
        this.addToPropertyMap(cp, "mp.openapi.servers", this.servers);
        this.addToPropertyMap(cp, "mp.openapi.servers.path.", this.pathServers);
        this.addToPropertyMap(cp, "mp.openapi.servers.operation.", this.operationServers);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan-dependencies.disable", this.scanDependenciesDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.custom-schema-registry.class", this.customSchemaRegistryClass);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.application-path.disable", this.applicationPathDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.openapi", this.openApiVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.title", this.infoTitle);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.version", this.infoVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.description", this.infoDescription);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.termsOfService", this.infoTermsOfService);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.email", this.infoContactEmail);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.name", this.infoContactName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.url", this.infoContactUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.name", this.infoLicenseName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.url", this.infoLicenseUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.operationIdStrategy", this.operationIdStrategy);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.profiles", this.scanProfiles);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.exclude.profiles", this.scanExcludeProfiles);
        return cp;
    }

    private void addToPropertyMap(Map<String, String> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            map.put(key, String.join((CharSequence)",", values));
        }
    }

    private void write(OpenApiDocument schema) throws MojoExecutionException {
        block8: {
            try {
                String yaml = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.YAML);
                String json = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.JSON);
                if (this.outputDirectory == null) {
                    this.getLog().info((CharSequence)yaml);
                    break block8;
                }
                Path directory = this.outputDirectory.toPath();
                if (!Files.exists(directory, new LinkOption[0])) {
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                Charset charset = Charset.defaultCharset();
                if (!StringUtils.isBlank((CharSequence)this.encoding)) {
                    try {
                        charset = Charset.forName(this.encoding.trim());
                    }
                    catch (IllegalCharsetNameException e) {
                        throw new MojoExecutionException("encoding parameter does not define a legal charset name", (Exception)e);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new MojoExecutionException("encoding parameter does not define a supported charset", (Exception)e);
                    }
                }
                this.writeSchemaFile(directory, "yaml", yaml.getBytes(charset));
                this.writeSchemaFile(directory, "json", json.getBytes(charset));
                this.getLog().info((CharSequence)("Wrote the schema files to " + this.outputDirectory.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't write the result", (Exception)e);
            }
        }
    }

    private void writeSchemaFile(Path directory, String type, byte[] contents) throws IOException {
        Path file = Paths.get(directory.toString(), this.schemaFilename + "." + type);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, contents, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        if (this.attachArtifacts) {
            this.mavenProjectHelper.attachArtifact(this.mavenProject, type, this.schemaFilename, file.toFile());
        }
    }
}

