/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import java.util.Map;
import java.util.Set;

public class MavenConfig
implements OpenApiConfig {
    private final Map<String, String> properties;

    public MavenConfig(Map<String, String> properties) {
        this.properties = properties;
    }

    public String modelReader() {
        return this.properties.getOrDefault("mp.openapi.model.reader", null);
    }

    public String filter() {
        return this.properties.getOrDefault("mp.openapi.filter", null);
    }

    public boolean scanDisable() {
        return Boolean.parseBoolean(this.properties.getOrDefault("mp.openapi.filter", "false"));
    }

    public Set<String> scanPackages() {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.scan.packages", null));
    }

    public Set<String> scanClasses() {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.scan.classes", null));
    }

    public Set<String> scanExcludePackages() {
        Set result = this.asCsvSet(this.properties.getOrDefault("mp.openapi.scan.exclude.packages", null));
        result.addAll(OpenApiConstants.NEVER_SCAN_PACKAGES);
        return result;
    }

    public Set<String> scanExcludeClasses() {
        Set result = this.asCsvSet(this.properties.getOrDefault("mp.openapi.scan.exclude.classes", null));
        result.addAll(OpenApiConstants.NEVER_SCAN_CLASSES);
        return result;
    }

    public Set<String> servers() {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.servers", null));
    }

    public Set<String> pathServers(String path) {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.servers.path." + path, null));
    }

    public Set<String> operationServers(String operationId) {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.servers.operation." + operationId, null));
    }

    public boolean scanDependenciesDisable() {
        return Boolean.parseBoolean(this.properties.getOrDefault("mp.openapi.extensions.smallrye.scan-dependencies.disable", "false"));
    }

    public String customSchemaRegistryClass() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.custom-schema-registry.class", null);
    }

    public boolean applicationPathDisable() {
        return Boolean.parseBoolean(this.properties.getOrDefault("mp.openapi.extensions.smallrye.application-path.disable", "false"));
    }

    public String getOpenApiVersion() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.openapi", null);
    }

    public String getInfoTitle() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.title", null);
    }

    public String getInfoVersion() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.version", null);
    }

    public String getInfoDescription() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.description", null);
    }

    public String getInfoTermsOfService() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.termsOfService", null);
    }

    public String getInfoContactEmail() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.contact.email", null);
    }

    public String getInfoContactName() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.contact.name", null);
    }

    public String getInfoContactUrl() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.contact.url", null);
    }

    public String getInfoLicenseName() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.license.name", null);
    }

    public String getInfoLicenseUrl() {
        return this.properties.getOrDefault("mp.openapi.extensions.smallrye.info.license.url", null);
    }

    public OpenApiConfig.OperationIdStrategy getOperationIdStrategy() {
        String strategy = this.properties.getOrDefault("mp.openapi.extensions.smallrye.operationIdStrategy", null);
        if (strategy != null) {
            return OpenApiConfig.OperationIdStrategy.valueOf((String)strategy);
        }
        return null;
    }

    public OpenApiConfig.DuplicateOperationIdBehavior getDuplicateOperationIdBehavior() {
        String behavior = this.properties.getOrDefault("mp.openapi.extensions.smallrye.duplicateOperationIdBehavior", OpenApiConfig.DUPLICATE_OPERATION_ID_BEHAVIOR_DEFAULT.name());
        return OpenApiConfig.DuplicateOperationIdBehavior.valueOf((String)behavior);
    }

    public Set<String> getScanProfiles() {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.extensions.smallrye.scan.profiles", null));
    }

    public Set<String> getScanExcludeProfiles() {
        return this.asCsvSet(this.properties.getOrDefault("mp.openapi.extensions.smallrye.scan.exclude.profiles", null));
    }
}

