/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.io.parameter.ParameterConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JaxRsParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)\\}");

    private JaxRsParameterProcessor(AnnotationScannerContext scannerContext, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        super(scannerContext, reader, extensions);
    }

    public static ResourceParameters process(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        JaxRsParameterProcessor processor = new JaxRsParameterProcessor(context, reader, extensions);
        return processor.process(resourceClass, resourceMethod, reader);
    }

    protected void processPathParameters(ClassInfo resourceClass, MethodInfo resourceMethod, ResourceParameters parameters) {
        ClassInfo resourceMethodClass = resourceMethod.declaringClass();
        this.readParametersInherited(resourceMethodClass, null, false);
        if (!resourceClass.equals(resourceMethodClass)) {
            this.readParameters(resourceClass, null, true);
        }
        parameters.setPathItemParameters(this.getParameters(resourceMethod));
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return JaxRsParameter.MATRIX_PARAM.parameter;
    }

    protected String getDefaultFormMediaType() {
        return "application/x-www-form-urlencoded";
    }

    protected void addEncoding(Map<String, Encoding> encodings, String paramName, AnnotationTarget paramTarget) {
        if (paramTarget == null) {
            return;
        }
        AnnotationInstance type = TypeUtil.getAnnotation((AnnotationTarget)paramTarget, (DotName)RestEasyConstants.PART_TYPE);
        if (type != null) {
            EncodingImpl encoding = new EncodingImpl();
            encoding.setContentType(type.value().asString());
            encodings.put(paramName, (Encoding)encoding);
        }
    }

    static boolean parameterInPath(String paramName, Parameter.Style paramStyle, String resourcePath) {
        if (paramName == null || resourcePath == null) {
            return true;
        }
        String regex = Parameter.Style.MATRIX.equals((Object)paramStyle) ? String.format("(?:\\{[ \\t]*|^|/?)\\Q%s\\E(?:[ \\t]*(?:}|:)|/?|$)", paramName) : String.format("\\{[ \\t]*\\Q%s\\E[ \\t]*(?:}|:)", paramName);
        return Pattern.compile(regex).matcher(resourcePath).find();
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (ParameterConstant.DOTNAME_PARAMETER.equals((Object)name) && this.readerFunction != null) {
            Parameter oaiParam = (Parameter)this.readerFunction.apply(annotation);
            this.readParameter(new AbstractParameterProcessor.ParameterContextKey(oaiParam.getName(), oaiParam.getIn(), this.styleOf(oaiParam)), oaiParam, null, null, annotation.target(), overriddenParametersOnly);
        } else {
            FrameworkParameter frameworkParam = JaxRsParameter.forName(name);
            if (frameworkParam != null) {
                AnnotationTarget target = annotation.target();
                Type targetType = JaxRsParameterProcessor.getType((AnnotationTarget)target);
                if (frameworkParam.style == Parameter.Style.FORM) {
                    this.formParams.put(JaxRsParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                } else if (frameworkParam.style == Parameter.Style.MATRIX) {
                    String pathSegment;
                    String string = pathSegment = beanParamAnnotation != null ? this.lastPathSegmentOf(beanParamAnnotation.target()) : this.lastPathSegmentOf(target);
                    if (!this.matrixParams.containsKey(pathSegment)) {
                        this.matrixParams.put(pathSegment, new HashMap());
                    }
                    ((Map)this.matrixParams.get(pathSegment)).put(JaxRsParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                } else if (frameworkParam.location == Parameter.In.PATH && targetType != null && JaxRsConstants.PATH_SEGMENT.equals((Object)targetType.name())) {
                    String pathSegment = (String)JandexUtil.value((AnnotationInstance)annotation, (String)"value");
                    if (!this.matrixParams.containsKey(pathSegment)) {
                        this.matrixParams.put(pathSegment, new HashMap());
                    }
                } else if (frameworkParam.location != null) {
                    this.readParameter(new AbstractParameterProcessor.ParameterContextKey(JaxRsParameterProcessor.paramName((AnnotationInstance)annotation), frameworkParam.location, frameworkParam.defaultStyle), null, frameworkParam, this.getDefaultValue(target), target, overriddenParametersOnly);
                } else if (target != null) {
                    this.setMediaType(frameworkParam);
                    if (TypeUtil.isOptional((Type)targetType)) {
                        targetType = TypeUtil.getOptionalType((Type)targetType);
                    }
                    if (targetType != null) {
                        ClassInfo beanParam = this.index.getClassByName(targetType.name());
                        this.readParametersInherited(beanParam, annotation, overriddenParametersOnly);
                    }
                }
            }
        }
    }

    protected DotName getDefaultAnnotationName() {
        return JaxRsConstants.DEFAULT_VALUE;
    }

    protected String getDefaultAnnotationProperty() {
        return "value";
    }

    protected String pathOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        switch (target.kind()) {
            case CLASS: {
                path = target.asClass().classAnnotation(JaxRsConstants.PATH);
                break;
            }
            case METHOD: {
                path = target.asMethod().annotation(JaxRsConstants.PATH);
                break;
            }
        }
        if (path != null) {
            String pathValue = path.value().asString();
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            return pathValue;
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSubResourceLocator(MethodInfo method) {
        if (method.returnType().kind() != Type.Kind.CLASS) return false;
        if (!method.hasAnnotation(JaxRsConstants.PATH)) return false;
        if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(JaxRsConstants.HTTP_METHODS::contains)) return false;
        return true;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(JaxRsConstants.HTTP_METHODS::contains);
    }

    protected boolean isParameter(DotName annotationName) {
        if (JaxRsParameter.isParameter(annotationName)) {
            return true;
        }
        if (ParameterConstant.DOTNAME_PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return ParameterConstant.DOTNAME_PARAMETERS.equals((Object)annotationName);
    }
}

