/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.gradleplugin.Configs;
import io.smallrye.openapi.gradleplugin.GradleDependencyIndexCreator;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiExtension;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiProperties;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jboss.jandex.IndexView;

@CacheableTask
public class SmallryeOpenApiTask
extends DefaultTask
implements SmallryeOpenApiProperties {
    private final FileCollection classpath;
    private final FileCollection resourcesSrcDirs;
    private final FileCollection classesDirs;
    private final DirectoryProperty outputDirectory;
    private final Configs properties;

    @Inject
    public SmallryeOpenApiTask(SmallryeOpenApiExtension ext, ObjectFactory objects, ProjectLayout layout, FileCollection classpath, FileCollection resourcesSrcDirs, FileCollection classesDirs) {
        this.classpath = classpath;
        this.resourcesSrcDirs = resourcesSrcDirs;
        this.classesDirs = classesDirs;
        this.outputDirectory = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated/openapi"));
        this.properties = new Configs(objects, ext);
    }

    @TaskAction
    public void generate() {
        try {
            this.clearOutput();
            Set dependencies = (Boolean)this.properties.scanDependenciesDisable.get() != false ? Collections.emptySet() : this.classpath.getFiles();
            IndexView index = new GradleDependencyIndexCreator(this.getLogger()).createIndex(dependencies, this.classesDirs);
            SmallRyeOpenAPI openAPI = this.generateOpenAPI(index, this.resourcesSrcDirs);
            this.write(openAPI);
        }
        catch (Exception ex) {
            throw new GradleException("Could not generate OpenAPI Schema", (Throwable)ex);
        }
    }

    private SmallRyeOpenAPI generateOpenAPI(IndexView index, FileCollection resourcesSrcDirs) {
        return SmallRyeOpenAPI.builder().withConfig(this.properties.asMicroprofileConfig()).withApplicationClassLoader(this.getClassLoader()).withResourceLocator(path -> resourcesSrcDirs.getFiles().stream().map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toString).map(dirPath -> Paths.get(dirPath, path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(staticFile -> {
            try {
                return staticFile.toUri().toURL();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).findFirst().orElse(null)).withIndex(index).build();
    }

    private ClassLoader getClassLoader() {
        URL[] locators = (URL[])Stream.of(this.classesDirs, this.classpath).map(FileCollection::getFiles).flatMap(Collection::stream).map(pathEntry -> {
            this.getLogger().debug("Adding {} to annotation scanner class loader", pathEntry);
            try {
                return pathEntry.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new UncheckedIOException(mue);
            }
        }).toArray(URL[]::new);
        return URLClassLoader.newInstance(locators, Thread.currentThread().getContextClassLoader());
    }

    private void clearOutput() {
        File outputDir = ((Directory)this.outputDirectory.get()).getAsFile();
        this.deleteRecursively(outputDir);
    }

    private void deleteRecursively(File file) {
        File[] contents;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (contents = file.listFiles()) != null) {
            for (File f : contents) {
                this.deleteRecursively(f);
            }
        }
        file.delete();
    }

    private void write(SmallRyeOpenAPI openAPI) throws GradleException {
        try {
            Charset charset;
            String yaml = openAPI.toYAML();
            String json = openAPI.toJSON();
            Path directory = ((Directory)this.outputDirectory.get()).getAsFile().toPath();
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            try {
                charset = Charset.forName(((String)this.properties.encoding.get()).trim());
            }
            catch (IllegalCharsetNameException e) {
                throw new GradleException("encoding parameter does not define a legal charset name", (Throwable)e);
            }
            catch (UnsupportedCharsetException e) {
                throw new GradleException("encoding parameter does not define a supported charset", (Throwable)e);
            }
            if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.YAML).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(OutputFileFilter.class, (String)this.properties.outputFileTypeFilter.get())))) {
                this.writeFile(directory, "yaml", yaml.getBytes(charset));
            }
            if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.JSON).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(OutputFileFilter.class, (String)this.properties.outputFileTypeFilter.get())))) {
                this.writeFile(directory, "json", json.getBytes(charset));
            }
            this.getLogger().info("Wrote the schema files to {}", (Object)((Directory)this.outputDirectory.get()).getAsFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new GradleException("Can't write the result", (Throwable)e);
        }
    }

    private void writeFile(Path directory, String type, byte[] contents) throws IOException {
        Path file = Paths.get(directory.toString(), (String)this.properties.schemaFilename.get() + "." + type);
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, contents, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public RegularFileProperty getConfigProperties() {
        return this.properties.configProperties;
    }

    @Override
    @Input
    public Property<String> getSchemaFilename() {
        return this.properties.schemaFilename;
    }

    @Override
    @Input
    public Property<Boolean> getScanDependenciesDisable() {
        return this.properties.scanDependenciesDisable;
    }

    @Override
    @Input
    @Optional
    public Property<String> getModelReader() {
        return this.properties.modelReader;
    }

    @Override
    @Input
    @Optional
    public Property<String> getFilter() {
        return this.properties.filter;
    }

    @Override
    @Input
    @Optional
    public Property<Boolean> getScanDisabled() {
        return this.properties.scanDisabled;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanPackages() {
        return this.properties.scanPackages;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanClasses() {
        return this.properties.scanClasses;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludePackages() {
        return this.properties.scanExcludePackages;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludeClasses() {
        return this.properties.scanExcludeClasses;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getServers() {
        return this.properties.servers;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getPathServers() {
        return this.properties.pathServers;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getOperationServers() {
        return this.properties.operationServers;
    }

    @Override
    @Input
    @Optional
    public Property<String> getCustomSchemaRegistryClass() {
        return this.properties.customSchemaRegistryClass;
    }

    @Override
    @Input
    public Property<Boolean> getApplicationPathDisable() {
        return this.properties.applicationPathDisable;
    }

    @Override
    @Input
    public Property<String> getOpenApiVersion() {
        return this.properties.openApiVersion;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoTitle() {
        return this.properties.infoTitle;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoVersion() {
        return this.properties.infoVersion;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoDescription() {
        return this.properties.infoDescription;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoTermsOfService() {
        return this.properties.infoTermsOfService;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoSummary() {
        return this.properties.infoSummary;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactEmail() {
        return this.properties.infoContactEmail;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactName() {
        return this.properties.infoContactName;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactUrl() {
        return this.properties.infoContactUrl;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoLicenseName() {
        return this.properties.infoLicenseName;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoLicenseUrl() {
        return this.properties.infoLicenseUrl;
    }

    @Override
    @Input
    @Optional
    public Property<OpenApiConfig.OperationIdStrategy> getOperationIdStrategy() {
        return this.properties.operationIdStrategy;
    }

    @Override
    @Input
    @Optional
    public Property<OpenApiConfig.DuplicateOperationIdBehavior> getDuplicateOperationIdBehavior() {
        return this.properties.duplicateOperationIdBehavior;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanProfiles() {
        return this.properties.scanProfiles;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludeProfiles() {
        return this.properties.scanExcludeProfiles;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getScanResourceClasses() {
        return this.properties.scanResourceClasses;
    }

    @Override
    @Input
    @Optional
    public Property<String> getOutputFileTypeFilter() {
        return this.properties.outputFileTypeFilter;
    }

    @Override
    @Input
    @Optional
    public Property<String> getEncoding() {
        return this.properties.encoding;
    }

    static enum OutputFileFilter {
        ALL,
        YAML,
        JSON;

    }
}

