/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import io.smallrye.config.ConfigValuePropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiExtension;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

class Configs
implements SmallryeOpenApiProperties {
    final RegularFileProperty configProperties;
    final Property<String> schemaFilename;
    final Property<Boolean> scanDependenciesDisable;
    final Property<String> modelReader;
    final Property<String> filter;
    final Property<Boolean> scanDisabled;
    final ListProperty<String> scanPackages;
    final ListProperty<String> scanClasses;
    final ListProperty<String> scanExcludePackages;
    final ListProperty<String> scanExcludeClasses;
    final ListProperty<String> servers;
    final MapProperty<String, String> pathServers;
    final MapProperty<String, String> operationServers;
    final Property<String> customSchemaRegistryClass;
    final Property<Boolean> applicationPathDisable;
    final Property<String> openApiVersion;
    final Property<String> infoTitle;
    final Property<String> infoVersion;
    final Property<String> infoDescription;
    final Property<String> infoTermsOfService;
    final Property<String> infoContactEmail;
    final Property<String> infoContactName;
    final Property<String> infoContactUrl;
    final Property<String> infoLicenseName;
    final Property<String> infoLicenseUrl;
    final Property<OpenApiConfig.OperationIdStrategy> operationIdStrategy;
    final Property<OpenApiConfig.DuplicateOperationIdBehavior> duplicateOperationIdBehavior;
    final ListProperty<String> scanProfiles;
    final ListProperty<String> scanExcludeProfiles;
    final MapProperty<String, String> scanResourceClasses;
    final Property<String> outputFileTypeFilter;
    final Property<String> encoding;

    Configs(ObjectFactory objects) {
        this.configProperties = objects.fileProperty();
        this.schemaFilename = objects.property(String.class).convention((Object)"openapi");
        this.scanDependenciesDisable = objects.property(Boolean.class).convention((Object)false);
        this.modelReader = objects.property(String.class);
        this.filter = objects.property(String.class);
        this.scanDisabled = objects.property(Boolean.class);
        this.scanPackages = objects.listProperty(String.class);
        this.scanClasses = objects.listProperty(String.class);
        this.scanExcludePackages = objects.listProperty(String.class);
        this.scanExcludeClasses = objects.listProperty(String.class);
        this.servers = objects.listProperty(String.class);
        this.pathServers = objects.mapProperty(String.class, String.class);
        this.operationServers = objects.mapProperty(String.class, String.class);
        this.customSchemaRegistryClass = objects.property(String.class);
        this.applicationPathDisable = objects.property(Boolean.class).convention((Object)false);
        this.openApiVersion = objects.property(String.class).convention((Object)"3.0.3");
        this.infoTitle = objects.property(String.class);
        this.infoVersion = objects.property(String.class);
        this.infoDescription = objects.property(String.class);
        this.infoTermsOfService = objects.property(String.class);
        this.infoContactEmail = objects.property(String.class);
        this.infoContactName = objects.property(String.class);
        this.infoContactUrl = objects.property(String.class);
        this.infoLicenseName = objects.property(String.class);
        this.infoLicenseUrl = objects.property(String.class);
        this.operationIdStrategy = objects.property(OpenApiConfig.OperationIdStrategy.class);
        this.duplicateOperationIdBehavior = objects.property(OpenApiConfig.DuplicateOperationIdBehavior.class);
        this.scanProfiles = objects.listProperty(String.class);
        this.scanExcludeProfiles = objects.listProperty(String.class);
        this.scanResourceClasses = objects.mapProperty(String.class, String.class);
        this.outputFileTypeFilter = objects.property(String.class).convention((Object)"ALL");
        this.encoding = objects.property(String.class).convention((Object)StandardCharsets.UTF_8.name());
    }

    Configs(ObjectFactory objects, SmallryeOpenApiExtension ext) {
        this.configProperties = objects.fileProperty().convention((Provider)ext.getConfigProperties());
        this.schemaFilename = objects.property(String.class).convention((Provider)ext.getSchemaFilename());
        this.scanDependenciesDisable = objects.property(Boolean.class).convention((Provider)ext.getScanDependenciesDisable());
        this.modelReader = objects.property(String.class).convention((Provider)ext.getModelReader());
        this.filter = objects.property(String.class).convention((Provider)ext.getFilter());
        this.scanDisabled = objects.property(Boolean.class).convention((Provider)ext.getScanDisabled());
        this.scanPackages = objects.listProperty(String.class).convention((Provider)ext.getScanPackages());
        this.scanClasses = objects.listProperty(String.class).convention((Provider)ext.getScanClasses());
        this.scanExcludePackages = objects.listProperty(String.class).convention((Provider)ext.getScanExcludePackages());
        this.scanExcludeClasses = objects.listProperty(String.class).convention((Provider)ext.getScanExcludeClasses());
        this.servers = objects.listProperty(String.class).convention((Provider)ext.getServers());
        this.pathServers = objects.mapProperty(String.class, String.class).convention((Provider)ext.getPathServers());
        this.operationServers = objects.mapProperty(String.class, String.class).convention((Provider)ext.getOperationServers());
        this.customSchemaRegistryClass = objects.property(String.class).convention((Provider)ext.getCustomSchemaRegistryClass());
        this.applicationPathDisable = objects.property(Boolean.class).convention((Provider)ext.getApplicationPathDisable());
        this.openApiVersion = objects.property(String.class).convention((Provider)ext.getOpenApiVersion());
        this.infoTitle = objects.property(String.class).convention((Provider)ext.getInfoTitle());
        this.infoVersion = objects.property(String.class).convention((Provider)ext.getInfoVersion());
        this.infoDescription = objects.property(String.class).convention((Provider)ext.getInfoDescription());
        this.infoTermsOfService = objects.property(String.class).convention((Provider)ext.getInfoTermsOfService());
        this.infoContactEmail = objects.property(String.class).convention((Provider)ext.getInfoContactEmail());
        this.infoContactName = objects.property(String.class).convention((Provider)ext.getInfoContactName());
        this.infoContactUrl = objects.property(String.class).convention((Provider)ext.getInfoContactUrl());
        this.infoLicenseName = objects.property(String.class).convention((Provider)ext.getInfoLicenseName());
        this.infoLicenseUrl = objects.property(String.class).convention((Provider)ext.getInfoLicenseUrl());
        this.operationIdStrategy = objects.property(OpenApiConfig.OperationIdStrategy.class).convention((Provider)ext.getOperationIdStrategy());
        this.duplicateOperationIdBehavior = objects.property(OpenApiConfig.DuplicateOperationIdBehavior.class).convention((Provider)ext.getDuplicateOperationIdBehavior());
        this.scanProfiles = objects.listProperty(String.class).convention((Provider)ext.getScanProfiles());
        this.scanExcludeProfiles = objects.listProperty(String.class).convention((Provider)ext.getScanExcludeProfiles());
        this.scanResourceClasses = objects.mapProperty(String.class, String.class).convention((Provider)ext.getScanResourceClasses());
        this.outputFileTypeFilter = objects.property(String.class).convention((Provider)ext.getOutputFileTypeFilter());
        this.encoding = objects.property(String.class).convention((Provider)ext.getEncoding());
    }

    OpenApiConfig asOpenApiConfig() {
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigValuePropertiesConfigSource(this.getProperties(), "maven-plugin", 100)}).build();
        return OpenApiConfig.fromConfig((Config)config);
    }

    private Map<String, String> getProperties() {
        HashMap<String, String> cp = new HashMap<String, String>();
        File propertiesFile = (File)this.configProperties.getAsFile().getOrElse(null);
        if (propertiesFile != null) {
            Properties p = new Properties();
            try (InputStream is = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                p.load(is);
                p.stringPropertyNames().forEach(name -> cp.put((String)name, p.getProperty((String)name)));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        this.addToPropertyMap(cp, "mp.openapi.model.reader", this.modelReader);
        this.addToPropertyMap(cp, "mp.openapi.filter", this.filter);
        this.addToPropertyMap(cp, "mp.openapi.scan.disable", this.scanDisabled);
        this.addToPropertyMap(cp, "mp.openapi.scan.packages", this.scanPackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.classes", this.scanClasses);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.packages", this.scanExcludePackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.classes", this.scanExcludeClasses);
        this.addToPropertyMap(cp, "mp.openapi.servers", this.servers);
        this.addToPropertyMap(cp, "mp.openapi.servers.path.", this.pathServers);
        this.addToPropertyMap(cp, "mp.openapi.servers.operation.", this.operationServers);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan-dependencies.disable", this.scanDependenciesDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.custom-schema-registry.class", this.customSchemaRegistryClass);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.application-path.disable", this.applicationPathDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.openapi", this.openApiVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.title", this.infoTitle);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.version", this.infoVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.description", this.infoDescription);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.termsOfService", this.infoTermsOfService);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.email", this.infoContactEmail);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.name", this.infoContactName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.url", this.infoContactUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.name", this.infoLicenseName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.url", this.infoLicenseUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.operationIdStrategy", this.operationIdStrategy);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.profiles", this.scanProfiles);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.exclude.profiles", this.scanExcludeProfiles);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan.resource-class.", this.scanResourceClasses);
        return cp;
    }

    private void addToPropertyMap(Map<String, String> map, String key, Property<?> value) {
        if (value.isPresent()) {
            map.put(key, value.get().toString());
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, ListProperty<String> values) {
        if (values.isPresent() && !((List)values.get()).isEmpty()) {
            String value = ((List)values.get()).stream().map(v -> v.replace("\\", "\\\\")).map(v -> v.replace(",", "\\,")).collect(Collectors.joining(","));
            map.put(key, value);
        }
    }

    private void addToPropertyMap(Map<String, String> map, String keyPrefix, MapProperty<String, String> values) {
        if (values.isPresent()) {
            ((Map)values.get()).forEach((key, value) -> map.put(keyPrefix + key, (String)value));
        }
    }

    @Override
    public RegularFileProperty getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public Property<String> getSchemaFilename() {
        return this.schemaFilename;
    }

    @Override
    public Property<Boolean> getScanDependenciesDisable() {
        return this.scanDependenciesDisable;
    }

    @Override
    public Property<String> getModelReader() {
        return this.modelReader;
    }

    @Override
    public Property<String> getFilter() {
        return this.filter;
    }

    @Override
    public Property<Boolean> getScanDisabled() {
        return this.scanDisabled;
    }

    @Override
    public ListProperty<String> getScanPackages() {
        return this.scanPackages;
    }

    @Override
    public ListProperty<String> getScanClasses() {
        return this.scanClasses;
    }

    @Override
    public ListProperty<String> getScanExcludePackages() {
        return this.scanExcludePackages;
    }

    @Override
    public ListProperty<String> getScanExcludeClasses() {
        return this.scanExcludeClasses;
    }

    @Override
    public ListProperty<String> getServers() {
        return this.servers;
    }

    @Override
    public MapProperty<String, String> getPathServers() {
        return this.pathServers;
    }

    @Override
    public MapProperty<String, String> getOperationServers() {
        return this.operationServers;
    }

    @Override
    public Property<String> getCustomSchemaRegistryClass() {
        return this.customSchemaRegistryClass;
    }

    @Override
    public Property<Boolean> getApplicationPathDisable() {
        return this.applicationPathDisable;
    }

    @Override
    public Property<String> getOpenApiVersion() {
        return this.openApiVersion;
    }

    @Override
    public Property<String> getInfoTitle() {
        return this.infoTitle;
    }

    @Override
    public Property<String> getInfoVersion() {
        return this.infoVersion;
    }

    @Override
    public Property<String> getInfoDescription() {
        return this.infoDescription;
    }

    @Override
    public Property<String> getInfoTermsOfService() {
        return this.infoTermsOfService;
    }

    @Override
    public Property<String> getInfoContactEmail() {
        return this.infoContactEmail;
    }

    @Override
    public Property<String> getInfoContactName() {
        return this.infoContactName;
    }

    @Override
    public Property<String> getInfoContactUrl() {
        return this.infoContactUrl;
    }

    @Override
    public Property<String> getInfoLicenseName() {
        return this.infoLicenseName;
    }

    @Override
    public Property<String> getInfoLicenseUrl() {
        return this.infoLicenseUrl;
    }

    @Override
    public Property<OpenApiConfig.OperationIdStrategy> getOperationIdStrategy() {
        return this.operationIdStrategy;
    }

    @Override
    public Property<OpenApiConfig.DuplicateOperationIdBehavior> getDuplicateOperationIdBehavior() {
        return this.duplicateOperationIdBehavior;
    }

    @Override
    public ListProperty<String> getScanProfiles() {
        return this.scanProfiles;
    }

    @Override
    public ListProperty<String> getScanExcludeProfiles() {
        return this.scanExcludeProfiles;
    }

    @Override
    public MapProperty<String, String> getScanResourceClasses() {
        return this.scanResourceClasses;
    }

    @Override
    public Property<String> getOutputFileTypeFilter() {
        return this.outputFileTypeFilter;
    }

    @Override
    public Property<String> getEncoding() {
        return this.encoding;
    }
}

