/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.gradleplugin.Configs;
import io.smallrye.openapi.gradleplugin.GradleDependencyIndexCreator;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiExtension;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiProperties;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jboss.jandex.IndexView;

@CacheableTask
public class SmallryeOpenApiTask
extends DefaultTask
implements SmallryeOpenApiProperties {
    private final FileCollection classpath;
    private final FileCollection resourcesSrcDirs;
    private final FileCollection classesDirs;
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";
    private final DirectoryProperty outputDirectory;
    private final Configs properties;

    @Inject
    public SmallryeOpenApiTask(SmallryeOpenApiExtension ext, ObjectFactory objects, ProjectLayout layout, FileCollection classpath, FileCollection resourcesSrcDirs, FileCollection classesDirs) {
        this.classpath = classpath;
        this.resourcesSrcDirs = resourcesSrcDirs;
        this.classesDirs = classesDirs;
        this.outputDirectory = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated/openapi"));
        this.properties = new Configs(objects, ext);
    }

    @TaskAction
    public void generate() {
        try {
            this.clearOutput();
            Set dependencies = (Boolean)this.properties.scanDependenciesDisable.get() != false ? Collections.emptySet() : this.classpath.getFiles();
            IndexView index = new GradleDependencyIndexCreator(this.getLogger()).createIndex(dependencies, this.classesDirs);
            OpenApiDocument schema = this.generateSchema(index, this.resourcesSrcDirs);
            this.write(schema);
        }
        catch (Exception ex) {
            throw new GradleException("Could not generate OpenAPI Schema", (Throwable)ex);
        }
    }

    private OpenApiDocument generateSchema(IndexView index, FileCollection resourcesSrcDirs) throws IOException {
        OpenApiConfig openApiConfig = this.properties.asOpenApiConfig();
        ClassLoader classLoader = this.getClassLoader(this.classpath);
        OpenAPI staticModel = this.generateStaticModel(openApiConfig, resourcesSrcDirs);
        OpenAPI annotationModel = this.generateAnnotationModel(index, openApiConfig, SmallryeOpenApiTask.class.getClassLoader());
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)classLoader, (IndexView)index);
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        if (annotationModel != null) {
            this.addingModelDebug("annotations", annotationModel);
            document.modelFromAnnotations(annotationModel);
        }
        if (readerModel != null) {
            this.addingModelDebug("reader", readerModel);
            document.modelFromReader(readerModel);
        }
        if (staticModel != null) {
            this.addingModelDebug("static", staticModel);
            document.modelFromStaticFile(staticModel);
        }
        document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)classLoader, (IndexView)index));
        document.initialize();
        return document;
    }

    private void addingModelDebug(String from, OpenAPI model) {
        this.getLogger().debug("Adding model from {}...", (Object)from);
        this.nullSafeMap("callbacks", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getCallbacks));
        this.nullSafeMap("examples", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getExamples));
        this.nullSafeMap("headers", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getHeaders));
        this.nullSafeMap("links", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getLinks));
        this.nullSafeMap("parameters", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getParameters));
        this.nullSafeMap("request bodies", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getRequestBodies));
        this.nullSafeMap("responses", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getResponses));
        this.nullSafeMap("schemas", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getSchemas));
        this.nullSafeMap("security schemes", from, java.util.Optional.ofNullable(model.getComponents()).map(Components::getSecuritySchemes));
        this.nullSafeColl("servers", from, java.util.Optional.ofNullable(model.getServers()));
        this.nullSafeMap("path items", from, java.util.Optional.ofNullable(model.getPaths()).map(org.eclipse.microprofile.openapi.models.Paths::getPathItems));
        this.nullSafeColl("security", from, java.util.Optional.ofNullable(model.getSecurity()));
        this.nullSafeColl("tags", from, java.util.Optional.ofNullable(model.getTags()));
        this.nullSafeMap("extensions", from, java.util.Optional.ofNullable(model.getExtensions()));
    }

    private void nullSafeMap(String what, String from, java.util.Optional<Map<?, ?>> collection) {
        this.nullSafe(what, from, collection.map(Map::size));
    }

    private void nullSafeColl(String what, String from, java.util.Optional<Collection<?>> collection) {
        this.nullSafe(what, from, collection.map(Collection::size));
    }

    private void nullSafe(String what, String from, java.util.Optional<Integer> collection) {
        this.getLogger().debug("Adding {} {} from {}", new Object[]{collection.map(Object::toString).orElse("<no>"), what, from});
    }

    private ClassLoader getClassLoader(FileCollection config) throws MalformedURLException {
        HashSet<URL> urls = new HashSet<URL>();
        for (File dependency : config.getFiles()) {
            this.getLogger().debug("Adding {} to annotation scanner class loader", (Object)dependency);
            urls.add(dependency.toURI().toURL());
        }
        return URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, OpenApiConfig openApiConfig, ClassLoader classLoader) {
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner(openApiConfig, classLoader, indexView);
        return openApiAnnotationScanner.scan(new String[0]);
    }

    private OpenAPI generateStaticModel(OpenApiConfig openApiConfig, FileCollection resourcesSrcDirs) throws IOException {
        Path staticFile = this.getStaticFile(resourcesSrcDirs);
        if (staticFile != null) {
            try (InputStream is = Files.newInputStream(staticFile, new OpenOption[0]);){
                OpenAPI openAPI;
                try (OpenApiStaticFile openApiStaticFile = new OpenApiStaticFile(is, this.getFormat(staticFile));){
                    openAPI = OpenApiProcessor.modelFromStaticFile((OpenApiConfig)openApiConfig, (OpenApiStaticFile)openApiStaticFile);
                }
                return openAPI;
            }
        }
        return null;
    }

    private Path getStaticFile(FileCollection resourcesSrcDirs) {
        Path staticFile = resourcesSrcDirs.getFiles().stream().map(this::getStaticFile).filter(Objects::nonNull).findFirst().orElse(null);
        return staticFile;
    }

    private Path getStaticFile(File dir) {
        this.getLogger().debug("Checking for static file in {}", (Object)dir);
        Path classesPath = dir.toPath();
        if (Files.exists(classesPath, new LinkOption[0])) {
            Path resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
        }
        return null;
    }

    private Format getFormat(Path path) {
        if (path.endsWith(".json")) {
            return Format.JSON;
        }
        return Format.YAML;
    }

    private void clearOutput() {
        File outputDir = ((Directory)this.outputDirectory.get()).getAsFile();
        this.deleteRecursively(outputDir);
    }

    private void deleteRecursively(File file) {
        File[] contents;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (contents = file.listFiles()) != null) {
            for (File f : contents) {
                this.deleteRecursively(f);
            }
        }
        file.delete();
    }

    private void write(OpenApiDocument schema) throws GradleException {
        try {
            Charset charset;
            String yaml = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.YAML);
            String json = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.JSON);
            Path directory = ((Directory)this.outputDirectory.get()).getAsFile().toPath();
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            try {
                charset = Charset.forName(((String)this.properties.encoding.get()).trim());
            }
            catch (IllegalCharsetNameException e) {
                throw new GradleException("encoding parameter does not define a legal charset name", (Throwable)e);
            }
            catch (UnsupportedCharsetException e) {
                throw new GradleException("encoding parameter does not define a supported charset", (Throwable)e);
            }
            if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.YAML).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(OutputFileFilter.class, (String)this.properties.outputFileTypeFilter.get())))) {
                this.writeSchemaFile(directory, "yaml", yaml.getBytes(charset));
            }
            if (Stream.of(OutputFileFilter.ALL, OutputFileFilter.JSON).anyMatch(f -> f.equals((Object)OutputFileFilter.valueOf(OutputFileFilter.class, (String)this.properties.outputFileTypeFilter.get())))) {
                this.writeSchemaFile(directory, "json", json.getBytes(charset));
            }
            this.getLogger().info("Wrote the schema files to {}", (Object)((Directory)this.outputDirectory.get()).getAsFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new GradleException("Can't write the result", (Throwable)e);
        }
    }

    private void writeSchemaFile(Path directory, String type, byte[] contents) throws IOException {
        Path file = Paths.get(directory.toString(), (String)this.properties.schemaFilename.get() + "." + type);
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, contents, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public RegularFileProperty getConfigProperties() {
        return this.properties.configProperties;
    }

    @Override
    @Input
    public Property<String> getSchemaFilename() {
        return this.properties.schemaFilename;
    }

    @Override
    @Input
    public Property<Boolean> getScanDependenciesDisable() {
        return this.properties.scanDependenciesDisable;
    }

    @Override
    @Input
    @Optional
    public Property<String> getModelReader() {
        return this.properties.modelReader;
    }

    @Override
    @Input
    @Optional
    public Property<String> getFilter() {
        return this.properties.filter;
    }

    @Override
    @Input
    @Optional
    public Property<Boolean> getScanDisabled() {
        return this.properties.scanDisabled;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanPackages() {
        return this.properties.scanPackages;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanClasses() {
        return this.properties.scanClasses;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludePackages() {
        return this.properties.scanExcludePackages;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludeClasses() {
        return this.properties.scanExcludeClasses;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getServers() {
        return this.properties.servers;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getPathServers() {
        return this.properties.pathServers;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getOperationServers() {
        return this.properties.operationServers;
    }

    @Override
    @Input
    @Optional
    public Property<String> getCustomSchemaRegistryClass() {
        return this.properties.customSchemaRegistryClass;
    }

    @Override
    @Input
    public Property<Boolean> getApplicationPathDisable() {
        return this.properties.applicationPathDisable;
    }

    @Override
    @Input
    public Property<String> getOpenApiVersion() {
        return this.properties.openApiVersion;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoTitle() {
        return this.properties.infoTitle;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoVersion() {
        return this.properties.infoVersion;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoDescription() {
        return this.properties.infoDescription;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoTermsOfService() {
        return this.properties.infoTermsOfService;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactEmail() {
        return this.properties.infoContactEmail;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactName() {
        return this.properties.infoContactName;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoContactUrl() {
        return this.properties.infoContactUrl;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoLicenseName() {
        return this.properties.infoLicenseName;
    }

    @Override
    @Input
    @Optional
    public Property<String> getInfoLicenseUrl() {
        return this.properties.infoLicenseUrl;
    }

    @Override
    @Input
    @Optional
    public Property<OpenApiConfig.OperationIdStrategy> getOperationIdStrategy() {
        return this.properties.operationIdStrategy;
    }

    @Override
    @Input
    @Optional
    public Property<OpenApiConfig.DuplicateOperationIdBehavior> getDuplicateOperationIdBehavior() {
        return this.properties.duplicateOperationIdBehavior;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanProfiles() {
        return this.properties.scanProfiles;
    }

    @Override
    @Input
    @Optional
    public ListProperty<String> getScanExcludeProfiles() {
        return this.properties.scanExcludeProfiles;
    }

    @Override
    @Input
    @Optional
    public MapProperty<String, String> getScanResourceClasses() {
        return this.properties.scanResourceClasses;
    }

    @Override
    @Input
    @Optional
    public Property<String> getOutputFileTypeFilter() {
        return this.properties.outputFileTypeFilter;
    }

    @Override
    @Input
    @Optional
    public Property<String> getEncoding() {
        return this.properties.encoding;
    }

    static enum OutputFileFilter {
        ALL,
        YAML,
        JSON;

    }
}

