/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.gradleplugin.SmallryeOpenApiExtension;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;

class Configs {
    final RegularFileProperty configProperties;
    final Property<String> schemaFilename;
    final Property<Boolean> scanDependenciesDisable;
    final Property<String> modelReader;
    final Property<String> filter;
    final Property<Boolean> scanDisabled;
    final ListProperty<String> scanPackages;
    final ListProperty<String> scanClasses;
    final ListProperty<String> scanExcludePackages;
    final ListProperty<String> scanExcludeClasses;
    final ListProperty<String> servers;
    final MapProperty<String, String> pathServers;
    final MapProperty<String, String> operationServers;
    final Property<String> customSchemaRegistryClass;
    final Property<Boolean> applicationPathDisable;
    final Property<String> openApiVersion;
    final Property<String> infoTitle;
    final Property<String> infoVersion;
    final Property<String> infoDescription;
    final Property<String> infoTermsOfService;
    final Property<String> infoContactEmail;
    final Property<String> infoContactName;
    final Property<String> infoContactUrl;
    final Property<String> infoLicenseName;
    final Property<String> infoLicenseUrl;
    final Property<OpenApiConfig.OperationIdStrategy> operationIdStrategy;
    final Property<OpenApiConfig.DuplicateOperationIdBehavior> duplicateOperationIdBehavior;
    final SetProperty<String> scanProfiles;
    final SetProperty<String> scanExcludeProfiles;
    final Property<String> encoding;

    Configs(ObjectFactory objects) {
        this.configProperties = objects.fileProperty();
        this.schemaFilename = objects.property(String.class).convention((Object)"openapi");
        this.scanDependenciesDisable = objects.property(Boolean.class).convention((Object)false);
        this.modelReader = objects.property(String.class);
        this.filter = objects.property(String.class);
        this.scanDisabled = objects.property(Boolean.class);
        this.scanPackages = objects.listProperty(String.class);
        this.scanClasses = objects.listProperty(String.class);
        this.scanExcludePackages = objects.listProperty(String.class);
        this.scanExcludeClasses = objects.listProperty(String.class);
        this.servers = objects.listProperty(String.class);
        this.pathServers = objects.mapProperty(String.class, String.class);
        this.operationServers = objects.mapProperty(String.class, String.class);
        this.customSchemaRegistryClass = objects.property(String.class);
        this.applicationPathDisable = objects.property(Boolean.class).convention((Object)false);
        this.openApiVersion = objects.property(String.class).convention((Object)"3.0.3");
        this.infoTitle = objects.property(String.class);
        this.infoVersion = objects.property(String.class);
        this.infoDescription = objects.property(String.class);
        this.infoTermsOfService = objects.property(String.class);
        this.infoContactEmail = objects.property(String.class);
        this.infoContactName = objects.property(String.class);
        this.infoContactUrl = objects.property(String.class);
        this.infoLicenseName = objects.property(String.class);
        this.infoLicenseUrl = objects.property(String.class);
        this.operationIdStrategy = objects.property(OpenApiConfig.OperationIdStrategy.class);
        this.duplicateOperationIdBehavior = objects.property(OpenApiConfig.DuplicateOperationIdBehavior.class);
        this.scanProfiles = objects.setProperty(String.class);
        this.scanExcludeProfiles = objects.setProperty(String.class);
        this.encoding = objects.property(String.class).convention((Object)StandardCharsets.UTF_8.name());
    }

    Configs(ObjectFactory objects, SmallryeOpenApiExtension ext) {
        this.configProperties = objects.fileProperty().convention((Provider)ext.getConfigProperties());
        this.schemaFilename = objects.property(String.class).convention(ext.getSchemaFilename());
        this.scanDependenciesDisable = objects.property(Boolean.class).convention(ext.getScanDependenciesDisable());
        this.modelReader = objects.property(String.class).convention(ext.getModelReader());
        this.filter = objects.property(String.class).convention(ext.getFilter());
        this.scanDisabled = objects.property(Boolean.class).convention(ext.getScanDisabled());
        this.scanPackages = objects.listProperty(String.class).convention(ext.getScanPackages());
        this.scanClasses = objects.listProperty(String.class).convention(ext.getScanClasses());
        this.scanExcludePackages = objects.listProperty(String.class).convention(ext.getScanExcludePackages());
        this.scanExcludeClasses = objects.listProperty(String.class).convention(ext.getScanExcludeClasses());
        this.servers = objects.listProperty(String.class).convention(ext.getServers());
        this.pathServers = objects.mapProperty(String.class, String.class).convention(ext.getPathServers());
        this.operationServers = objects.mapProperty(String.class, String.class).convention(ext.getOperationServers());
        this.customSchemaRegistryClass = objects.property(String.class).convention(ext.getCustomSchemaRegistryClass());
        this.applicationPathDisable = objects.property(Boolean.class).convention(ext.getApplicationPathDisable());
        this.openApiVersion = objects.property(String.class).convention(ext.getOpenApiVersion());
        this.infoTitle = objects.property(String.class).convention(ext.getInfoTitle());
        this.infoVersion = objects.property(String.class).convention(ext.getInfoVersion());
        this.infoDescription = objects.property(String.class).convention(ext.getInfoDescription());
        this.infoTermsOfService = objects.property(String.class).convention(ext.getInfoTermsOfService());
        this.infoContactEmail = objects.property(String.class).convention(ext.getInfoContactEmail());
        this.infoContactName = objects.property(String.class).convention(ext.getInfoContactName());
        this.infoContactUrl = objects.property(String.class).convention(ext.getInfoContactUrl());
        this.infoLicenseName = objects.property(String.class).convention(ext.getInfoLicenseName());
        this.infoLicenseUrl = objects.property(String.class).convention(ext.getInfoLicenseUrl());
        this.operationIdStrategy = objects.property(OpenApiConfig.OperationIdStrategy.class).convention(ext.getOperationIdStrategy());
        this.duplicateOperationIdBehavior = objects.property(OpenApiConfig.DuplicateOperationIdBehavior.class);
        this.scanProfiles = objects.setProperty(String.class).convention(ext.getScanProfiles());
        this.scanExcludeProfiles = objects.setProperty(String.class).convention((Provider)ext.scanExcludeProfiles);
        this.encoding = objects.property(String.class).convention((Provider)ext.encoding);
    }

    OpenApiConfig asOpenApiConfig() {
        return new OpenApiConfig(){

            public String modelReader() {
                return (String)Configs.this.modelReader.getOrNull();
            }

            public String filter() {
                return (String)Configs.this.filter.getOrNull();
            }

            public boolean scanDisable() {
                return (Boolean)Configs.this.scanDisabled.get();
            }

            public Set<String> scanPackages() {
                return new HashSet<String>((Collection)Configs.this.scanPackages.getOrElse(Collections.emptyList()));
            }

            public Set<String> scanClasses() {
                return new HashSet<String>((Collection)Configs.this.scanClasses.getOrElse(Collections.emptyList()));
            }

            public Set<String> scanExcludePackages() {
                return new HashSet<String>((Collection)Configs.this.scanExcludePackages.getOrElse(Collections.emptyList()));
            }

            public Set<String> scanExcludeClasses() {
                return new HashSet<String>((Collection)Configs.this.scanExcludeClasses.getOrElse(Collections.emptyList()));
            }

            public Set<String> servers() {
                return new HashSet<String>((Collection)Configs.this.servers.getOrElse(Collections.emptyList()));
            }

            public Set<String> pathServers(String path) {
                return this.asCsvSet((String)Configs.this.pathServers.getting((Object)path).getOrNull());
            }

            public Set<String> operationServers(String operationId) {
                return this.asCsvSet((String)Configs.this.operationServers.getting((Object)operationId).getOrNull());
            }

            public boolean scanDependenciesDisable() {
                return (Boolean)Configs.this.scanDependenciesDisable.get();
            }

            public String customSchemaRegistryClass() {
                return (String)Configs.this.customSchemaRegistryClass.getOrNull();
            }

            public boolean applicationPathDisable() {
                return (Boolean)Configs.this.applicationPathDisable.get();
            }

            public String getOpenApiVersion() {
                return (String)Configs.this.openApiVersion.getOrNull();
            }

            public String getInfoTitle() {
                return (String)Configs.this.infoTitle.getOrNull();
            }

            public String getInfoVersion() {
                return (String)Configs.this.infoVersion.getOrNull();
            }

            public String getInfoDescription() {
                return (String)Configs.this.infoDescription.getOrNull();
            }

            public String getInfoTermsOfService() {
                return (String)Configs.this.infoTermsOfService.getOrNull();
            }

            public String getInfoContactEmail() {
                return (String)Configs.this.infoContactEmail.getOrNull();
            }

            public String getInfoContactName() {
                return (String)Configs.this.infoContactName.getOrNull();
            }

            public String getInfoContactUrl() {
                return (String)Configs.this.infoContactUrl.getOrNull();
            }

            public String getInfoLicenseName() {
                return (String)Configs.this.infoLicenseName.getOrNull();
            }

            public String getInfoLicenseUrl() {
                return (String)Configs.this.infoLicenseUrl.getOrNull();
            }

            public OpenApiConfig.OperationIdStrategy getOperationIdStrategy() {
                return (OpenApiConfig.OperationIdStrategy)Configs.this.operationIdStrategy.getOrNull();
            }

            public OpenApiConfig.DuplicateOperationIdBehavior getDuplicateOperationIdBehavior() {
                return (OpenApiConfig.DuplicateOperationIdBehavior)Configs.this.duplicateOperationIdBehavior.getOrElse((Object)OpenApiConfig.DUPLICATE_OPERATION_ID_BEHAVIOR_DEFAULT);
            }

            public Set<String> getScanProfiles() {
                return (Set)Configs.this.scanProfiles.getOrElse(Collections.emptySet());
            }

            public Set<String> getScanExcludeProfiles() {
                return (Set)Configs.this.scanExcludeProfiles.getOrElse(Collections.emptySet());
            }
        };
    }
}

