/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

public class GradleDependencyIndexCreator {
    private final Logger logger;

    public GradleDependencyIndexCreator(Logger logger) {
        this.logger = logger;
    }

    IndexView createIndex(PublishArtifactSet allArtifacts, FileCollection classesDirs) throws Exception {
        ArrayList<Map.Entry<PublishArtifact, Duration>> indexDurations = new ArrayList<Map.Entry<PublishArtifact, Duration>>();
        ArrayList artifacts = new ArrayList();
        if (allArtifacts != null) {
            artifacts.addAll(allArtifacts);
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (File f : classesDirs.getFiles()) {
            indexes.add(this.indexModuleClasses(f));
        }
        for (PublishArtifact artifact : artifacts) {
            try {
                if (artifact.getFile().isDirectory()) {
                    indexes.add(this.indexModuleClasses(artifact));
                    continue;
                }
                if (!artifact.getFile().getName().endsWith(".jar")) continue;
                Index artifactIndex = this.logger.isDebugEnabled() ? this.timedIndex(indexDurations, artifact) : this.index(artifact);
                indexes.add(artifactIndex);
            }
            catch (IOException | ExecutionException e) {
                this.logger.error("Can't compute index of {}, skipping", (Object)artifact.getFile().getAbsolutePath(), (Object)e);
            }
        }
        this.printIndexDurations(indexDurations);
        return CompositeIndex.create(indexes);
    }

    private Index index(PublishArtifact artifact) throws IOException {
        Result result = JarIndexer.createJarIndex((File)artifact.getFile(), (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
        return result.getIndex();
    }

    private void printIndexDurations(List<Map.Entry<PublishArtifact, Duration>> indexDurations) {
        if (this.logger.isDebugEnabled()) {
            indexDurations.sort(Map.Entry.comparingByValue());
            indexDurations.forEach(e -> {
                if (((Duration)e.getValue()).toMillis() > 25L) {
                    PublishArtifact artifact = (PublishArtifact)e.getKey();
                    this.logger.debug("Indexing took {} for {}, {}, {}, {}, {}, {}", new Object[]{e.getValue(), artifact.getName(), artifact.getExtension(), artifact.getClassifier(), artifact.getType(), artifact.getDate(), artifact.getFile()});
                }
            });
        }
    }

    private IndexView timedIndex(List<Map.Entry<PublishArtifact, Duration>> indexDurations, PublishArtifact artifact) throws Exception {
        LocalDateTime start = LocalDateTime.now();
        Index result = this.index(artifact);
        LocalDateTime end = LocalDateTime.now();
        Duration duration = Duration.between(start, end);
        indexDurations.add(new AbstractMap.SimpleEntry<PublishArtifact, Duration>(artifact, duration));
        return result;
    }

    private Index indexModuleClasses(PublishArtifact artifact) throws IOException {
        return this.indexModuleClasses(artifact.getFile());
    }

    private Index indexModuleClasses(File file) throws IOException {
        Indexer indexer = new Indexer();
        if (file.exists()) {
            try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
                List classFiles = stream.filter(path -> path.toString().endsWith(".class")).collect(Collectors.toList());
                for (Path path2 : classFiles) {
                    indexer.index(Files.newInputStream(path2, new OpenOption[0]));
                }
            }
        }
        return indexer.complete();
    }
}

