/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.servers;

import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class ServerIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Server, V, A, O, AB, OB> {
    private static final String PROP_VARIABLES = "variables";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_URL = "url";

    public ServerIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SERVER, Names.create(Server.class));
    }

    public List<Server> readList(AnnotationTarget target) {
        return this.readList((V)this.getRepeatableAnnotations(target));
    }

    public List<Server> readList(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readList).orElse(null);
    }

    public List<Server> readList(AnnotationInstance[] annotations) {
        return this.readList((V)Arrays.asList(annotations));
    }

    public List<Server> readList(Collection<AnnotationInstance> annotations) {
        IoLogging.logger.annotationsArray("@Server");
        return annotations.stream().map(this::read).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Server read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Server");
        ServerImpl server = new ServerImpl();
        server.setUrl((String)this.value(annotation, PROP_URL));
        server.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        server.setVariables(this.serverVariableIO().readMap(annotation.value(PROP_VARIABLES)));
        server.setExtensions(this.extensionIO().readExtensible(annotation));
        return server;
    }

    public List<Server> readList(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isArray).map(this.jsonIO()::asArray).map(this.jsonIO()::entries).map(Collection::stream).map(elements -> {
            IoLogging.logger.jsonArray("Server");
            return elements.filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).collect(Collectors.toCollection(ArrayList::new));
        }).orElse(null);
    }

    @Override
    public Server readObject(O node) {
        IoLogging.logger.singleJsonNode("Server");
        ServerImpl server = new ServerImpl();
        server.setUrl(this.jsonIO().getString(node, PROP_URL));
        server.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        server.setVariables(this.serverVariableIO().readMap(this.jsonIO().getValue(node, PROP_VARIABLES)));
        server.setExtensions(this.extensionIO().readMap(node));
        return server;
    }

    @Override
    public Optional<A> write(List<Server> models) {
        return this.optionalJsonArray(models).map(array -> {
            models.forEach(model -> {
                Object entry = this.jsonIO().createObject();
                this.write((Server)model, entry);
                this.jsonIO().add(array, this.jsonIO().buildObject(entry));
            });
            return array;
        }).map(this.jsonIO()::buildArray);
    }

    @Override
    public Optional<O> write(Server model) {
        return this.optionalJsonObject(model).map(node -> {
            this.write(model, node);
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    private void write(Server model, OB node) {
        this.setIfPresent(node, PROP_URL, this.jsonIO().toJson(model.getUrl()));
        this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
        this.setIfPresent(node, PROP_VARIABLES, this.serverVariableIO().write(model.getVariables()));
        this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
    }
}

